/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.FormulaException;
import kd.bos.formula.excel.FunCall;
import kd.bos.formula.excel.FunCallExecutable;
import kd.bos.formula.excel.KDNumber;
import kd.bos.util.DisCardUtil;
import kd.bos.util.StringUtils;
import kd.bos.util.resource.Resources;
import kd.sdk.annotation.SdkPublic;
import org.apache.commons.lang3.time.DateUtils;

@SdkPublic
public abstract class FunDef
implements FunCallExecutable {
    private static final String PROJECT_NAME = "bos-formula";
    private static final String MONTH = "MONTH";
    private String name;
    private static HashMap<String, FunDef> defs = new HashMap();

    FunDef(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static void register(FunDef def) {
        FunDef.register(def.getName().toUpperCase(), def);
    }

    public static void register(String name, FunDef def) {
        defs.put(name.toUpperCase(), def);
    }

    public static void register(String name, final FunCallExecutable e) {
        if (e instanceof FunDef) {
            FunDef.register(name, (FunDef)e);
        } else {
            FunDef.register(new FunDef(name){

                @Override
                public Object execute(FunCall call, ExecuteContext context) {
                    return e.execute(call, context);
                }
            });
        }
    }

    public static void register(String[] names, FunCallExecutable e) {
        for (String name : names) {
            FunDef.register(name, e);
        }
    }

    public static boolean contains(String name) {
        return defs.containsKey(name.toUpperCase());
    }

    public static String[] getAllFuncNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(defs.keySet());
        Collections.sort(list);
        return list.toArray(new String[0]);
    }

    private static String myToString(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Date) {
            return new SimpleDateFormat("yyyy-MM-dd").format((Date)v);
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).toPlainString();
        }
        return v.toString();
    }

    private static SimpleDateFormat[] getDateFormats() {
        return new SimpleDateFormat[]{new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"), new SimpleDateFormat("yyyy-MM-dd"), new SimpleDateFormat("yyyy/MM/dd")};
    }

    private static Date myToDate(String v) {
        if (v == null) {
            return null;
        }
        SimpleDateFormat[] dateFormats = FunDef.getDateFormats();
        for (int i = 0; i < dateFormats.length; ++i) {
            try {
                return dateFormats[i].parse(v);
            }
            catch (ParseException e) {
                DisCardUtil.discard();
                continue;
            }
        }
        throw new FormulaException("Illegal date string:" + v);
    }

    private static Date myToDate(String v, String format) {
        if (v == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        try {
            return dateFormat.parse(v);
        }
        catch (ParseException e) {
            throw new FormulaException(e);
        }
    }

    private static Date myToDate(String v, String format, String timeZoneId) {
        if (v == null) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(format);
        dateFormat.setTimeZone(TimeZone.getTimeZone(timeZoneId));
        try {
            Date date = dateFormat.parse(v);
            return date;
        }
        catch (ParseException e) {
            throw new FormulaException(e);
        }
    }

    public static String replace(String str, String r, String replacement, int n) {
        if (replacement == null) {
            replacement = "";
        }
        if (r == null || r.equals("")) {
            return str;
        }
        int len = r.length();
        int rlen = replacement.length();
        int from = 0;
        for (int num = 0; num < n; ++num) {
            int pos = str.indexOf(r, from);
            if (pos < 0) {
                return str;
            }
            str = str.substring(0, pos) + replacement + str.substring(pos + len);
            from = pos + rlen;
        }
        return str;
    }

    public static String substitute(String text, String old_text, String new_text, int number) {
        if (new_text == null) {
            new_text = "";
        }
        if (old_text == null || old_text.equals("")) {
            return text;
        }
        int len = old_text.length();
        int rlen = new_text.length();
        int pos = 0;
        int from = 0;
        for (int num = 0; num < number; ++num) {
            pos = text.indexOf(old_text, from);
            if (pos < 0) {
                return text;
            }
            from = pos + len;
        }
        text = text.substring(0, pos) + new_text + text.substring(pos + len);
        return text;
    }

    private static Object round_(FunCall call, ExecuteContext context, int roundMode) {
        String name = call.getName();
        Expr[] exprs = call.getParams();
        if (exprs.length != 2) {
            throw new FormulaException(String.format(Resources.getString((String)"%1$s\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1a%2$s(<\u6570\u5b57>,<\u7cbe\u5ea6>)\u3002", (String)"FunDef_0", (String)PROJECT_NAME, (Object[])new Object[0]), name, name));
        }
        Object obj = exprs[0].execute(context);
        Object v2 = exprs[1].execute(context);
        if (obj == null) {
            return 0;
        }
        if (!(obj instanceof Number) || !(v2 instanceof Number)) {
            throw new FormulaException(name + Resources.getString((String)"\u51fd\u6570\u53c2\u6570\u5fc5\u987b\u4e3a\u6570\u5b57\u3002", (String)"FunDef_2", (String)PROJECT_NAME, (Object[])new Object[0]));
        }
        int scale = ((Number)v2).intValue();
        if (obj instanceof Integer || obj instanceof Long || obj instanceof BigInteger) {
            return obj;
        }
        if (obj instanceof BigDecimal) {
            BigDecimal r = ((BigDecimal)obj).setScale(scale, roundMode);
            if (scale > 0) {
                return r;
            }
            return r.intValue();
        }
        BigDecimal bd = new BigDecimal(obj.toString());
        BigDecimal r = bd.setScale(scale, roundMode);
        if (scale > 0) {
            return r.doubleValue();
        }
        return r.intValue();
    }

    private static void initFunctions() {
        FunDef.register(new FunDef("YEAR"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"YEAR\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aYEAR([\u65e5\u671f\u5b57\u6bb5])\u3002", (String)"FunDef_3", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object v = exprs[0].execute(context);
                if (v == null) {
                    return null;
                }
                if (v instanceof String) {
                    v = FunDef.myToDate((String)v);
                }
                if (!(v instanceof Date)) {
                    throw new FormulaException(Resources.getString((String)"YEAR\u51fd\u6570\u6761\u4ef6\u4ec5\u80fd\u4f7f\u7528\u65e5\u671f\u5b57\u6bb5\u3002", (String)"FunDef_4", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Date date = (Date)v;
                Calendar cal = Calendar.getInstance();
                cal.setTime(date);
                return cal.get(1);
            }
        });
        FunDef.register(new FunDef(MONTH){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"MONTH\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aMONTH([\u65e5\u671f\u5b57\u6bb5])\u3002", (String)"FunDef_5", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object o = exprs[0].execute(context);
                if (o == null) {
                    return null;
                }
                if (o instanceof String) {
                    o = FunDef.myToDate((String)o);
                }
                if (!(o instanceof Date)) {
                    throw new FormulaException(Resources.getString((String)"MONTH\u51fd\u6570\u6761\u4ef6\u4ec5\u80fd\u4f7f\u7528\u65e5\u671f\u5b57\u6bb5\u3002", (String)"FunDef_6", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Date date = (Date)o;
                Calendar cal = FunDef.getTimeZoneCalendar();
                cal.setTime(date);
                return cal.get(2) + 1;
            }
        });
        FunDef.register(new FunDef("DAY"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"DAY\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aDAY([\u65e5\u671f\u5b57\u6bb5])\u3002", (String)"FunDef_7", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object ob = exprs[0].execute(context);
                if (ob == null) {
                    return null;
                }
                if (ob instanceof String) {
                    ob = FunDef.myToDate((String)ob);
                }
                if (!(ob instanceof Date)) {
                    throw new FormulaException(Resources.getString((String)"DAY\u51fd\u6570\u6761\u4ef6\u4ec5\u80fd\u4f7f\u7528\u65e5\u671f\u5b57\u6bb5\u3002", (String)"FunDef_8", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Date date = (Date)ob;
                Calendar cal = FunDef.getTimeZoneCalendar();
                cal.setTime(date);
                return cal.get(5);
            }
        });
        FunDef.register(new FunDef("WEEK"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new FormulaException(Resources.getString((String)"WEEK\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aWEEK([\u65e5\u671f\u5b57\u6bb5],[\u83b7\u53d6\u8303\u56f4])\u3002", (String)"FunDef_60", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object ob = exprs[0].execute(context);
                Object type = exprs[1].execute(context);
                if (ob == null || type == null) {
                    return null;
                }
                if (ob instanceof String) {
                    ob = FunDef.myToDate((String)ob);
                }
                if (!(ob instanceof Date)) {
                    throw new FormulaException(Resources.getString((String)"WEEK\u51fd\u6570\u6761\u4ef6\u53ea\u63a5\u53d7\u65e5\u671f\u5b57\u6bb5\u3002", (String)"FunDef_61", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                int dateRange = 1;
                if (type instanceof Integer) {
                    dateRange = (Integer)type;
                }
                Date date = (Date)ob;
                Calendar cal = FunDef.getTimeZoneCalendar();
                cal.setTime(date);
                cal.setFirstDayOfWeek(2);
                if (dateRange == 2) {
                    return cal.get(4);
                }
                int weekNum = cal.get(3);
                int year = cal.get(1);
                Date theWeekStart = FunDef.getTheWeekStart(0, date);
                Calendar instance = Calendar.getInstance();
                instance.setTime(theWeekStart);
                Date theWeekEnd = FunDef.getTheWeekEnd(0, date);
                Calendar instance1 = Calendar.getInstance();
                instance1.setTime(theWeekEnd);
                instance1.add(5, -1);
                int yearStart = instance.get(1);
                int yearEnd = instance1.get(1);
                if (yearStart != yearEnd && year == yearStart) {
                    return 53;
                }
                return weekNum;
            }
        });
        FunDef.register(new FunDef("QUARTER"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"QUARTER\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aQUARTER([\u65e5\u671f])\u3002", (String)"FunDef_9", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object object = exprs[0].execute(context);
                if (object == null) {
                    return null;
                }
                if (object instanceof String) {
                    object = FunDef.myToDate((String)object);
                }
                if (!(object instanceof Date)) {
                    throw new FormulaException(Resources.getString((String)"QUARTER\u51fd\u6570\u7684\u6761\u4ef6\u4ec5\u80fd\u4f7f\u7528\u65e5\u671f\u3002", (String)"FunDef_10", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Date date = (Date)object;
                Calendar cal = FunDef.getTimeZoneCalendar();
                cal.setTime(date);
                int month = cal.get(2);
                return month / 3 + 1;
            }
        });
        FunDef.register(new FunDef("ROUND"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                return FunDef.round_(call, context, 4);
            }
        });
        FunDef.register(new FunDef("ROUNDUP"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                return FunDef.round_(call, context, 0);
            }
        });
        FunDef.register(new FunDef("ROUNDDOWN"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                return FunDef.round_(call, context, 1);
            }
        });
        FunDef.register(new FunDef("IF"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 3) {
                    throw new FormulaException(Resources.getString((String)"IF\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570\u3002\u683c\u5f0f\uff1aIF(\u6761\u4ef6\uff0c\u771f\u503c\uff0c\u5047\u503c)\u3002", (String)"FunDef_11", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object obje = exprs[0].execute(context);
                Boolean b = null;
                if (obje == null) {
                    b = Boolean.FALSE;
                } else if (obje instanceof Boolean) {
                    b = (Boolean)obje;
                } else {
                    throw new FormulaException(Resources.getString((String)"IF\u51fd\u6570\u7684\u6761\u4ef6\u5fc5\u987b\u4e3a\u5e03\u5c14\u503c\u3002", (String)"FunDef_12", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                if (b.booleanValue()) {
                    return exprs[1].execute(context);
                }
                return exprs[2].execute(context);
            }
        });
        FunDef.register(new String[]{"TEXT", "T", "STR", "STRING"}, new FunCallExecutable(){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                String name = call.getName();
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(String.format(Resources.getString((String)"%1$s\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1a%2$s(<\u503c>)\u3002", (String)"FunDef_13", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), name, name));
                }
                Object v1 = exprs[0].execute(context);
                if (v1 == null) {
                    return null;
                }
                return FunDef.myToString(v1);
            }
        });
        FunDef.register(new FunDef("LEFT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new FormulaException(Resources.getString((String)"LEFT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\u4e3a\uff1aLEFT(<\u5b57\u7b26\u4e32>,<\u957f\u5ea6>)\u3002", (String)"FunDef_15", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object b = exprs[0].execute(context);
                if (b == null) {
                    return null;
                }
                String str = FunDef.myToString(b);
                b = exprs[1].execute(context);
                if (!(b instanceof Number)) {
                    throw new FormulaException(Resources.getString((String)"LEFT\u51fd\u6570\u7b2c2\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"FunDef_16", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                int len = ((Number)b).intValue();
                if (len <= 0) {
                    throw new FormulaException(Resources.getString((String)"LEFT\u51fd\u6570\u7b2c2\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"FunDef_17", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                if (len > str.length()) {
                    len = str.length();
                }
                return str.substring(0, len);
            }
        });
        FunDef.register(new FunDef("RIGHT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new FormulaException(Resources.getString((String)"RIGHT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aRIGHT(<\u5b57\u7b26\u4e32>,<\u957f\u5ea6>)\u3002", (String)"FunDef_18", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object v2 = exprs[0].execute(context);
                if (v2 == null) {
                    return null;
                }
                String str = FunDef.myToString(v2);
                v2 = exprs[1].execute(context);
                if (!(v2 instanceof Number)) {
                    throw new FormulaException(Resources.getString((String)"RIGHT\u51fd\u6570\u7684\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"FunDef_19", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                int len = ((Number)v2).intValue();
                if (len <= 0) {
                    throw new FormulaException(Resources.getString((String)"RIGHT\u51fd\u6570\u7b2c2\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"FunDef_20", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                int len2 = str.length();
                int start = len2 - len;
                if (start <= 0) {
                    return str;
                }
                if (len + start > str.length()) {
                    len = str.length() - start;
                }
                return str.substring(start, start + len);
            }
        });
        FunDef.register(new String[]{"MID", "SUBSTR", "SUBSTRING"}, new FunCallExecutable(){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                String funcName = call.getName();
                Expr[] exprs = call.getParams();
                if (exprs.length != 3) {
                    throw new FormulaException(String.format(Resources.getString((String)"%1$s\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1a%2$s(text, start_num, len)\u3002", (String)"FunDef_21", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), funcName, funcName));
                }
                Object obj1 = exprs[0].execute(context);
                if (obj1 == null) {
                    return null;
                }
                String str = obj1.toString();
                obj1 = exprs[1].execute(context);
                int from = -1;
                if (!(obj1 instanceof Integer)) {
                    try {
                        from = Integer.parseInt(obj1.toString());
                    }
                    catch (Exception e) {
                        DisCardUtil.discard();
                    }
                } else {
                    from = (Integer)obj1;
                }
                if (from < 0) {
                    throw new FormulaException(Resources.getString((String)"start_num\u5fc5\u987b\u4e3a\u5927\u4e8e\u7b49\u4e8e0\u7684\u6574\u6570\u3002", (String)"FunDef_22", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                obj1 = exprs[2].execute(context);
                int len = -1;
                if (!(obj1 instanceof Integer)) {
                    try {
                        len = Integer.parseInt(obj1.toString());
                    }
                    catch (Exception e) {
                        DisCardUtil.discard();
                    }
                } else {
                    len = (Integer)obj1;
                }
                if (len <= 0) {
                    throw new FormulaException(Resources.getString((String)"len\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"FunDef_23", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                if (len + from > str.length()) {
                    len = str.length() - from;
                }
                return str.substring(from, from + len);
            }
        });
        FunDef.register(new FunDef("ABS"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"ABS\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aABS(<\u6570\u5b57>)\u3002", (String)"FunDef_24", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object obj2 = exprs[0].execute(context);
                if (obj2 == null) {
                    return null;
                }
                if (!(obj2 instanceof Number)) {
                    throw new FormulaException(Resources.getString((String)"ABS\u51fd\u6570\u7684\u53c2\u6570\u5fc5\u987b\u4e3a\u6570\u5b57\u3002", (String)"FunDef_25", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                if (((Number)obj2).doubleValue() > 0.0) {
                    return obj2;
                }
                String s = obj2.toString();
                BigDecimal v1 = new BigDecimal(s);
                if (v1.compareTo(BigDecimal.ZERO) >= 0) {
                    if (!(obj2 instanceof Double) && obj2 instanceof Float) {
                        return obj2;
                    }
                    if (!s.startsWith("-")) {
                        return obj2;
                    }
                }
                KDNumber n = new KDNumber((Number)obj2);
                n = n.multiply(Integer.valueOf("-1"));
                return n.getValue();
            }
        });
        FunDef.register(new FunDef("REPT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new FormulaException(Resources.getString((String)"REPT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aREPT(<\u5b57\u7b26\u4e32>,NUM)\u3002", (String)"FunDef_26", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object object1 = exprs[0].execute(context);
                if (object1 == null) {
                    return null;
                }
                String str = FunDef.myToString(object1);
                object1 = exprs[1].execute(context);
                if (!(object1 instanceof Number)) {
                    throw new FormulaException(Resources.getString((String)"REPT\u51fd\u6570\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"FunDef_27", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                int len = ((Number)object1).intValue();
                if (len <= 0) {
                    throw new FormulaException(Resources.getString((String)"REPT\u51fd\u6570\u7684\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"FunDef_28", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < len; ++i) {
                    sb.append(str);
                }
                return sb.toString();
            }
        });
        FunDef.register(new FunDef("TRIM"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"TRIM\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aTRIM(<\u5b57\u7b26\u4e32>)\u3002", (String)"FunDef_29", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object object2 = exprs[0].execute(context);
                if (object2 == null) {
                    return null;
                }
                String str = FunDef.myToString(object2);
                String trim = str.trim();
                while (trim.length() != str.length()) {
                    str = trim;
                    trim = 17.replace(str, "  ", " ", 100);
                }
                return trim;
            }
        });
        FunDef.register(new FunDef("LOWER"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"LOWER\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aLOWER(<\u5b57\u7b26\u4e32>)\u3002", (String)"FunDef_30", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object object3 = exprs[0].execute(context);
                if (object3 == null) {
                    return null;
                }
                String str = FunDef.myToString(object3);
                return str.toLowerCase();
            }
        });
        FunDef.register(new FunDef("UPPER"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"UPPER\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aUPPER(<\u5b57\u7b26\u4e32>)\u3002", (String)"FunDef_31", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object object4 = exprs[0].execute(context);
                if (object4 == null) {
                    return null;
                }
                String str = FunDef.myToString(object4);
                return str.toUpperCase();
            }
        });
        FunDef.register(new FunDef("FIND"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                int find;
                Expr[] exprs = call.getParams();
                if (exprs.length != 2 && exprs.length != 3) {
                    throw new FormulaException(Resources.getString((String)"FIND\u51fd\u6570\u9700\u89812-3\u4e2a\u53c2\u6570,\u683c\u5f0f(\u53c2\u8003Excel)\uff1aFIND(find_text, within_text, [start_num])", (String)"FunDef_32", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object object5 = exprs[0].execute(context);
                if (object5 == null) {
                    return 0;
                }
                String find_text = FunDef.myToString(object5);
                object5 = exprs[1].execute(context);
                if (object5 == null) {
                    return -1;
                }
                String within_text = FunDef.myToString(object5);
                int start_num = 0;
                if (exprs.length > 2) {
                    object5 = exprs[2].execute(context);
                    if (object5 instanceof Number) {
                        start_num = ((Number)object5).intValue();
                    }
                    if (start_num <= 0) {
                        start_num = 0;
                    }
                }
                if (start_num > within_text.length()) {
                    return -1;
                }
                if (start_num > 0) {
                    within_text = within_text.substring(start_num);
                }
                if ((find = within_text.indexOf(find_text)) < 0) {
                    return -1;
                }
                return start_num + find;
            }
        });
        FunDef.register(new String[]{"CONCAT", "CONCATENATE"}, new FunCallExecutable(){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                StringBuilder result = new StringBuilder();
                for (Expr expr : exprs) {
                    Object v = expr.execute(context);
                    if (v == null) continue;
                    result.append(FunDef.myToString(v));
                }
                return result.toString();
            }
        });
        FunDef.register(new String[]{"SUBSTITUTE", "REPLACE"}, new FunCallExecutable(){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                String funcName = call.getName();
                Expr[] exprs = call.getParams();
                if (exprs.length != 3 && exprs.length != 4) {
                    throw new FormulaException(String.format(Resources.getString((String)"%1$s\u51fd\u6570\u9700\u89813-4\u4e2a\u53c2\u6570,\u683c\u5f0f(\u53c2\u8003Excel)\uff1a%2$s(text ,old_text ,new_text [,instance_num])\u3002", (String)"FunDef_33", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), funcName, funcName));
                }
                Object object6 = exprs[0].execute(context);
                if (object6 == null) {
                    return null;
                }
                String str = FunDef.myToString(object6);
                object6 = exprs[1].execute(context);
                if (object6 == null) {
                    return str;
                }
                String old_text = FunDef.myToString(object6);
                object6 = exprs[2].execute(context);
                if (object6 == null) {
                    return "";
                }
                String new_text = FunDef.myToString(object6);
                if (exprs.length > 3) {
                    object6 = exprs[3].execute(context);
                    if (!(object6 instanceof Number)) {
                        throw new FormulaException(funcName + Resources.getString((String)"\u51fd\u6570\u7684\u7b2c4\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"FunDef_34", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                    }
                    int num = ((Number)object6).intValue();
                    if (num <= 0) {
                        throw new FormulaException(funcName + Resources.getString((String)"\u51fd\u6570\u7684\u7b2c4\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u5927\u4e8e0\u7684\u6574\u6570\u3002", (String)"FunDef_34", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                    }
                    return FunDef.substitute(str, old_text, new_text, num);
                }
                return FunDef.replace(str, old_text, new_text, Integer.MAX_VALUE);
            }
        });
        FunDef.register(new String[]{"DATEDIF", "DATEDIFF"}, new FunCallExecutable(){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                String funcName = call.getName();
                Expr[] exprs = call.getParams();
                if (exprs.length != 3) {
                    throw new FormulaException(String.format(Resources.getString((String)"%1$s\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570\uff1a%2$s(start_date,end_date,datepart),datepart\u53ef\u4ee5\u4e3aYear,Month,Day,Hour,Minute,Second\u3002", (String)"FunDef_35", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), funcName, funcName));
                }
                Object object7 = exprs[0].execute(context);
                Object object10 = exprs[1].execute(context);
                if (object7 == null && object10 == null) {
                    return 0;
                }
                if (object10 != null && object7 == null) {
                    return 1;
                }
                if (object10 == null && object7 != null) {
                    return -1;
                }
                if (object7 instanceof String) {
                    object7 = FunDef.myToDate((String)object7);
                }
                if (!(object7 instanceof Date)) {
                    throw new FormulaException(Resources.getString((String)"\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u975e\u7a7a\u65e5\u671f\u3002", (String)"FunDef_37", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Date date1 = (Date)object7;
                object7 = exprs[1].execute(context);
                if (object7 instanceof String) {
                    object7 = FunDef.myToDate((String)object7);
                }
                if (!(object7 instanceof Date)) {
                    throw new FormulaException(Resources.getString((String)"\u7b2c\u4e8c\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u975e\u7a7a\u65e5\u671f\u3002", (String)"FunDef_38", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Date date2 = (Date)object7;
                object7 = exprs[2].execute(context);
                if (object7 == null) {
                    Object object = object7 = exprs[2] == null ? null : exprs[2].toString();
                }
                if (object7 == null) {
                    throw new FormulaException(Resources.getString((String)"\u7b2c\u4e09\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u975e\u7a7a\u5173\u952e\u5b57\u3002", (String)"FunDef_39", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                String datepart = object7.toString().toUpperCase(Locale.ENGLISH);
                if ("YEAR".equals(datepart) || "YYYY".equals(datepart) || "YY".equals(datepart) || "Y".equals(datepart)) {
                    GregorianCalendar gc1 = new GregorianCalendar();
                    GregorianCalendar gc2 = new GregorianCalendar();
                    gc1.setTime(date1);
                    gc2.setTime(date2);
                    int monthdif = (gc2.get(1) - gc1.get(1)) * 12 + (gc2.get(2) - gc1.get(2));
                    int daydif = gc2.get(5) - gc1.get(5);
                    if (daydif < 0) {
                        if (monthdif > 0) {
                            --monthdif;
                        }
                    } else if (daydif > 0 && monthdif < 0) {
                        ++monthdif;
                    }
                    return monthdif / 12;
                }
                if (FunDef.MONTH.equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                    GregorianCalendar gc1 = new GregorianCalendar();
                    GregorianCalendar gc2 = new GregorianCalendar();
                    gc1.setTime(date1);
                    gc2.setTime(date2);
                    int monthdif = (gc2.get(1) - gc1.get(1)) * 12 + (gc2.get(2) - gc1.get(2));
                    int daydif = gc2.get(5) - gc1.get(5);
                    if (daydif < 0) {
                        if (monthdif > 0) {
                            --monthdif;
                        }
                    } else if (daydif > 0 && monthdif < 0) {
                        ++monthdif;
                    }
                    return monthdif;
                }
                if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                    return (date2.getTime() - date1.getTime()) / 86400000L;
                }
                if ("HOUR".equals(datepart) || "HH".equals(datepart) || "H".equals(datepart)) {
                    return (date2.getTime() - date1.getTime()) / 3600000L;
                }
                if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                    return (date2.getTime() - date1.getTime()) / 60000L;
                }
                if ("SECOND".equals(datepart) || "SS".equals(datepart) || "S".equals(datepart)) {
                    return (date2.getTime() - date1.getTime()) / 1000L;
                }
                throw new FormulaException(String.format(Resources.getString((String)"datepart\u4e0d\u5408\u6cd5:%s\u3002", (String)"FunDef_40", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), datepart));
            }
        });
        FunDef.register(new FunDef("DATEADD"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 3) {
                    throw new FormulaException(Resources.getString((String)"DATEADD\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff08\u53c2\u8003SQL\uff09\uff1aDATEADD(datepart,number,date)\u3002datepart\u53ef\u4ee5\u4e3aYear\u3001Month\u3001Day\u3001Hour\u3001Minute\u3001Second\u3002", (String)"FunDef_41", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object v = exprs[2].execute(context);
                if (v == null) {
                    return null;
                }
                if (v instanceof String) {
                    v = FunDef.myToDate((String)v);
                }
                if (!(v instanceof Date)) {
                    throw new FormulaException(Resources.getString((String)"\u7b2c\u4e09\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u65e5\u671f\u7c7b\u578b\u3002", (String)"FunDef_42", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Date date = (Date)v;
                v = exprs[1].execute(context);
                int value = (Integer)v;
                v = exprs[0].execute(context);
                if (v == null) {
                    v = exprs[0].toString();
                }
                if (v == null) {
                    throw new FormulaException(Resources.getString((String)"\u7b2c\u4e00\u4e2a\u53c2\u6570\u5fc5\u987b\u4e3a\u975e\u7a7a\u5b57\u7b26\u4e32\u3002", (String)"FunDef_43", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                String datepart = v.toString().toUpperCase(Locale.ENGLISH);
                if ("YEAR".equals(datepart) || "YY".equals(datepart) || "YYYY".equals(datepart)) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    cal.add(1, value);
                    return cal.getTime();
                }
                if (FunDef.MONTH.equals(datepart) || "MM".equals(datepart) || "M".equals(datepart)) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    cal.add(2, value);
                    return cal.getTime();
                }
                if ("DAY".equals(datepart) || "DD".equals(datepart) || "D".equals(datepart)) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    cal.add(6, value);
                    return cal.getTime();
                }
                if ("HOUR".equals(datepart) || "HH".equals(datepart)) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    cal.add(10, value);
                    return cal.getTime();
                }
                if ("MINUTE".equals(datepart) || "MI".equals(datepart) || "N".equals(datepart)) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    cal.add(12, value);
                    return cal.getTime();
                }
                if ("SECOND".equals(datepart) || "SS".equals(datepart) || "S".equals(datepart)) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTime(date);
                    cal.add(13, value);
                    return cal.getTime();
                }
                throw new FormulaException(String.format(Resources.getString((String)"datepart\u4e0d\u5408\u6cd5:%s\u3002", (String)"FunDef_40", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), datepart));
            }
        });
        FunDef.register(new FunDef("NOW"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Calendar cal = FunDef.getTimeZoneCalendar();
                cal.setTimeInMillis(System.currentTimeMillis());
                return cal.getTime();
            }
        });
        FunDef.register(new FunDef("TODAY"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(System.currentTimeMillis());
                int year = cal.get(1);
                int month = cal.get(2);
                int date = cal.get(5);
                return new Date(year - 1900, month, date);
            }
        });
        FunDef.register(new FunDef("LEN"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"LEN\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aLEN(<\u5b57\u7b26\u4e32>)\u3002", (String)"FunDef_44", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object object8 = exprs[0].execute(context);
                if (object8 == null) {
                    return 0;
                }
                return object8.toString().length();
            }
        });
        FunDef.register(new FunDef("INT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"INT\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aINT(<\u503c>)\u3002", (String)"FunDef_45", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object object9 = exprs[0].execute(context);
                if (object9 == null) {
                    return null;
                }
                if (object9 instanceof Integer || object9 instanceof Long || object9 instanceof BigInteger) {
                    return object9;
                }
                if (object9 instanceof Number) {
                    return ((Number)object9).intValue();
                }
                int i = 0;
                try {
                    i = (int)Double.parseDouble(object9.toString());
                }
                catch (Exception e) {
                    i = 0;
                }
                return i;
            }
        });
        FunDef.register(new FunDef("DATE"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length == 0) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(System.currentTimeMillis());
                    return cal.getTime();
                }
                if (exprs.length == 1) {
                    Object obj3 = exprs[0].execute(context);
                    if (obj3 == null) {
                        return null;
                    }
                    if (obj3 instanceof Date) {
                        return obj3;
                    }
                    String s = obj3.toString();
                    return FunDef.myToDate(s);
                }
                if (exprs.length != 3) {
                    throw new FormulaException(Resources.getString((String)"Date\u51fd\u6570\u9700\u89813\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aDate(year,month,day)\u3002", (String)"FunDef_46", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object obj4 = exprs[0].execute(context);
                if (obj4 == null) {
                    throw new FormulaException(Resources.getString((String)"\u201cyear\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FunDef_47", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                int year = -1;
                try {
                    year = Integer.parseInt(obj4.toString());
                }
                catch (Exception t) {
                    throw new FormulaException(Resources.getString((String)"\u201cyear\u201d\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"FunDef_48", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), t);
                }
                obj4 = exprs[1].execute(context);
                if (obj4 == null) {
                    throw new FormulaException(Resources.getString((String)"\u201cmonth\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FunDef_49", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                int month = -1;
                try {
                    month = Integer.parseInt(obj4.toString());
                }
                catch (Exception t) {
                    throw new FormulaException(Resources.getString((String)"month\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"FunDef_50", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), t);
                }
                obj4 = exprs[2].execute(context);
                if (obj4 == null) {
                    throw new FormulaException(Resources.getString((String)"\u201cday\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FunDef_51", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                int day = -1;
                try {
                    day = Integer.parseInt(obj4.toString());
                }
                catch (Exception t) {
                    throw new FormulaException(Resources.getString((String)"\u201cday\u201d\u5fc5\u987b\u4e3a\u6574\u6570\u3002", (String)"FunDef_52", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), t);
                }
                return new Date(year - 1900, month - 1, day);
            }
        });
        FunDef.register(new FunDef("TO_DATE"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                String timeZoneId;
                Expr[] exprs = call.getParams();
                if (exprs.length < 2) {
                    throw new FormulaException(Resources.getString((String)"TO_DATE\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\u3002\u683c\u5f0f\u4e3a\uff1aTO_DATE(STR, 'yyyy-MM-dd')\u3002", (String)"FunDef_53", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object obj5 = exprs[0].execute(context);
                if (obj5 == null) {
                    return null;
                }
                String format = (String)exprs[1].execute(context);
                String s = obj5.toString();
                if (obj5 instanceof Date) {
                    SimpleDateFormat format1 = new SimpleDateFormat(format);
                    s = format1.format(obj5);
                }
                String string = timeZoneId = exprs.length == 3 ? (String)exprs[2].execute(context) : "";
                if (StringUtils.isEmpty((String)timeZoneId)) {
                    return FunDef.myToDate(s, format);
                }
                return FunDef.myToDate(s, format, timeZoneId);
            }
        });
        FunDef.register(new FunDef("TO_CHAR"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new FormulaException(Resources.getString((String)"TO_CHAR\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aTO_CHAR(STR, 'yyyy-MM-dd')\u3002", (String)"FunDef_54", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object obj6 = exprs[0].execute(context);
                if (obj6 == null) {
                    return null;
                }
                if (!(obj6 instanceof Date)) {
                    throw new FormulaException(Resources.getString((String)"TO_CHAR\u7b2c\u4e00\u4e2a\u53c2\u6570\u9700\u8981\u4e3aDate\u7c7b\u578b\u3002", (String)"FunDef_55", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                String format = (String)exprs[1].execute(context);
                return new SimpleDateFormat(format).format((Date)obj6);
            }
        });
        FunDef.register(new String[]{"NUMBER", "VALUE"}, new FunCallExecutable(){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                String name = call.getName();
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(String.format(Resources.getString((String)"%1$s\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570,\u683c\u5f0f\uff1a%2$s(<\u5b57\u7b26\u4e32>)\u3002", (String)"FunDef_56", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]), name, name));
                }
                Object obj7 = exprs[0].execute(context);
                if (obj7 == null) {
                    return null;
                }
                if (obj7 instanceof Number) {
                    return obj7;
                }
                BigDecimal n = null;
                try {
                    n = new BigDecimal(obj7.toString());
                    if (n.compareTo(new BigDecimal(n.intValue())) == 0 && n.scale() == 0) {
                        return n.intValue();
                    }
                    if (n.compareTo(new BigDecimal(n.longValue())) == 0 && n.scale() == 0) {
                        return n.longValue();
                    }
                    return n.doubleValue();
                }
                catch (Exception e) {
                    return 0;
                }
            }
        });
        FunDef.register(new FunDef("JUDGE_STR_NULL"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 1) {
                    throw new FormulaException(Resources.getString((String)"JUDGE_STR_NULL\u51fd\u6570\u9700\u89811\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aJUDGE_STR_NULL(<\u6587\u672c\u7c7b\u5b57\u6bb5>)\u3002", (String)"FunDef_62", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object obj8 = exprs[0].execute(context);
                if (obj8 == null) {
                    return true;
                }
                if (obj8 instanceof String && StringUtils.isBlank((String)((String)obj8))) {
                    return true;
                }
                return false;
            }
        });
        FunDef.register(new FunDef("EMPTY_TO_INT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new FormulaException(Resources.getString((String)"EMPTY_TO_INT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aEMPTY_TO_INT(<\u7a7a\u503c\u5b57\u6bb5>,<\u6574\u6570>)\u3002", (String)"FunDef_57", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object obj8 = exprs[0].execute(context);
                if (obj8 != null) {
                    return obj8;
                }
                obj8 = exprs[1].execute(context);
                if (obj8 instanceof Number) {
                    return ((Number)obj8).intValue();
                }
                int i = 0;
                try {
                    i = (int)Double.parseDouble(obj8.toString());
                }
                catch (Exception e) {
                    i = 0;
                }
                return i;
            }
        });
        FunDef.register(new FunDef("EMPTY_TO_NUMBER"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new FormulaException(Resources.getString((String)"EMPTY_TO_NUMBER\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aEMPTY_TO_NUMBER(<\u7a7a\u503c\u5b57\u6bb5>,<\u6570\u503c>)\u3002", (String)"FunDef_58", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object obj9 = exprs[0].execute(context);
                if (obj9 != null) {
                    return obj9;
                }
                obj9 = exprs[1].execute(context);
                if (obj9 instanceof Number) {
                    return ((Number)obj9).doubleValue();
                }
                double i = 0.0;
                try {
                    i = Double.parseDouble(obj9.toString());
                }
                catch (Exception e) {
                    i = 0.0;
                }
                return i;
            }
        });
        FunDef.register(new FunDef("EMPTY_TO_TEXT"){

            @Override
            public Object execute(FunCall call, ExecuteContext context) {
                Expr[] exprs = call.getParams();
                if (exprs.length != 2) {
                    throw new FormulaException(Resources.getString((String)"EMPTY_TO_TEXT\u51fd\u6570\u9700\u89812\u4e2a\u53c2\u6570\uff0c\u683c\u5f0f\uff1aEMPTY_TO_TEXT(<\u7a7a\u5b57\u7b26\u4e32>,<\u5b57\u7b26\u4e32>)\u3002", (String)"FunDef_59", (String)FunDef.PROJECT_NAME, (Object[])new Object[0]));
                }
                Object o3 = exprs[0].execute(context);
                if (o3 != null) {
                    return o3;
                }
                o3 = exprs[1].execute(context);
                o3 = o3 == null ? "" : o3.toString();
                return o3;
            }
        });
    }

    public static FunDef getFunDef(String name) {
        return defs.get(name.toUpperCase());
    }

    private static Date getTheWeekStart(int amount, Date baseDate) {
        Calendar cal = FunDef.getFirstDayOfWeekByDate(baseDate, 2);
        return DateUtils.addDays((Date)cal.getTime(), (int)(0 + amount * 7));
    }

    private static Date getTheWeekEnd(int amount, Date baseDate) {
        Calendar cal = FunDef.getFirstDayOfWeekByDate(baseDate, 2);
        return DateUtils.addDays((Date)cal.getTime(), (int)(7 + amount * 7));
    }

    private static Calendar getFirstDayOfWeekByDate(Date baseDate, int firstDayOfWeek) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.setFirstDayOfWeek(firstDayOfWeek);
        int dayWeek = cal.get(7);
        if (firstDayOfWeek < dayWeek + 1) {
            cal.add(5, firstDayOfWeek - dayWeek);
        } else {
            cal.add(5, -dayWeek - (7 - firstDayOfWeek));
        }
        return cal;
    }

    private static Calendar getTimeZoneCalendar() {
        Calendar cal = Calendar.getInstance();
        try {
            Class<?> clazz = Class.forName("kd.bos.service.KDDateUtils");
            Method method = clazz.getMethod("getSysTimeZone", new Class[0]);
            cal.setTimeZone((TimeZone)method.invoke(null, new Object[0]));
        }
        catch (Exception e) {
            return cal;
        }
        return cal;
    }

    static {
        FunDef.initFunctions();
    }
}

