/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.ExprBase;
import kd.bos.formula.excel.Visitor;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class Literal
extends ExprBase {
    public int type;
    private Object o;
    public static final Literal emptyString = new Literal("", false);
    public static final Literal zero = new Literal(0);
    public static final Literal one = new Literal(1);
    public static final Literal doubleZero = new Literal(0.0);
    public static final Literal doubleOne = new Literal(1.0);
    public static final int TYPE_SYMBOL = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_DOUBLE = 3;
    public static final int TYPE_INTEGER = 4;
    public static final int TYPE_LONG = 5;

    private Literal(String s, boolean isSymbol) {
        this.o = s;
        this.type = isSymbol ? 1 : 2;
    }

    public static Literal createString(String s) {
        if (s.equals("")) {
            return emptyString;
        }
        return new Literal(s, false);
    }

    public static Literal createSymbol(String s) {
        return new Literal(s, true);
    }

    private Literal(Double d) {
        this.o = d;
        this.type = 3;
    }

    public static Literal create(Double d) {
        if (d == 0.0) {
            return doubleZero;
        }
        if (d == 1.0) {
            return doubleOne;
        }
        return new Literal(d);
    }

    private Literal(Integer i) {
        this.o = i;
        this.type = 4;
    }

    private Literal(Long l) {
        this.o = l;
        this.type = 5;
    }

    public static Literal create(Integer i) {
        if (i == 0) {
            return zero;
        }
        if (i == 1) {
            return one;
        }
        return new Literal(i);
    }

    public static Literal create(Long i) {
        if (i > Integer.MAX_VALUE) {
            return new Literal(i);
        }
        if (i.intValue() == 0) {
            return zero;
        }
        if (i.intValue() == 1) {
            return one;
        }
        return new Literal(i.intValue());
    }

    public Object clone() {
        return this;
    }

    public String stringValue() {
        if (this.type == 2) {
            String str = (String)this.o;
            return str.substring(1, str.length() - 1);
        }
        return this.o.toString();
    }

    public Object getValueObject() {
        if (this.type == 2) {
            return this.stringValue();
        }
        return this.o;
    }

    public String toString() {
        if (this.type == 2) {
            if (this.o == null) {
                return "''";
            }
            return "'" + this.o + "'";
        }
        return this.o.toString();
    }

    @Override
    public Object execute(ExecuteContext context) {
        return this.getValueObject();
    }

    @Override
    public void accept(Visitor vistor) {
        vistor.visit(this);
    }

    public int getType() {
        return this.type;
    }
}

