/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.formula.excel;

import java.util.ArrayList;
import java.util.List;
import kd.bos.formula.excel.CompoundId;
import kd.bos.formula.excel.ExecuteContext;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.Visitor;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class VerifyVisitor
implements Visitor {
    private ArrayList<String> validSymbols = new ArrayList();
    private ArrayList<String> invalidSymbols = new ArrayList();
    private ExecuteContext ctx;

    public VerifyVisitor(ExecuteContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void visit(Expr expr) {
        if (expr instanceof CompoundId) {
            CompoundId id = (CompoundId)expr;
            String key = id.toString();
            if (!this.ctx.contains(key) && !this.invalidSymbols.contains(key)) {
                this.invalidSymbols.add(key);
            } else if (!this.validSymbols.contains(key)) {
                this.validSymbols.add(key);
            }
        }
    }

    public List<String> getInvalidSymboList() {
        return this.invalidSymbols;
    }

    public List<String> getValidSymboList() {
        return this.validSymbols;
    }
}

