/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.devenv;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import kd.bos.devenv.InitListener;
import kd.bos.httpsse.server.HttpUtils;
import kd.bos.security.KDSecurityManager;
import kd.bos.util.DisCardUtil;
import kd.bos.util.WebPortUtil;

public abstract class AbstractInit {
    private List<InitListener> ls = new ArrayList<InitListener>();

    public abstract void start();

    public void addInitListener(InitListener l) {
        this.ls.add(l);
    }

    protected void fireStarted() {
        if (!this.ls.isEmpty()) {
            for (InitListener l : this.ls) {
                l.started();
            }
        }
    }

    protected void fireStartedWaitForWeb() {
        if (!this.ls.isEmpty()) {
            new Thread(){

                @Override
                public void run() {
                    int port = Integer.parseInt(WebPortUtil.getWebPort((String)"8080"));
                    if (AbstractInit.this.waitForHostConnectable("localhost", port)) {
                        AbstractInit.this.fireStarted();
                    }
                }
            }.start();
        }
    }

    private boolean waitForHostConnectable(String host, int port) {
        while (!this.isHostConnectable(host, port)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHostConnectable(String host, int port) {
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (IOException e) {
                DisCardUtil.discard();
            }
        }
        return true;
    }

    static {
        Class<HttpUtils> clazz = HttpUtils.class;
        KDSecurityManager.initialize();
    }
}

