/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kws;

import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;

public class KWSDomainUrlInterceptor
extends AbstractInDatabindingInterceptor {
    private static Log log = LogFactory.getLog(KWSDomainUrlInterceptor.class);

    public KWSDomainUrlInterceptor() {
        super("user-stream");
    }

    public void handleMessage(Message message) throws Fault {
        Object httpRequest = message.get((Object)"HTTP.REQUEST");
        if (httpRequest != null && httpRequest.toString().contains("?wsdl")) {
            if (RequestContext.get() == null) {
                log.error("cannot rewrite kws wsdl description with the domainContextUrl, cause: RequestContext.get() is null");
            } else {
                String contextUrl = UrlService.getDomainContextUrl();
                String basepath = message.get((Object)"http.base.path").toString();
                String requestUrl = message.get((Object)"org.apache.cxf.request.url").toString();
                String newUrl = requestUrl.replace(basepath, contextUrl);
                message.put((Object)"org.apache.cxf.request.url", (Object)newUrl);
            }
        }
    }
}

