/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.framework.lifecycle;

import java.util.ArrayList;
import kd.bos.env.Env;
import kd.bos.framework.lifecycle.MicroKernelServiceConfig;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.ServiceItem;
import kd.bos.framework.lifecycle.SysServiceLayer;
import kd.bos.util.SafeLogUtils;

public class MicroKernelSysServiceLayer
implements SysServiceLayer {
    public Service[] loadService() {
        return MicroKernelServiceConfig.getAllServices();
    }

    public String getWebReousrceXmlPath() {
        return "microKernel/web.xml";
    }

    public boolean isRegisterDefaultInterface() {
        return false;
    }

    public boolean isNeedDebugModel() {
        return false;
    }

    public boolean isMicroKernel() {
        return true;
    }

    public String getConfigureClassName() {
        return "kd.bos.config.client.impl.MicroKernelConfigurationFactory";
    }

    public ServiceItem[] loadServiceItem() {
        if (Env.isMicroKernel()) {
            String tianshuService = System.getProperty("tianshu.service", "kd.bos.ha.HAService");
            if (tianshuService.indexOf("kd.bos.ha.HAService") < 0) {
                tianshuService = tianshuService + ";kd.bos.ha.HAService";
            }
            String[] splits = tianshuService.split(",|;");
            ArrayList<ServiceItem> ls = new ArrayList<ServiceItem>(2);
            for (String si : splits) {
                ServiceItem serviceItem = new ServiceItem(si, si);
                try {
                    Class<?> clazz = Class.forName(serviceItem.getClassName());
                    Object instance = clazz.newInstance();
                    if (instance instanceof Service) {
                        serviceItem.setInstance((Service)instance);
                    }
                    ls.add(serviceItem);
                }
                catch (Exception e) {
                    SafeLogUtils.error(this.getClass(), (String)"load serviceitem error", (Throwable)e);
                }
            }
            return ls.toArray(new ServiceItem[0]);
        }
        return null;
    }

    static {
        System.setProperty("isTianshu", "true");
    }
}

