/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.impl;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.impl.ThreadPoolExecutor;
import kd.bos.unifiedthreadpool.tasktype.TaskType;

public class ThreadPoolExecutorWrap
implements ThreadExecutorService {
    private ThreadPoolExecutor executor;

    public ThreadPoolExecutorWrap(ThreadPoolExecutor executor) {
        this.executor = executor;
    }

    public ThreadPoolExecutor delegate() {
        return this.executor;
    }

    public void execute(Runnable command, String registeredTaskTypeName, RequestContext context) {
        this.execute(command, registeredTaskTypeName, context, null);
    }

    @Override
    public void execute(Runnable command, String registeredTaskTypeName, RequestContext context, OperationContext oc) {
        RequestContext rc = context == null ? RequestContextCreator.createForThreadPool() : context;
        this.executor.execute(ThreadLifeCycleManager.wrapRunnable(() -> {
            RequestContextCreator.restoreForThreadPool((RequestContext)rc);
            try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)"execute");){
                span.addTag("threadName", Thread.currentThread().getName());
                span.addTag("tenantId", rc.getTenantId());
                span.addTag("accountId", rc.getAccountId());
                if (oc != null) {
                    OperationContext.set((OperationContext)oc);
                    span.addTag("appId", oc.getAppId());
                }
                command.run();
            }
        }), registeredTaskTypeName);
    }

    public void execute(Runnable command, String registeredTaskTypeName) {
        this.execute(command, registeredTaskTypeName, RequestContextCreator.createForThreadPool());
    }

    public <T> Future<T> submit(Callable<T> task, String registeredTaskTypeName, RequestContext context) {
        return this.submit(task, registeredTaskTypeName, context, null);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, String registeredTaskTypeName, RequestContext context, OperationContext oc) {
        RequestContext rc = context == null ? RequestContextCreator.createForThreadPool() : context;
        return this.executor.submit(ThreadLifeCycleManager.wrapCallable(() -> {
            RequestContextCreator.restoreForThreadPool((RequestContext)rc);
            try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)"submit");){
                span.addTag("threadName", Thread.currentThread().getName());
                span.addTag("tenantId", rc.getTenantId());
                span.addTag("accountId", rc.getAccountId());
                if (oc != null) {
                    OperationContext.set((OperationContext)oc);
                    span.addTag("appId", oc.getAppId());
                }
                Object v = task.call();
                return v;
            }
        }), registeredTaskTypeName);
    }

    @Override
    public void addTaskType(TaskType taskType) {
        this.executor.addTaskType(taskType);
    }

    @Override
    public void removeTaskType(String registeredTaskTypeName) {
        this.executor.removeTaskType(registeredTaskTypeName);
    }

    @Override
    public TaskType getTaskType(String registeredTaskTypeName) {
        return this.executor.getTaskType(registeredTaskTypeName);
    }

    @Override
    public List<TaskType> getAllTaskType() {
        return this.executor.getAllTaskType();
    }

    public <T> Future<T> submit(Callable<T> task, String registeredTaskTypeName) {
        return this.submit(task, registeredTaskTypeName, RequestContextCreator.createForThreadPool());
    }

    public Future<?> submit(Runnable task, String registeredTaskTypeName, RequestContext context) {
        return this.submit(task, registeredTaskTypeName, context, null);
    }

    public Future<?> submit(Runnable task, String registeredTaskTypeName, RequestContext context, OperationContext oc) {
        RequestContext rc = context == null ? RequestContextCreator.createForThreadPool() : context;
        return this.executor.submit(ThreadLifeCycleManager.wrapRunnable(() -> {
            RequestContextCreator.restoreForThreadPool((RequestContext)rc);
            try (TraceSpan span = Tracer.create((String)"ThreadPool", (String)"submit");){
                span.addTag("threadName", Thread.currentThread().getName());
                span.addTag("tenantId", rc.getTenantId());
                span.addTag("accountId", rc.getAccountId());
                if (oc != null) {
                    OperationContext.set((OperationContext)oc);
                    span.addTag("appId", oc.getAppId());
                }
                task.run();
            }
        }), registeredTaskTypeName);
    }

    public Future<?> submit(Runnable task, String registeredTaskTypeName) {
        return this.submit(task, registeredTaskTypeName, RequestContextCreator.createForThreadPool());
    }

    public static ThreadPoolExecutorWrap wrap(ThreadPoolExecutor executor) {
        return new ThreadPoolExecutorWrap(executor);
    }
}

