/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.tasktype;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.unifiedthreadpool.queue.VariableLinkedBlockingQueue;
import kd.bos.unifiedthreadpool.tasktype.Priority;
import kd.bos.unifiedthreadpool.tasktype.TaskType;
import kd.bos.unifiedthreadpool.tasktype.ThreadLimitedModel;

public class FullTaskType
extends TaskType {
    private static ThreadLocal<Boolean> formQueue = new ThreadLocal();
    private volatile AtomicBoolean delFlag = new AtomicBoolean(false);
    private volatile AtomicInteger activeThreadCount = new AtomicInteger(0);
    private VariableLinkedBlockingQueue<Runnable> taskQueue = new VariableLinkedBlockingQueue(1000);
    private volatile AtomicLong executedTotalCount = new AtomicLong(0L);
    private volatile AtomicLong rejectedTotalCount = new AtomicLong(0L);
    private volatile AtomicLong executedTotalMilliTime = new AtomicLong(0L);
    private volatile AtomicLong inQueueTotalMilliTime = new AtomicLong(0L);
    private int maxThreadNum = 2;
    private float maxThreadRate;
    private boolean canRun = true;
    private Priority priority;

    private FullTaskType() {
    }

    public boolean isFromQueue() {
        Boolean b = formQueue.get();
        return b == null ? false : b;
    }

    public void setQueueTag() {
        formQueue.set(true);
    }

    public void removeQueueTag() {
        formQueue.remove();
    }

    public boolean isDeleted() {
        return this.delFlag.get();
    }

    public void delete() {
        this.delFlag.set(true);
    }

    public int size() {
        return this.taskQueue.size();
    }

    @Override
    public int getTaskQueueMaxSize() {
        return this.taskQueueMaxSize;
    }

    @Override
    public FullTaskType setTaskQueueMaxSize(int taskQueueMaxSize) {
        this.taskQueueMaxSize = taskQueueMaxSize;
        this.taskQueue.setCapacity(taskQueueMaxSize);
        return this;
    }

    public ThreadLimitedModel getLimitType() {
        return this.threadLimitedModel;
    }

    public FullTaskType setLimitType(ThreadLimitedModel limitType) {
        this.threadLimitedModel = limitType;
        return this;
    }

    public float getMaxThreadRate() {
        return this.maxThreadRate;
    }

    public FullTaskType setMaxThreadRate(float maxThreadRate) {
        this.maxThreadRate = maxThreadRate;
        return this;
    }

    public int getMaxThreadNum() {
        return this.maxThreadNum;
    }

    public FullTaskType setMaxThreadNum(int maxThreadNum) {
        this.maxThreadNum = maxThreadNum;
        return this;
    }

    @Override
    public Priority getPriority() {
        return this.priority;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FullTaskType setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public boolean isCanRun() {
        return this.canRun;
    }

    @Override
    public FullTaskType setCanRun(boolean canRun) {
        this.canRun = canRun;
        return this;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public FullTaskType setImmutable(boolean immutable) {
        this.immutable = immutable;
        return this;
    }

    @Override
    public FullTaskType setPriority(Priority priority) {
        this.priority = priority;
        return this;
    }

    public static FullTaskType build() {
        return new FullTaskType();
    }

    public static FullTaskType newTaskTypeFor(TaskType taskType) {
        boolean isNum;
        FullTaskType type = FullTaskType.build().setName(taskType.getName()).setPriority(taskType.getPriority()).setTaskQueueMaxSize(taskType.getTaskQueueMaxSize()).setLimitType(taskType.getThreadLimitedModel()).setImmutable(taskType.isImmutable());
        boolean bl = isNum = ThreadLimitedModel.NUMBER == taskType.getThreadLimitedModel();
        if (isNum) {
            type.setMaxThreadNum((Integer)taskType.getThreadLimitedValue());
        } else {
            type.setMaxThreadRate(Float.parseFloat(String.valueOf(taskType.getThreadLimitedValue())));
        }
        return type;
    }

    public static TaskType convert(FullTaskType fullTaskType) {
        TaskType taskType = new TaskType(fullTaskType.getName(), fullTaskType.getPriority(), fullTaskType.getThreadLimitedModel(), fullTaskType.getThreadLimitedValue(), fullTaskType.getTaskQueueMaxSize());
        taskType.setCanRun(fullTaskType.isCanRun());
        taskType.setImmutable(fullTaskType.isImmutable());
        return taskType;
    }

    public boolean offer(Runnable runnable) {
        if (!this.isCanRun() || this.isDeleted()) {
            return false;
        }
        return this.taskQueue.offer(runnable);
    }

    public boolean remove(Runnable runnable) {
        return this.taskQueue.remove(runnable);
    }

    public int drainTo(Collection<Runnable> c) {
        return this.taskQueue.drainTo(c);
    }

    public void incrementExecutedTotalCount() {
        this.executedTotalCount.incrementAndGet();
    }

    public void incrementRejectedTotalCount() {
        this.rejectedTotalCount.incrementAndGet();
    }

    public void decrementActiveThreadCount() {
        this.activeThreadCount.decrementAndGet();
    }

    public void incrementActiveThreadCount() {
        this.activeThreadCount.incrementAndGet();
    }

    public void addExecutedTotalMilliTime(long milliTime) {
        this.executedTotalMilliTime.addAndGet(milliTime);
    }

    public void addInQueueTotalMilliTime(long milliTime) {
        this.inQueueTotalMilliTime.addAndGet(milliTime);
    }

    public Runnable getTask() {
        if (this.activeThreadCount.get() < this.maxThreadNum) {
            return this.taskQueue.poll();
        }
        return null;
    }

    public boolean canSubmit() {
        return this.activeThreadCount.get() < this.maxThreadNum;
    }

    public Runnable pollTask() {
        return this.taskQueue.poll();
    }

    public long getRejectedTotalCount() {
        return this.rejectedTotalCount.get();
    }

    public long getExecutedTotalCount() {
        return this.executedTotalCount.get();
    }

    public int getActiveThreadCount() {
        return this.activeThreadCount.get();
    }

    public int getQueueSize() {
        return this.taskQueue.size();
    }

    public long getExecuteAvgMilliTime() {
        long avg = this.getExecutedTotalCount() == 0L ? 0L : this.executedTotalMilliTime.get() / this.getExecutedTotalCount();
        return avg;
    }

    public long getInQueueAvgMilliTime() {
        long avg = this.getExecutedTotalCount() == 0L ? 0L : this.inQueueTotalMilliTime.get() / this.getExecutedTotalCount();
        return avg;
    }
}

