/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.unifiedthreadpool.thread.CosmicThread;

public class DefaultThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private AtomicInteger threadNumber;
    private final String namePrefix;

    public DefaultThreadFactory(String cloudId, String name, AtomicInteger threadNumber) {
        this.threadNumber = threadNumber;
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = cloudId + "-" + name + "-pool-thread-";
    }

    @Override
    public CosmicThread newThread(Runnable r) {
        CosmicThread t = new CosmicThread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

