/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.unifiedthreadpool.utils;

import java.util.Collection;
import kd.bos.unifiedthreadpool.exception.PoolErrorCode;
import kd.bos.unifiedthreadpool.exception.UnifiedThreadPoolException;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssertWithLog {
    private static Logger logger = LoggerFactory.getLogger(AssertWithLog.class);

    private static String logStartModuleName(String errorFormat, Object ... errorParameters) {
        StringBuilder sb = new StringBuilder("pthreadpools,");
        sb.append(errorFormat);
        String msg = String.format(errorFormat, errorParameters);
        logger.error(msg);
        return msg;
    }

    public static boolean isNotNull(Object object, String errorFormat, Object ... errorParameters) {
        if (object == null) {
            AssertWithLog.logStartModuleName(errorFormat, errorParameters);
            return true;
        }
        return false;
    }

    public static boolean lte(Object fromObject, Object toObject, String errorFormat, Object ... errorParameters) {
        if (Long.parseLong(fromObject.toString()) > Long.parseLong(toObject.toString())) {
            AssertWithLog.logStartModuleName(errorFormat, errorParameters);
            return false;
        }
        return true;
    }

    public static boolean lteForFloat(Object fromObject, Object toObject, String errorFormat, Object ... errorParameters) {
        if (Float.parseFloat(fromObject.toString()) > Float.parseFloat(toObject.toString())) {
            AssertWithLog.logStartModuleName(errorFormat, errorParameters);
            return false;
        }
        return true;
    }

    public static boolean gte(Object fromObject, Object toObject, String errorFormat, Object ... errorParameters) {
        if (Long.parseLong(fromObject.toString()) < Long.parseLong(toObject.toString())) {
            AssertWithLog.logStartModuleName(errorFormat, errorParameters);
            return false;
        }
        return true;
    }

    public static void gteWithException(Object fromObject, Object toObject, String errorFormat, Object ... errorParameters) {
        if (Long.parseLong(fromObject.toString()) < Long.parseLong(toObject.toString())) {
            String error = AssertWithLog.logStartModuleName(errorFormat, errorParameters);
            throw new UnifiedThreadPoolException(PoolErrorCode.ILLEGAL_PARAMETER, error);
        }
    }

    public static void lteWithException(Object fromObject, Object toObject, String errorFormat, Object ... errorParameters) {
        if (Long.parseLong(fromObject.toString()) > Long.parseLong(toObject.toString())) {
            String error = AssertWithLog.logStartModuleName(errorFormat, errorParameters);
            throw new UnifiedThreadPoolException(PoolErrorCode.ILLEGAL_PARAMETER, error);
        }
    }

    public static boolean gteForFloat(Object fromObject, Object toObject, String errorFormat, Object ... errorParameters) {
        if (Float.parseFloat(fromObject.toString()) < Float.parseFloat(toObject.toString())) {
            AssertWithLog.logStartModuleName(errorFormat, errorParameters);
            return false;
        }
        return true;
    }

    public static void isNullWithException(Object object, String errorFormat, Object ... errorParameters) {
        if (object == null) {
            String error = AssertWithLog.logStartModuleName(errorFormat, errorParameters);
            throw new UnifiedThreadPoolException(PoolErrorCode.ILLEGAL_PARAMETER, error);
        }
    }

    public static boolean isNotEmpty(Object object, String errorFormat, Object ... errorParameters) {
        if (AssertWithLog.isNotNull(object, errorFormat, errorParameters)) {
            return true;
        }
        if (StringUtils.isEmpty((String)object.toString())) {
            AssertWithLog.logStartModuleName(errorFormat, errorParameters);
            return true;
        }
        return false;
    }

    public static boolean isNotEmpty(Collection object, String errorFormat, Object ... msgParameter) {
        if (object == null || object.size() == 0) {
            AssertWithLog.logStartModuleName(errorFormat, msgParameter);
            return true;
        }
        return false;
    }

    public static void isNotEmptyCollWithException(Collection object, String errorFormat, Object ... msgParameter) {
        if (object == null || object.size() == 0) {
            String msg = AssertWithLog.logStartModuleName(errorFormat, msgParameter);
            throw new UnifiedThreadPoolException(PoolErrorCode.ILLEGAL_PARAMETER, msg);
        }
    }

    public static void isNotEmptyWithException(Object object, String errorFormat, Object ... msgParameter) {
        AssertWithLog.isNullWithException(object, errorFormat, msgParameter);
        if (StringUtils.isEmpty((String)object.toString())) {
            String msg = AssertWithLog.logStartModuleName(errorFormat, msgParameter);
            throw new UnifiedThreadPoolException(PoolErrorCode.ILLEGAL_PARAMETER, msg);
        }
    }

    public static void isIllegalParameterWithException(Object object, String errorFormat, Object ... msgParameter) {
        AssertWithLog.isNullWithException(object, errorFormat, msgParameter);
        String msg = AssertWithLog.logStartModuleName(errorFormat, msgParameter);
        throw new UnifiedThreadPoolException(PoolErrorCode.ILLEGAL_PARAMETER, msg);
    }
}

