/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.crypto;

import com.google.common.collect.Maps;
import java.security.Provider;
import java.security.Security;
import java.util.Map;
import kd.bos.crypto.Encryptor;
import kd.bos.encrypt.EncryptException;
import kd.bos.extension.ExtensionFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptorFactory {
    private static final Logger log = LoggerFactory.getLogger(EncryptorFactory.class);
    private static final String REGEX = ",";
    private static final String DEFAULT_ENCRYPTORS = "kd.bos.crypto.impl.AESGCMEncryptor,kd.bos.crypto.impl.SM4GCMEncryptor";
    private static final Map<String, Encryptor> encryptorMap = Maps.newHashMap();

    private static void loadDefault(String classesStr) throws ClassNotFoundException {
        String[] encryptorsClazz;
        for (String clazz : encryptorsClazz = classesStr.split(REGEX)) {
            if (EncryptorFactory.load(Class.forName(clazz))) continue;
            log.warn("default implementation be overwritten, ensure this is you want. overwritten={}", (Object)clazz);
        }
    }

    private static void loadCumstom() {
        ExtensionFactory factory = ExtensionFactory.getExtensionFacotry(Encryptor.class);
        Map clazzMap = factory.getExtensionClasses();
        clazzMap.forEach((k, cls) -> EncryptorFactory.load(cls));
    }

    private static boolean load(Class<?> cls) {
        try {
            Encryptor me = (Encryptor)cls.newInstance();
            if (encryptorMap.get(me.transformation()) == null) {
                encryptorMap.putIfAbsent(me.transformation(), me);
                log.info("loaded implement: {}", (Object)cls.toString());
                return true;
            }
            return false;
        }
        catch (Exception e) {
            log.error("load impl class error", (Throwable)e);
            throw new EncryptException("load impl class error: " + e.getMessage());
        }
    }

    public static Map<String, Encryptor> getEncryptorMap() {
        return encryptorMap;
    }

    public static Encryptor getEncryptor(String algorithm) {
        Encryptor encryptor = encryptorMap.get(algorithm);
        if (encryptor == null) {
            throw new EncryptException("not support algorithm: " + algorithm);
        }
        return encryptor;
    }

    static {
        log.info("begin encryptor factory init");
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            EncryptorFactory.loadCumstom();
            EncryptorFactory.loadDefault(DEFAULT_ENCRYPTORS);
        }
        catch (Exception e) {
            throw new EncryptException(e);
        }
        log.info("all loaded:" + encryptorMap.toString());
    }
}

