/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.crypto.impl;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.crypto.Encryptor;
import kd.bos.crypto.impl.AbstractEncryptor;
import kd.bos.encrypt.EncryptException;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM4GCMEncryptor
extends AbstractEncryptor
implements Encryptor {
    private static final Logger log = LoggerFactory.getLogger(SM4GCMEncryptor.class);
    private final Object LOCKER = new Object();
    private static final String SM4 = "SM4";
    private static final String SM4_GCM_NoPadding = "SM4/GCM/NoPadding";
    private static final List<Integer> supportLength = Lists.newArrayList((Object[])new Integer[]{128});
    private static final int IV_LENGTH = 12;
    private Cipher cipher = Cipher.getInstance("SM4/GCM/NoPadding", "BC");

    @Override
    public synchronized Cipher getCipher() {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(SM4_GCM_NoPadding, "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            throw new EncryptException("create cipher error: " + e.getMessage(), e);
        }
        return cipher;
    }

    @Override
    public String transformation() {
        return SM4_GCM_NoPadding;
    }

    @Override
    public List<Integer> supportLength() {
        return supportLength;
    }

    @Override
    protected String result(byte[] iv, byte[] data) {
        return new String(Base64.encodeBase64((byte[])data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] encrypt0(String originalStr, byte[] keyBytes, byte[] ivBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException {
        byte[] cipherText;
        Object object = this.LOCKER;
        synchronized (object) {
            this.cipher.init(1, (Key)new SecretKeySpec(keyBytes, SM4), this.getIvSpec(ivBytes));
            cipherText = this.cipher.doFinal(originalStr.getBytes(Charsets.UTF_8));
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + ivBytes.length + cipherText.length);
        byteBuffer.putInt(ivBytes.length);
        byteBuffer.put(ivBytes);
        byteBuffer.put(cipherText);
        return byteBuffer.array();
    }

    @Override
    protected byte[] encrypt0(Cipher cipher, String originalStr, byte[] keyBytes, byte[] ivBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException {
        cipher.init(1, (Key)new SecretKeySpec(keyBytes, SM4), this.getIvSpec(ivBytes));
        byte[] cipherText = cipher.doFinal(originalStr.getBytes(Charsets.UTF_8));
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + ivBytes.length + cipherText.length);
        byteBuffer.putInt(ivBytes.length);
        byteBuffer.put(ivBytes);
        byteBuffer.put(cipherText);
        return byteBuffer.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String decrypt0(byte[] data, byte[] keyBytes, byte[] ivBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int ivLength = byteBuffer.getInt();
        ivBytes = new byte[ivLength];
        byteBuffer.get(ivBytes);
        byte[] cipherText = new byte[byteBuffer.remaining()];
        byteBuffer.get(cipherText);
        Object object = this.LOCKER;
        synchronized (object) {
            this.cipher.init(2, (Key)new SecretKeySpec(keyBytes, SM4), this.getIvSpec(ivBytes));
            return new String(this.cipher.doFinal(cipherText));
        }
    }

    @Override
    protected String decrypt0(Cipher cipher, byte[] data, byte[] keyBytes, byte[] ivBytes) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int ivLength = byteBuffer.getInt();
        ivBytes = new byte[ivLength];
        byteBuffer.get(ivBytes);
        byte[] cipherText = new byte[byteBuffer.remaining()];
        byteBuffer.get(cipherText);
        cipher.init(2, (Key)new SecretKeySpec(keyBytes, SM4), this.getIvSpec(ivBytes));
        return new String(cipher.doFinal(cipherText));
    }

    @Override
    protected byte[] getKeyFromString(String str, int length) throws EncryptException {
        if (str == null || str.length() < length / 8) {
            throw new EncryptException("The given SM4 key is too short.");
        }
        try {
            return str.substring(0, length / 8).getBytes(Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new EncryptException("An error has occurred when getting SM4 key", e);
        }
    }

    @Override
    protected byte[] getIvFromString(String str, int length) throws EncryptException {
        return null;
    }

    @Override
    protected byte[] getRandomIv() throws EncryptException {
        try {
            byte[] bytesIV = new byte[12];
            this.random.nextBytes(bytesIV);
            return bytesIV;
        }
        catch (Exception e) {
            throw new EncryptException("An error has occurred when getting random IvKey", e);
        }
    }

    private GCMParameterSpec getIvSpec(byte[] iv) {
        return new GCMParameterSpec(128, iv);
    }
}

