/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.core;

import kd.bos.encrypt.Encrypter;
import kd.bos.encrypt.core.MatchableEncrypter;

public class SmartEncrypter
implements Encrypter {
    private Encrypter defaultEncrypter;
    private MatchableEncrypter[] allEncrypters;

    public SmartEncrypter(Encrypter defaultEncrypter, MatchableEncrypter[] allEncrypters) {
        this.defaultEncrypter = defaultEncrypter;
        this.allEncrypters = allEncrypters;
    }

    @Override
    public String encode(String str) {
        if (str == null) {
            return null;
        }
        return this.defaultEncrypter.encode(str);
    }

    @Override
    public String decode(String str) {
        if (str == null) {
            return null;
        }
        for (MatchableEncrypter encrypter : this.allEncrypters) {
            if (!encrypter.match(str)) continue;
            return encrypter.decode(str);
        }
        return str;
    }

    @Override
    public boolean isEncrypted(String str) {
        if (str == null) {
            return false;
        }
        for (MatchableEncrypter encrypter : this.allEncrypters) {
            if (!encrypter.match(str)) continue;
            return true;
        }
        return false;
    }
}

