/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.impl;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class RSAEncrypterUtil {
    public static final String data = "hellow,chenbin";

    public static KeyPair genKeyPair(int keyLength) throws Exception {
        if (keyLength < 512) {
            keyLength = 512;
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keyLength);
        return keyPairGenerator.generateKeyPair();
    }

    public static KeyPair genKeyPair() throws Exception {
        return RSAEncrypterUtil.genKeyPair(1024);
    }

    public static byte[] encrypt(byte[] content, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        return cipher.doFinal(content);
    }

    public static byte[] decrypt(byte[] content, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        return cipher.doFinal(content);
    }

    public static byte[] encrypt(byte[] content, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKey);
        return cipher.doFinal(content);
    }

    public static byte[] decrypt(byte[] content, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        return cipher.doFinal(content);
    }

    public static PublicKey getPublicKey(String publicKey) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(publicKey.getBytes());
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(keySpec);
    }

    public static PrivateKey getPrivateKey(String privateKey) throws Exception {
        byte[] keyBytes = Base64.getDecoder().decode(privateKey.getBytes());
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(keySpec);
    }

    public static PublicKey getPublicKey(String modulusStr, String exponentStr) throws Exception {
        BigInteger modulus = new BigInteger(modulusStr);
        BigInteger exponent = new BigInteger(exponentStr);
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(modulus, exponent);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(publicKeySpec);
    }

    public static PrivateKey getPrivateKey(String modulusStr, String exponentStr) throws Exception {
        BigInteger modulus = new BigInteger(modulusStr);
        BigInteger exponent = new BigInteger(exponentStr);
        RSAPrivateKeySpec privateKeySpec = new RSAPrivateKeySpec(modulus, exponent);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static String encrypt(String content, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, publicKey);
        int splitLength = ((RSAPublicKey)publicKey).getModulus().bitLength() / 8 - 11;
        byte[][] arrays = RSAEncrypterUtil.splitBytes(content.getBytes(), splitLength);
        StringBuilder sb = new StringBuilder();
        for (byte[] array : arrays) {
            sb.append(RSAEncrypterUtil.bytesToHexString(cipher.doFinal(array)));
        }
        return sb.toString();
    }

    public static String decrypt(String content, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, privateKey);
        int splitLength = ((RSAPrivateKey)privateKey).getModulus().bitLength() / 8;
        byte[] contentBytes = RSAEncrypterUtil.hexString2Bytes(content);
        byte[][] arrays = RSAEncrypterUtil.splitBytes(contentBytes, splitLength);
        StringBuilder sb = new StringBuilder();
        for (byte[] array : arrays) {
            sb.append(new String(cipher.doFinal(array)));
        }
        return sb.toString();
    }

    public static String encrypt(String content, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, privateKey);
        int splitLength = ((RSAPrivateKey)privateKey).getModulus().bitLength() / 8 - 11;
        byte[][] arrays = RSAEncrypterUtil.splitBytes(content.getBytes(), splitLength);
        StringBuilder sb = new StringBuilder();
        for (byte[] array : arrays) {
            sb.append(RSAEncrypterUtil.bytesToHexString(cipher.doFinal(array)));
        }
        return sb.toString();
    }

    public static String decrypt(String content, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, publicKey);
        int splitLength = ((RSAPublicKey)publicKey).getModulus().bitLength() / 8;
        byte[] contentBytes = RSAEncrypterUtil.hexString2Bytes(content);
        byte[][] arrays = RSAEncrypterUtil.splitBytes(contentBytes, splitLength);
        StringBuilder sb = new StringBuilder();
        for (byte[] array : arrays) {
            sb.append(new String(cipher.doFinal(array)));
        }
        return sb.toString();
    }

    public static byte[][] splitBytes(byte[] bytes, int splitLength) {
        int y = bytes.length % splitLength;
        int x = y != 0 ? bytes.length / splitLength + 1 : bytes.length / splitLength;
        byte[][] arrays = new byte[x][];
        for (int i = 0; i < x; ++i) {
            byte[] array;
            if (i == x - 1 && bytes.length % splitLength != 0) {
                array = new byte[bytes.length % splitLength];
                System.arraycopy(bytes, i * splitLength, array, 0, bytes.length % splitLength);
            } else {
                array = new byte[splitLength];
                System.arraycopy(bytes, i * splitLength, array, 0, splitLength);
            }
            arrays[i] = array;
        }
        return arrays;
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            String sTemp = Integer.toHexString(0xFF & bytes[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] hexString2Bytes(String hex) {
        int len = hex.length() / 2;
        hex = hex.toUpperCase();
        byte[] result = new byte[len];
        char[] achar = hex.toCharArray();
        for (int i = 0; i < len; ++i) {
            int pos = i * 2;
            result[i] = (byte)(RSAEncrypterUtil.toByte(achar[pos]) << 4 | RSAEncrypterUtil.toByte(achar[pos + 1]) & 0xFF);
        }
        return result;
    }

    private static byte toByte(char c) {
        byte b = (byte)"0123456789ABCDEF".indexOf(c);
        return b;
    }
}

