/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.key;

import com.google.common.base.Charsets;
import java.security.SecureRandom;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.key.EncryptKeyFactory;
import kd.bos.encrypt.sm4.SM4Util;
import kd.bos.util.StringUtils;

public interface EncryptKeyManager {
    public static final SecureRandom secureRandom = new SecureRandom();
    public static final String ENCRYPT_IVKEY = "kd.bos.encrypt.encryptIvKey";

    public String getEncryptKey();

    default public String getEncryptIvKey() {
        if (this.isRandomIV()) {
            byte[] data = new byte[this.getIvLength() / 2];
            secureRandom.nextBytes(data);
            return SM4Util.getHexString(data);
        }
        String ivFromZK = System.getProperty(ENCRYPT_IVKEY);
        if (StringUtils.isEmpty((String)ivFromZK)) {
            ivFromZK = this.getEncryptKey();
        }
        if (ivFromZK == null || ivFromZK.length() < this.getIvLength()) {
            throw new EncryptException("The given iv is too short.");
        }
        return ivFromZK;
    }

    default public byte[] getEncryptIvByte() {
        if (this.isRandomIV()) {
            byte[] data = new byte[this.getIvLength()];
            secureRandom.nextBytes(data);
            return data;
        }
        String ivFromZKStr = System.getProperty(ENCRYPT_IVKEY);
        if (StringUtils.isEmpty((String)ivFromZKStr)) {
            ivFromZKStr = this.getEncryptKey();
        }
        if (ivFromZKStr == null || ivFromZKStr.length() < this.getIvLength()) {
            throw new EncryptException("The given iv is too short.");
        }
        byte[] ivFromZK = ivFromZKStr.substring(0, this.getIvLength()).getBytes(Charsets.UTF_8);
        return ivFromZK;
    }

    default public boolean isRandomIV() {
        return EncryptKeyFactory.isRandomIV();
    }

    default public int getIvLength() {
        return EncryptKeyFactory.getIvLength();
    }
}

