/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.pass;

import java.util.ArrayList;
import java.util.List;
import kd.bos.encrypt.api.FrameWorkServiceFactory;
import kd.bos.encrypt.pass.PasswordEncoder;
import kd.bos.encrypt.pass.encoder.DefaultEncoder;
import kd.bos.encrypt.pass.encoder.HundredThousandEncoder;
import kd.bos.encrypt.pass.encoder.MillionPasswordEncoder;
import kd.bos.encrypt.pass.encoder.TenThousandEncoder;

public class PasswordFactory {
    private static List<PasswordEncoder> coderList = new ArrayList<PasswordEncoder>(10);

    private static void register(PasswordEncoder encoder) {
        if (encoder != null) {
            coderList.add(encoder);
        }
    }

    public static PasswordEncoder getPasswordEncoder(String encyptPassword) {
        for (PasswordEncoder encoder : coderList) {
            if (!encoder.isNeedHandle(encyptPassword)) continue;
            return encoder;
        }
        return new DefaultEncoder();
    }

    public static PasswordEncoder getCurrentUsingPasswordEncoder() {
        PasswordEncoder returnValue = null;
        Integer currentValue = FrameWorkServiceFactory.getFrameWorkService().getIntegerPropertyOfTenant("secruty_password_pbkdf2_iterations", 1000);
        if (currentValue != null) {
            switch (currentValue) {
                case 10000: {
                    returnValue = new TenThousandEncoder();
                    break;
                }
                case 100000: {
                    returnValue = new HundredThousandEncoder();
                    break;
                }
                case 1000000: {
                    returnValue = new MillionPasswordEncoder();
                    break;
                }
                default: {
                    returnValue = new DefaultEncoder();
                }
            }
        }
        return returnValue;
    }

    static {
        PasswordFactory.register(new TenThousandEncoder());
        PasswordFactory.register(new HundredThousandEncoder());
        PasswordFactory.register(new MillionPasswordEncoder());
        PasswordFactory.register(new DefaultEncoder());
    }
}

