/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.encrypt.pass.encoder;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kd.bos.encrypt.pass.PasswordEncoder;
import kd.bos.util.HexUtils;

public class TenThousandEncoder
extends PasswordEncoder {
    private static final int SALT_BYTE_SIZE = 16;
    private static final int HASH_BIT_SIZE = 512;
    private static final int PBKDF2_ITERATIONS = 10000;
    private static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final String PASSWORD_PREFIX = "EN_TEN_T.";

    @Override
    public String encryptPassword(String password, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), HexUtils.fromHex(salt), 10000, 512);
        SecretKeyFactory f = SecretKeyFactory.getInstance(PBKDF2_ALGORITHM);
        return PASSWORD_PREFIX + HexUtils.toHex(f.generateSecret(spec).getEncoded());
    }

    @Override
    public String getPrefix() {
        return PASSWORD_PREFIX;
    }
}

