/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.util;

import com.google.common.base.Charsets;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.encrypt.EncryptException;
import kd.bos.encrypt.des.DESEncrypter;
import kd.bos.encrypt.lax.EncryptLax;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class EncryptUtils {
    private static String DES_ENCRYPT = "kd.bos.encrypt.des.DESEncrypterImpl";
    private static String ENCRYPT_LAX = "kd.bos.encrypt.impl.EncryptLaxImpl";

    private static DESEncrypter getCacheDESEncrypt() {
        return DESEncrypterHolder.desEncrypter;
    }

    public static EncryptLax getCacheEncryptLax() {
        return EncryptLaxHolder.encryptLax;
    }

    @Deprecated
    public static String encrypt(String xmlStr) {
        return EncryptUtils.getCacheDESEncrypt().encrypt(xmlStr);
    }

    @Deprecated
    public static String decrypt(String xmlStr) throws Exception {
        return EncryptUtils.getCacheDESEncrypt().decrypt(xmlStr);
    }

    @Deprecated
    public static byte[] TripleDES_CBC_Encrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        return EncryptUtils.getCacheDESEncrypt().TripleDES_CBC_Encrypt(sourceBuf, deskey, ivParam);
    }

    @Deprecated
    public static byte[] TripleDES_CBC_Decrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        return EncryptUtils.getCacheDESEncrypt().TripleDES_CBC_Decrypt(sourceBuf, deskey, ivParam);
    }

    @Deprecated
    public static byte[] DES_CBC_Encrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        return EncryptUtils.getCacheDESEncrypt().DES_CBC_Encrypt(sourceBuf, deskey, ivParam);
    }

    @Deprecated
    public static byte[] DES_CBC_Decrypt(byte[] sourceBuf, SecretKeySpec deskey, IvParameterSpec ivParam) throws Exception {
        return EncryptUtils.getCacheDESEncrypt().DES_CBC_Decrypt(sourceBuf, deskey, ivParam);
    }

    public static byte[] MD5Hash(byte[] buf, int offset, int length) throws Exception {
        return EncryptUtils.getCacheEncryptLax().MD_5_Hash(buf, offset, length);
    }

    public static String byte2hex(byte[] inStr) {
        StringBuilder out = new StringBuilder(inStr.length * 2);
        for (int n = 0; n < inStr.length; ++n) {
            String stmp = Integer.toHexString(inStr[n] & 0xFF);
            if (stmp.length() == 1) {
                out.append("0").append(stmp);
                continue;
            }
            out.append(stmp);
        }
        return out.toString();
    }

    public static byte[] addMD5(byte[] md5Byte, byte[] bodyByte) {
        return EncryptUtils.getCacheEncryptLax().addMD_5(md5Byte, bodyByte);
    }

    public static void getKeyIV(String encryptKey, byte[] key, byte[] iv) {
        EncryptUtils.getCacheEncryptLax().getKeyIV(encryptKey, key, iv);
    }

    public static PrivateKey restorePrivateKey(byte[] bytes) throws Exception {
        PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(pkcs);
    }

    public static String encryptWithEncodeBase64UTF8(String orginalContent, Key key) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        return EncryptUtils.getCacheEncryptLax().encryptWithEncodeBase64UTF8(orginalContent, key);
    }

    public static String encrypt(String key, String srcStr) {
        return EncryptUtils.getCacheDESEncrypt().encrypt(key, srcStr);
    }

    public static String decrypt(String key, String encStr) {
        return EncryptUtils.getCacheDESEncrypt().decrypt(key, encStr);
    }

    public static String encryptPSW(String strSrc) {
        return EncryptUtils.getCacheEncryptLax().encryptPSW(strSrc);
    }

    public static String encryptPSWWihtSHA256(String strSrc) {
        String strEncode = null;
        byte[] btKey = new byte[strSrc.getBytes(Charsets.UTF_8).length + 1];
        System.arraycopy(strSrc.getBytes(Charsets.UTF_8), 0, btKey, 0, strSrc.getBytes(Charsets.UTF_8).length);
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(btKey);
            byte[] btDigest = md.digest();
            strEncode = Base64.encodeBase64String((byte[])btDigest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return strEncode;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private static class EncryptLaxHolder {
        private static EncryptLax encryptLax;

        private EncryptLaxHolder() {
        }

        static {
            try {
                encryptLax = (EncryptLax)Class.forName(ENCRYPT_LAX).newInstance();
            }
            catch (Exception e) {
                throw new EncryptException(e);
            }
        }
    }

    private static class DESEncrypterHolder {
        private static DESEncrypter desEncrypter;

        private DESEncrypterHolder() {
        }

        static {
            try {
                desEncrypter = (DESEncrypter)Class.forName(DES_ENCRYPT).newInstance();
            }
            catch (Exception e) {
                throw new EncryptException(e);
            }
        }
    }
}

