/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.EhcacheStoreType;
import kd.bos.cache.FIFOCache;
import kd.bos.cache.LocalCacheMonitor;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.LocalSessionableCache;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.TempFileCacheType;
import kd.bos.cache.ehcache.EhcacheSessionableCache;
import kd.bos.cache.ehcache.EhcacheSessionlessCache;
import kd.bos.cache.ehcache.LocalSessionCacheRegionManger;
import kd.bos.cache.fifo.RedisFIFOCache;
import kd.bos.cache.redis.RedisSessionableCache;
import kd.bos.cache.redis.RedisSessionlessCache;
import kd.bos.cache.redis.RedisSessionlessNoTraceCache;
import kd.bos.cache.redis.XCacheWhiteListCacheWrapper;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import org.apache.log4j.Logger;

public class CacheFactoryImpl
extends CacheFactory {
    private static Logger logger = Logger.getLogger(CacheFactoryImpl.class);
    private LocalSessionableCache localSessionableCache = this.createLocalSessionableCache();
    private DistributeSessionlessCache distributeSessionlessCache = this.createDistributeSessionlessCache();
    private DistributeSessionableCache distributeSessionableCache = this.createDistributeSessionableCache();
    private static Map<String, LocalMemoryCache> localSessionlessCaches = new ConcurrentHashMap<String, LocalMemoryCache>();
    private static boolean isXCacheEnabled;
    private static Map<String, DistributeSessionlessCache> distributeSessionlessCaches;
    private static TempFileCache tempFileCacheInstance;
    private static volatile boolean fileServerSupport;

    private DistributeSessionlessCache createDistributeSessionlessCache() {
        return this.createDistributeSessionlessCache(null);
    }

    private DistributeSessionlessCache createDistributeSessionlessCache(String region) {
        if (CacheConfigKeys.isXCacheAutoSwitch() || isXCacheEnabled) {
            return new XCacheWhiteListCacheWrapper(region);
        }
        return new RedisSessionlessCache(region);
    }

    private DistributeSessionableCache createDistributeSessionableCache() {
        try {
            if (Boolean.getBoolean("ha.component.enable")) {
                String className = "kd.bos.cache.database.DistributeSessionCacheWrapper";
                return (DistributeSessionableCache)Class.forName(className).newInstance();
            }
            RedisSessionableCache cache = new RedisSessionableCache();
            return cache;
        }
        catch (Exception e) {
            RedisSessionableCache cache = new RedisSessionableCache();
            return cache;
        }
    }

    private LocalMemoryCache createLocalSessionlessCache(String region, EhcacheStoreType storeType) {
        EhcacheSessionlessCache cache = new EhcacheSessionlessCache(region, storeType);
        return cache;
    }

    private LocalSessionableCache createLocalSessionableCache() {
        EhcacheSessionableCache cache = new EhcacheSessionableCache();
        return cache;
    }

    public LocalSessionableCache getLocalSessionableCache() {
        return this.localSessionableCache;
    }

    @Override
    public DistributeSessionlessCache getDistributeSessionlessCache() {
        return this.distributeSessionlessCache;
    }

    public DistributeSessionableCache getDistributeSessionableCache() {
        return this.distributeSessionableCache;
    }

    public void sessionDestroyed(HttpSession session) {
        try {
            this.getLocalSessionableCache().remove(session.getId());
            logger.info((Object)("remove local session cache:" + session.getId()));
        }
        catch (Exception t) {
            logger.error((Object)t.getMessage(), (Throwable)t);
        }
    }

    @Override
    public LocalMemoryCache $getOrCreateLocalMemoryCache(String region, String type) {
        LocalMemoryCache cache = this._$getLocalSessionlessCache(region);
        return ((LocalSessionCacheRegionManger)cache).getOrCreateCache(type);
    }

    @Override
    public LocalMemoryCache $getOrCreateLocalMemoryCache(String region, String type, CacheConfigInfo cacheConfig) {
        LocalMemoryCache cache = this._$getLocalSessionlessCache(region);
        return ((LocalSessionCacheRegionManger)cache).getOrCreateCache(type, cacheConfig);
    }

    @Override
    public LocalMemoryCache $getOrCreateLocalMemoryCache(String region, String type, CacheConfigInfo cacheConfig, EhcacheStoreType storeType) {
        LocalMemoryCache cache = this._$getLocalSessionlessCache(region, storeType);
        return ((LocalSessionCacheRegionManger)cache).getOrCreateCache(type, cacheConfig);
    }

    @Override
    public LocalMemoryCache $createOrReplaceLocalMemoryCache(String region, String type, CacheConfigInfo cacheConfig) {
        LocalMemoryCache cache = this._$getLocalSessionlessCache(region);
        return ((LocalSessionCacheRegionManger)cache).createOrReplaceCache(type, cacheConfig);
    }

    private LocalMemoryCache _$getLocalSessionlessCache(String region) {
        return this._$getLocalSessionlessCache(region, EhcacheStoreType.Heap);
    }

    private LocalMemoryCache _$getLocalSessionlessCache(String region, EhcacheStoreType storeType) {
        if (null == region) {
            throw new KDException(BosErrorCode.nullError, new Object[]{"local memory cache`s region cann`t been null"});
        }
        String innerRegion = this.makeInnerRegion(region, storeType);
        LocalMemoryCache cache = localSessionlessCaches.computeIfAbsent(innerRegion, k -> this.createLocalSessionlessCache(innerRegion, storeType));
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DistributeSessionlessCache getDistributeSessionlessCache(String region) {
        if (region == null) {
            return this.distributeSessionlessCache;
        }
        DistributeSessionlessCache cache = distributeSessionlessCaches.get(region);
        if (cache == null) {
            Map<String, DistributeSessionlessCache> map = distributeSessionlessCaches;
            synchronized (map) {
                cache = distributeSessionlessCaches.get(region);
                if (cache == null) {
                    cache = this.createDistributeSessionlessCache(region);
                    distributeSessionlessCaches.put(region, cache);
                }
            }
        }
        return cache;
    }

    @Override
    public TempFileCache getTempFileCache() {
        if (tempFileCacheInstance != null) {
            this.check();
            return tempFileCacheInstance;
        }
        return CacheFactoryImpl.createTempFileCache(CacheFactoryImpl.getConfig());
    }

    private void check() {
        if (!fileServerSupport) {
            return;
        }
        String usedConfig = CacheFactoryImpl.getConfig();
        if (!TempFileCacheType.FILE_SERVER.getName().equals(usedConfig)) {
            return;
        }
        if (TempFileCacheType.FILE_SERVER.getName().equals(tempFileCacheInstance.type())) {
            return;
        }
        CacheFactoryImpl.createTempFileCache(usedConfig);
    }

    private static String getConfig() {
        String cacheTypeConfig = System.getProperty("tempfile.cachetype", "fileserver");
        if (TempFileCacheType.FILE_SERVER.getName().equals(cacheTypeConfig)) {
            try {
                boolean hasFileServiceExt = CacheFactoryImpl.hasFileServiceExt();
                boolean isDefault = CacheFactoryImpl.isDefault();
                if (!isDefault || hasFileServiceExt) {
                    cacheTypeConfig = TempFileCacheType.REDIS.getName();
                    logger.warn((Object)("Cannot be configured as fileserver because of isDefault=" + isDefault + " hasFileServiceExt=" + hasFileServiceExt));
                }
            }
            catch (Exception e) {
                logger.error((Object)"An error was encountered ", (Throwable)e);
                throw new KDException(BosErrorCode.bOSNotImplemented, new Object[]{e});
            }
        }
        return cacheTypeConfig;
    }

    private static TempFileCache createTempFileCache(String cacheTypeConfig) {
        String className = "";
        try {
            TempFileCache wrapper;
            TempFileCache tempFileCache = TempFileCacheType.REDIS.getName().equals(cacheTypeConfig) ? (TempFileCache)Class.forName(TempFileCacheType.REDIS.getClazz()).newInstance() : (TempFileCacheType.DISK.getName().equals(cacheTypeConfig) ? (TempFileCache)Class.forName(TempFileCacheType.DISK.getClazz()).newInstance() : CacheFactoryImpl.createFileServerTempFileCache());
            className = TempFileCacheType.of(tempFileCache.type()).getClazz();
            logger.info((Object)("Current TempFileCache type is " + tempFileCache.type()));
            Constructor<?> cacheConstructor = Class.forName("kd.bos.cache.tempfile.TempFileCacheWrapper").getConstructor(TempFileCache.class);
            tempFileCacheInstance = wrapper = (TempFileCache)cacheConstructor.newInstance(tempFileCache);
            return wrapper;
        }
        catch (Exception t) {
            logger.error((Object)"Could not create TempFileCache ", (Throwable)t);
            throw new KDException(BosErrorCode.bOSNotImplemented, className, (Throwable)t);
        }
    }

    private static TempFileCache createFileServerTempFileCache() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        TempFileCache tempFileCache;
        String className = TempFileCacheType.FILE_SERVER.getClazz();
        try {
            tempFileCache = (TempFileCache)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            if (e instanceof IllegalStateException) {
                logger.error((Object)e.getMessage());
                fileServerSupport = false;
            }
            logger.warn((Object)("Now change to redis, because of: " + e.getMessage()));
            tempFileCache = (TempFileCache)Class.forName(TempFileCacheType.REDIS.getClazz()).newInstance();
        }
        return tempFileCache;
    }

    private static boolean isDefault() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> cls = Class.forName("kd.bos.fileservice.FileServiceFactory");
        Method method = cls.getMethod("isDefaultAttachmentFileStorageClass", new Class[0]);
        return (Boolean)method.invoke(null, new Object[0]);
    }

    private static boolean hasFileServiceExt() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Class<?> extFactory = Class.forName("kd.bos.fileservice.extension.FileServiceExtFactory");
        Method hasAttachFileServiceExt = extFactory.getMethod("hasAttachFileServiceExt", new Class[0]);
        return (Boolean)hasAttachFileServiceExt.invoke(null, new Object[0]);
    }

    @Override
    public FIFOCache getFIFOCache() {
        return new RedisFIFOCache();
    }

    @Override
    public DistributeSessionlessCache getDistributeSessionlessCache(boolean trace) {
        if (trace) {
            return this.getDistributeSessionlessCache();
        }
        return new RedisSessionlessNoTraceCache(null);
    }

    @Override
    public DistributeSessionlessCache getDistributeSessionlessCache(String region, boolean trace) {
        if (trace) {
            return this.getDistributeSessionlessCache(region);
        }
        return new RedisSessionlessNoTraceCache(region);
    }

    @Override
    public DistributeSessionlessCache getDistributeSessionlessCache(String region, DistributeCacheHAPolicy distributeCacheHAPolicy) {
        String className = "kd.bos.cache.ha.adapter.CacheAdapterFactoryImpl";
        try {
            Class<?> cacheAdapterFactoryImpl = Class.forName(className);
            Method create = cacheAdapterFactoryImpl.getDeclaredMethod("create", DistributeCacheHAPolicy.class, String.class);
            DistributeSessionlessCache cache = (DistributeSessionlessCache)create.invoke(cacheAdapterFactoryImpl.newInstance(), distributeCacheHAPolicy, region);
            return cache;
        }
        catch (Exception e) {
            throw new KDException(BosErrorCode.bOSNotImplemented, className, (Throwable)e);
        }
    }

    @Override
    public LocalMemoryCache $getLocalMemoryCache(String region, String type) {
        LocalMemoryCache cache = this._$getLocalSessionlessCache(region);
        return ((LocalSessionCacheRegionManger)cache).getCache(type);
    }

    @Override
    public DistributeSessionableCache $getDistributeSessionableCache() {
        return this.distributeSessionableCache;
    }

    private String makeInnerRegion(String region, EhcacheStoreType storeType) {
        if (storeType == EhcacheStoreType.Heap) {
            return region;
        }
        return region + "-" + (Object)((Object)storeType);
    }

    static {
        LocalCacheMonitor.registryCacheMap(localSessionlessCaches);
        isXCacheEnabled = CacheConfigKeys.isXCacheClientEnabled();
        distributeSessionlessCaches = new ConcurrentHashMap<String, DistributeSessionlessCache>();
        fileServerSupport = true;
        CacheFactoryImpl.createTempFileCache(CacheFactoryImpl.getConfig());
    }
}

