/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheLoader;
import kd.bos.util.ThreadLocals;

public class ThreadCache
implements Closeable {
    private static ThreadLocal<ThreadCache> th = ThreadLocals.create(() -> new ThreadCache());
    private Map<Object, Object> map = new ConcurrentHashMap<Object, Object>();

    public static ThreadCache current() {
        return th.get();
    }

    public static void clear() {
        th.remove();
    }

    public static void put(Object key, Object value) {
        ThreadCache.current().map.put(key, value);
    }

    public static Object get(Object key) {
        return ThreadCache.current().map.get(key);
    }

    public static <T> T get(Object key, CacheLoader<T> loader) {
        return ThreadCache.get(key, loader, true);
    }

    public static <T> T get(Object key, CacheLoader<T> loader, boolean putToCache) {
        Object value = ThreadCache.current().map.get(key);
        if (value == null && (value = loader.load()) != null && putToCache) {
            ThreadCache.put(key, value);
        }
        return (T)value;
    }

    public static void remove(Object key) {
        ThreadCache.current().map.remove(key);
    }

    public static boolean exists(Object key) {
        return ThreadCache.current().map.containsKey(key);
    }

    private ThreadCache() {
    }

    @Override
    public void close() {
        this.map = null;
    }
}

