/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.WildCardMatcher;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.bos.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XCacheConfigManager {
    private static final Logger log = LoggerFactory.getLogger(XCacheConfigManager.class);
    private static volatile WildCardMatcher matcher;
    private static volatile boolean isXClientEnabled;
    private static volatile boolean hasXCacheDefaultRegionConfig;
    private static final Lock configUpdateLock;
    private static Map<String, Boolean> hasXCacheRegionConfigMap;
    private static Map<String, RegionConfigChangeListener> regionConfigChangeListenerMap;

    public static void register(String region) {
        if (region == null) {
            return;
        }
        XCacheConfigManager.updateRegionConfig(region);
        if (CacheConfigKeys.isXCacheAutoSwitch()) {
            XCacheConfigManager.registerRegionConfigListener(region);
        }
    }

    public static WildCardMatcher getMatcher() {
        return matcher;
    }

    public static boolean isXCacheEnabled(String region) {
        return isXClientEnabled && XCacheConfigManager.hasRegionConfig(region);
    }

    private static boolean hasRegionConfig(String region) {
        if (region == null) {
            return hasXCacheDefaultRegionConfig;
        }
        return hasXCacheDefaultRegionConfig || Boolean.TRUE.equals(hasXCacheRegionConfigMap.get(region));
    }

    private static void registerPublicConfigListener() {
        ConfigurationChangeListener listener = (key, newValue) -> {
            if (log.isDebugEnabled()) {
                log.debug(String.format("XCache config: [%s] value changed to [%s]", key, newValue));
            }
            XCacheConfigManager.updatePublicConfig();
        };
        ConfigurationUtil.observeChange((String)"xcache.client.enable", (ConfigurationChangeListener)listener);
        ConfigurationUtil.observeChange((String)"xcache.client.whitelist", (ConfigurationChangeListener)listener);
        ConfigurationUtil.observeChange((String)"xcache.client.serversForCache", (ConfigurationChangeListener)listener);
    }

    private static void registerRegionConfigListener(String region) {
        regionConfigChangeListenerMap.computeIfAbsent(region, r -> {
            RegionConfigChangeListener listener = new RegionConfigChangeListener((String)r);
            ConfigurationUtil.observeChange((String)CacheConfigKeys.getXCacheSessionlessConfigKey(region), (ConfigurationChangeListener)listener);
            return listener;
        });
    }

    private static void updateRegionConfig(String region) {
        configUpdateLock.lock();
        try {
            hasXCacheRegionConfigMap.put(region, CacheConfigKeys.hasXCacheConfiguration(region));
        }
        finally {
            configUpdateLock.unlock();
        }
    }

    private static void updatePublicConfig() {
        configUpdateLock.lock();
        try {
            matcher = WildCardMatcher.create(CacheConfigKeys.getXCacheWhiteList());
            isXClientEnabled = CacheConfigKeys.isXCacheClientEnabled();
            hasXCacheDefaultRegionConfig = StringUtils.isNotEmpty((String)CacheConfigKeys.getXCacheUrl(null));
        }
        finally {
            configUpdateLock.unlock();
        }
    }

    static {
        configUpdateLock = new ReentrantLock();
        hasXCacheRegionConfigMap = new ConcurrentHashMap<String, Boolean>();
        regionConfigChangeListenerMap = new ConcurrentHashMap<String, RegionConfigChangeListener>();
        XCacheConfigManager.updatePublicConfig();
        if (CacheConfigKeys.isXCacheAutoSwitch()) {
            XCacheConfigManager.registerPublicConfigListener();
        }
    }

    private static class RegionConfigChangeListener
    implements ConfigurationChangeListener {
        private final String region;

        public RegionConfigChangeListener(String region) {
            this.region = region;
        }

        public void onChange(Object key, Object newValue) {
            if (log.isDebugEnabled()) {
                log.debug(String.format("XCache config: [%s] value changed to [%s]", key, newValue));
            }
            XCacheConfigManager.updateRegionConfig(this.region);
        }
    }
}

