/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ehcache.syncstatus.BalesBroadcastInfo;
import kd.bos.cache.ehcache.syncstatus.BroadcastSender;
import kd.bos.cache.ehcache.syncstatus.MemoryCacheSyncStatusMange;
import kd.bos.cache.ehcache.syncstatus.SingleBroadcastItemInfo;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.util.JSONUtils;

public class EhcacheMemoryCacheClusterNotify {
    private static Class<?> broadcastClass;
    private static Method broadcastMessage;
    private static CacheFactory factory;
    private static Log logger;
    private static LinkedBlockingQueue<SingleBroadcastItemInfo> queue;
    private static final String TYPE = ",type=";
    private static ThreadLocal<Boolean> needNotify;

    public static void clear(String region, String type) {
        try {
            if (EhcacheMemoryCacheClusterNotify.needLog()) {
                logger.info("recive broadcast clear msg: region= " + region + TYPE + type);
            }
            needNotify.set(false);
            LocalMemoryCache defaultCacheRegion = factory.$getLocalMemoryCache(region, type);
            if (defaultCacheRegion != null) {
                defaultCacheRegion.clear();
            }
        }
        finally {
            needNotify.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(String region, String type, String[] keys) {
        try {
            if (EhcacheMemoryCacheClusterNotify.needLog()) {
                logger.info("recive broadcast remove msg: region= " + region + TYPE + type);
            }
            needNotify.set(false);
            LocalMemoryCache defaultCacheRegion = factory.$getLocalMemoryCache(region, type);
            if (defaultCacheRegion != null) {
                defaultCacheRegion.remove(keys);
            }
        }
        finally {
            needNotify.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeMapFields(String region, String type, String key, String[] fields) {
        try {
            if (EhcacheMemoryCacheClusterNotify.needLog()) {
                logger.info("recive broadcast removeMapFields msg: region= " + region + TYPE + type + ",fields=" + Arrays.toString(fields));
            }
            needNotify.set(false);
            LocalMemoryCache defaultCacheRegion = factory.$getLocalMemoryCache(region, type);
            if (defaultCacheRegion != null) {
                defaultCacheRegion.removeMapFields(key, fields);
            }
        }
        finally {
            needNotify.set(true);
        }
    }

    public static void batchExecute(BalesBroadcastInfo items) {
        EhcacheMemoryCacheClusterNotify.invokeSyncMethods(items.getLs());
        MemoryCacheSyncStatusMange.recordReceiveStatus(items);
    }

    public static void invokeSyncMethods(List<SingleBroadcastItemInfo> ls) {
        for (SingleBroadcastItemInfo item : ls) {
            if ("clear".equals(item.getMethod())) {
                EhcacheMemoryCacheClusterNotify.clear(item.getStringParam(0), item.getStringParam(1));
            }
            if ("remove".equals(item.getMethod())) {
                EhcacheMemoryCacheClusterNotify.remove(item.getStringParam(0), item.getStringParam(1), item.getStringListParam(2));
            }
            if (!"removeMapFields".equals(item.getMethod())) continue;
            EhcacheMemoryCacheClusterNotify.removeMapFields(item.getStringParam(0), item.getStringParam(1), item.getStringParam(2), item.getStringListParam(3));
        }
    }

    public static void notifySync(String method, Object ... params) {
        if (needNotify.get().booleanValue()) {
            EhcacheMemoryCacheClusterNotify.notify(method, params);
        }
    }

    private static void notify(String method, Object[] params) {
        if (broadcastMessage != null) {
            try {
                if (EhcacheMemoryCacheClusterNotify.needLog()) {
                    logger.info("send broadcast: [" + method + "] " + JSONUtils.toString((Object)params));
                }
                if (EhcacheMemoryCacheClusterNotify.isAsyncBroadcast()) {
                    SingleBroadcastItemInfo item = new SingleBroadcastItemInfo();
                    item.setMethod(method);
                    item.setParams(params);
                    queue.put(item);
                } else {
                    broadcastMessage.invoke(broadcastClass, EhcacheMemoryCacheClusterNotify.class.getName(), method, params);
                }
            }
            catch (Exception e) {
                throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"broadcast message error"});
            }
        }
    }

    private static boolean isAsyncBroadcast() {
        return !Boolean.getBoolean("broadcast.sync");
    }

    private static boolean needLog() {
        return Boolean.getBoolean("broadcast.log.enable");
    }

    static {
        logger = LogFactory.getLog(EhcacheMemoryCacheClusterNotify.class);
        queue = new LinkedBlockingQueue(100000);
        try {
            Method[] methods;
            broadcastClass = Class.forName("kd.bos.mq.broadcast.BroadcastService");
            for (Method m : methods = broadcastClass.getDeclaredMethods()) {
                if (!m.getName().equals("broadcastMessage")) continue;
                broadcastMessage = m;
                break;
            }
            factory = CacheFactory.getCommonCacheFactory();
            WrapperThread wt = new WrapperThread();
            wt.setThread(new Thread(ThreadLifeCycleManager.wrapRunnable((Runnable)new BroadcastSender(queue, broadcastClass, broadcastMessage)), "BroadcastSender"));
            wt.setDaemon(true);
            wt.start();
            ScheduledExecutorService es = Executors.newScheduledThreadPool(1);
            es.scheduleAtFixedRate(() -> {
                if (!wt.isAlive()) {
                    wt.setThread(new Thread(ThreadLifeCycleManager.wrapRunnable((Runnable)new BroadcastSender(queue, broadcastClass, broadcastMessage)), "BroadcastSender"));
                    wt.setDaemon(true);
                    wt.start();
                }
            }, 100L, 60L, TimeUnit.SECONDS);
        }
        catch (Error | Exception e) {
            logger.warn("EhcacheMemoryCacheClusterNotify broadcast async set error", e);
            System.setProperty("broadcast.sync", "true");
        }
        needNotify = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return Boolean.TRUE;
            }
        };
    }

    private static class WrapperThread {
        private Thread t;

        private WrapperThread() {
        }

        public boolean isAlive() {
            return this.t.isAlive();
        }

        public void setDaemon(boolean b) {
            this.t.setDaemon(b);
        }

        public void setThread(Thread t) {
            this.t = t;
        }

        public void start() {
            this.t.start();
        }
    }
}

