/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache;

import java.time.Duration;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.EhcacheStoreType;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ehcache.BuilderConfig;
import kd.bos.cache.ehcache.CacheBuilderStrategy;
import kd.bos.cache.ehcache.EhcacheFactory;
import kd.bos.cache.ehcache.EhcacheSessionlessCacheWrapper;
import kd.bos.cache.ehcache.LocalSessionCacheRegionManger;
import kd.bos.cache.ehcache.config.CacheConfig;
import kd.bos.cache.ehcache.config.RegionDef;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.expiry.ExpiryPolicy;

public class EhcacheSessionlessCache
implements LocalSessionCacheRegionManger {
    private static Log log = LogFactory.getLog(EhcacheSessionlessCache.class);
    private static Map<String, CacheProperites> configMap;
    public static final char REGIONTYPESPILTCHAR = '-';
    private String _region = "";
    private EhcacheStoreType storeType = EhcacheStoreType.Heap;
    private ConcurrentHashMap<String, EhcacheSessionlessCacheWrapper> cacheMap = new ConcurrentHashMap();

    public EhcacheSessionlessCache(String region) {
        if (region != null) {
            this._region = region;
        }
    }

    public EhcacheSessionlessCache(String region, EhcacheStoreType storeType) {
        this(region);
        this.storeType = storeType;
    }

    private static void initConfig() {
        List<RegionDef> regionList = CacheConfig.get().getRegions();
        regionList.forEach(v -> {
            CacheProperites cp = new CacheProperites();
            cp.timeout = v.getTimeout();
            cp.maxHeapSize = v.getMaxHeapSize();
            cp.maxItemSize = v.getMaxItemSize();
            cp.name = v.getName();
            configMap.put(cp.name, cp);
            v.getQueues().forEach(vt -> {
                CacheProperites cpt = new CacheProperites();
                cpt.timeout = vt.getTimeout();
                cpt.maxHeapSize = vt.getMaxHeapSize();
                cpt.maxItemSize = vt.getMaxItemSize();
                cpt.name = vt.getName();
                configMap.put(cp.name + '-' + cpt.name, cpt);
            });
        });
    }

    private final String makeInnerRegion(String type) {
        if (type == null || type.trim().length() == 0) {
            type = "default";
        }
        return this._region + '-' + type;
    }

    @Override
    public LocalMemoryCache createOrReplaceCache(String type, CacheConfigInfo cacheConfig) {
        this.innerRemoveCache(type);
        String region = this.makeInnerRegion(type);
        CacheProperites cp = new CacheProperites();
        cp.name = type;
        cp.timeout = cacheConfig.getTimeout();
        cp.maxHeapSize = cacheConfig.getMaxMemSize();
        cp.maxItemSize = cacheConfig.getMaxItemSize();
        cp.isTimeToLive = cacheConfig.isTimeToLive();
        configMap.put(region, cp);
        return this.getCache(type, true);
    }

    @Override
    public LocalMemoryCache getOrCreateCache(String type) {
        return this.getCache(type, true);
    }

    @Override
    public LocalMemoryCache getCache(String type) {
        return this.getCache(type, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EhcacheSessionlessCacheWrapper getCache(String type, boolean createIfNotExists) {
        String region = this.makeInnerRegion(type);
        EhcacheSessionlessCacheWrapper cacheWrapper = this.cacheMap.get(region);
        if ((cacheWrapper == null || cacheWrapper.cache == null) && createIfNotExists) {
            ConcurrentHashMap<String, EhcacheSessionlessCacheWrapper> concurrentHashMap = this.cacheMap;
            synchronized (concurrentHashMap) {
                cacheWrapper = this.cacheMap.get(region);
                if (cacheWrapper == null || cacheWrapper.cache == null) {
                    CacheProperites cp = configMap.get(region);
                    if (cp == null && (cp = configMap.get(this._region)) == null) {
                        throw new KDException(BosErrorCode.systemError, new Object[]{"not config cache region of " + this._region + " , type of " + type});
                    }
                    if (cp.timeout <= 0) {
                        throw new KDException(BosErrorCode.systemError, new Object[]{" cache config error , region of " + this._region + " , type of " + type + ", config:" + cp});
                    }
                    Cache<String, Object> cache = this.newCache(region, cp.timeout, cp.maxHeapSize, cp.maxItemSize, cp.isTimeToLive);
                    if (cacheWrapper != null) {
                        cacheWrapper.setCache(cache);
                    } else {
                        cacheWrapper = new EhcacheSessionlessCacheWrapper(this._region, type, cache, this);
                        cacheWrapper.setStoreType(this.storeType);
                        this.cacheMap.put(region, cacheWrapper);
                    }
                }
            }
        }
        return cacheWrapper;
    }

    private Cache<String, Object> newCache(String region, int timeout, int maxHeapSize, int maxItemSize, boolean timeToLive) {
        if (maxItemSize < 1) {
            maxItemSize = Integer.parseInt(System.getProperty("ehcache.limit.maxitems", "6000"));
        }
        BuilderConfig config = new BuilderConfig();
        config.maxItemSize = maxItemSize;
        config.maxMemSize = maxHeapSize;
        config.storeType = this.storeType;
        CacheBuilderStrategy cacheBuilderStrategy = CacheBuilderStrategy.createBuilderStrategy(region, config);
        CacheManager manager = cacheBuilderStrategy.createCacheManager();
        CacheConfigurationBuilder configBuilder = cacheBuilderStrategy.createCacheConfigurationBuilder();
        ExpiryPolicy expiryPolicy = timeToLive ? ExpiryPolicyBuilder.timeToLiveExpiration((Duration)Duration.ofSeconds(timeout)) : ExpiryPolicyBuilder.timeToIdleExpiration((Duration)Duration.ofSeconds(timeout));
        Cache cache = manager.createCache(region, configBuilder.withExpiry(expiryPolicy).build());
        if (Boolean.parseBoolean(System.getProperty("ehcahce.created.monitor.enable", "false"))) {
            log.warn("createlocalcache_trace", (Throwable)new Exception(region));
        }
        return cache;
    }

    private void innerRemoveCache(String type) {
        String region = this.makeInnerRegion(type);
        EhcacheSessionlessCacheWrapper cacheWrapper = this.cacheMap.get(region);
        if (cacheWrapper != null) {
            cacheWrapper.clear();
            cacheWrapper.setCache(null);
        }
        CacheManager manager = EhcacheFactory.getCacheManager();
        manager.removeCache(region);
    }

    @Override
    public void put(String key, Object value) {
        this.getOrCreateCache(null).put(key, value);
    }

    @Override
    public Object get(String key) {
        return this.getOrCreateCache(null).get(key);
    }

    @Override
    public boolean contains(String key) {
        return this.getOrCreateCache(null).contains(key);
    }

    @Override
    public void removeType(String type) {
        this.innerRemoveCache(type);
    }

    @Override
    public Map<String, Object> get(String ... keys) {
        return this.getOrCreateCache(null).get(keys);
    }

    @Override
    public void destory() {
        CacheManager manager = EhcacheFactory.getCacheManager();
        Iterator<Map.Entry<String, EhcacheSessionlessCacheWrapper>> iter = this.cacheMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, EhcacheSessionlessCacheWrapper> entry = iter.next();
            String region = entry.getKey();
            EhcacheSessionlessCacheWrapper cache = entry.getValue();
            cache.clear();
            manager.removeCache(region);
            iter.remove();
        }
    }

    @Override
    public void remove(String ... keys) {
        this.getOrCreateCache(null).remove(keys);
    }

    @Override
    public void clear() {
        this.getOrCreateCache(null).clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocalMemoryCache getOrCreateCache(String type, CacheConfigInfo cacheConfig) {
        EhcacheSessionlessCacheWrapper cache = this.getCache(type, false);
        if (cache == null) {
            EhcacheSessionlessCache ehcacheSessionlessCache = this;
            synchronized (ehcacheSessionlessCache) {
                cache = this.getCache(type, false);
                if (cache == null) {
                    String region = this.makeInnerRegion(type);
                    CacheProperites cp = new CacheProperites();
                    cp.name = type;
                    cp.timeout = cacheConfig.getTimeout();
                    cp.maxHeapSize = cacheConfig.getMaxMemSize();
                    cp.maxItemSize = cacheConfig.getMaxItemSize();
                    cp.isTimeToLive = cacheConfig.isTimeToLive();
                    configMap.put(region, cp);
                    cache = this.getCache(type, true);
                }
            }
        }
        return cache;
    }

    @Override
    public void removeMapFields(String key, String ... fields) {
        this.getOrCreateCache(null).removeMapFields(key, fields);
    }

    @Override
    public Map<String, EhcacheSessionlessCacheWrapper> getCaches() {
        return Collections.unmodifiableMap(this.cacheMap);
    }

    static {
        try {
            configMap = new ConcurrentHashMap<String, CacheProperites>();
            EhcacheSessionlessCache.initConfig();
        }
        catch (Throwable e) {
            log.error(e);
        }
    }

    private static class CacheProperites {
        private int timeout;
        private int maxHeapSize;
        private int maxItemSize;
        private String name;
        private boolean isTimeToLive = false;

        private CacheProperites() {
        }

        public String toString() {
            return "name:" + this.name + ", timeout:" + this.timeout + ", maxHeapSize:" + this.maxHeapSize + ", maxItemSize:" + this.maxItemSize + ",isTimeToLive:" + this.isTimeToLive;
        }
    }
}

