/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.EhcacheStoreType;
import kd.bos.cache.LocalCacheMonitorInfo;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.cache.ehcache.EhcacheMemoryCacheClusterNotify;
import kd.bos.cache.ehcache.EhcacheSessionlessCache;
import kd.bos.cache.ehcache.LocalSessionCacheRegionManger;
import kd.bos.cache.ehcache.valueholder.NormalValueHolder;
import kd.bos.cache.ehcache.valueholder.ValueHolder;
import kd.bos.cache.ehcache.valueholder.ValueHolderFactory;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import org.ehcache.Cache;
import org.ehcache.core.Ehcache;
import org.ehcache.sizeof.SizeOf;
import org.ehcache.sizeof.impl.UnsafeSizeOf;

public class EhcacheSessionlessCacheWrapper
implements LocalSessionCacheRegionManger {
    private static Log log = LogFactory.getLog(EhcacheSessionlessCacheWrapper.class);
    protected Cache<String, Object> cache;
    private final EhcacheSessionlessCache ehcache;
    private String region;
    private String type;
    private EhcacheStoreType storeType = EhcacheStoreType.Heap;
    SizeOf sizeof = new UnsafeSizeOf();

    void setStoreType(EhcacheStoreType storeType) {
        this.storeType = storeType;
    }

    private ValueHolder getValueHolder() {
        if ((this.storeType.getCode() & 4) == 4) {
            return new NormalValueHolder();
        }
        return ValueHolderFactory.get();
    }

    protected EhcacheSessionlessCacheWrapper(String region, String type, Cache<String, Object> cache, EhcacheSessionlessCache ehcache) {
        this.region = region;
        this.type = type;
        this.cache = cache;
        this.ehcache = ehcache;
    }

    protected void setCache(Cache<String, Object> cache) {
        this.cache = cache;
    }

    @Override
    public void put(String key, Object value) {
        try (TraceSpan span = Tracer.create((String)"LocalCache", (String)"put");){
            if (this.cache == null) {
                return;
            }
            span.addTag("key", key);
            this.cache.put((Object)key, this.getValueHolder().holdValue(value));
        }
    }

    @Override
    public Object get(String key) {
        if (this.cache == null) {
            return null;
        }
        return this.getValueHolder().originValue(this.cache.get((Object)key));
    }

    private void remove(String key) {
        if (this.cache == null) {
            return;
        }
        this.cache.remove((Object)key);
    }

    @Override
    public void remove(String ... keys) {
        for (String key : keys) {
            this.remove(key);
        }
        EhcacheMemoryCacheClusterNotify.notifySync("remove", this.region, this.type, keys);
    }

    @Override
    public void removeMapFields(String key, String ... fields) {
        this._removeMapFields(key, fields);
        EhcacheMemoryCacheClusterNotify.notifySync("removeMapFields", this.region, this.type, key, fields);
    }

    private void _removeMapFields(String key, String ... fields) {
        if (this.cache == null) {
            return;
        }
        Object o = this.getValueHolder().originValue(this.cache.get((Object)key));
        if (o instanceof Map) {
            Map m = (Map)o;
            for (String field : fields) {
                m.remove(field);
            }
        }
    }

    @Override
    public boolean contains(String key) {
        if (this.cache == null) {
            return false;
        }
        boolean isContainsKey = this.cache.containsKey((Object)key);
        if (isContainsKey) {
            Object o = this.get(key);
            if (o == null) {
                this.cache.remove((Object)key);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> get(String ... keys) {
        if (this.cache == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : keys) {
            map.put(key, this.getValueHolder().originValue(this.cache.get((Object)key)));
        }
        return map;
    }

    @Override
    public void destory() {
        this.ehcache.destory();
    }

    @Override
    public LocalMemoryCache getOrCreateCache(String type) {
        return this.ehcache.getOrCreateCache(type);
    }

    @Override
    public LocalMemoryCache getCache(String type) {
        return this.ehcache.getCache(type);
    }

    @Override
    public void removeType(String type) {
        this.ehcache.removeType(type);
    }

    @Override
    public LocalMemoryCache getOrCreateCache(String type, CacheConfigInfo cacheConfig) {
        return this.ehcache.getOrCreateCache(type, cacheConfig);
    }

    @Override
    public LocalMemoryCache createOrReplaceCache(String type, CacheConfigInfo cacheConfig) {
        return this.ehcache.createOrReplaceCache(type, cacheConfig);
    }

    @Override
    public void clear() {
        if (this.cache != null) {
            this.cache.clear();
        }
        EhcacheMemoryCacheClusterNotify.notifySync("clear", this.region, this.type);
    }

    public void clearWithOutNotify() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    @Override
    public Map<String, EhcacheSessionlessCacheWrapper> getCaches() {
        return null;
    }

    public void setStatics(LocalCacheMonitorInfo cmonitor) {
        Ehcache ech = (Ehcache)this.cache;
        AtomicInteger counts = new AtomicInteger(0);
        AtomicLong keySize = new AtomicLong(0L);
        AtomicLong valueSize = new AtomicLong(0L);
        HashSet keys = new HashSet();
        ech.forEach(k -> {
            counts.incrementAndGet();
            if (Instance.isPausedServiceByMonitor()) {
                keySize.addAndGet(this.sizeof.deepSizeOf(new Object[]{k.getKey()}));
                valueSize.addAndGet(this.sizeof.deepSizeOf(new Object[]{k.getValue()}));
            } else {
                keySize.addAndGet(1L);
                valueSize.addAndGet(1L);
            }
            keys.add(k.getKey());
        });
        log.info("Ehcache region:{},type:{},count:{},valuesize:{}.", new Object[]{this.region, this.type, counts.get(), valueSize.get()});
        cmonitor.setCounts(counts.get());
        cmonitor.setKeysize(keySize.get());
        cmonitor.setValuesize(valueSize.get());
    }
}

