/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.ehcache.syncstatus;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.LockSupport;
import kd.bos.cache.ehcache.EhcacheMemoryCacheClusterNotify;
import kd.bos.cache.ehcache.syncstatus.BalesBroadcastInfo;
import kd.bos.cache.ehcache.syncstatus.MemoryCacheSyncStatusMange;
import kd.bos.cache.ehcache.syncstatus.SingleBroadcastItemInfo;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;

public class BroadcastSender
implements Runnable {
    private boolean starting = true;
    private long intervalMS = Integer.getInteger("broadcast.async.intervalms", 2000).intValue();
    private int batchNumbers = Integer.getInteger("broadcast.async.batchNumbers", 2000);
    private final LinkedBlockingQueue<SingleBroadcastItemInfo> queue;
    private final Class<?> broadcastClass;
    private final Method broadcastMessage;
    private static Log logger = LogFactory.getLog(BroadcastSender.class);

    public BroadcastSender(LinkedBlockingQueue<SingleBroadcastItemInfo> queue, Class<?> broadcastClass, Method broadcastMessage) {
        this.queue = queue;
        this.broadcastMessage = broadcastMessage;
        this.broadcastClass = broadcastClass;
    }

    public void setStarting(boolean start) {
        this.starting = start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ArrayList<SingleBroadcastItemInfo> preSendLs = new ArrayList<SingleBroadcastItemInfo>(8);
        long lastSendStap = System.currentTimeMillis();
        while (this.starting) {
            try {
                long diff;
                if (this.queue.size() > 0) {
                    this.queue.drainTo(preSendLs, this.batchNumbers);
                } else {
                    preSendLs.add(this.queue.take());
                }
                BalesBroadcastInfo bales = new BalesBroadcastInfo();
                bales.setLs(preSendLs);
                bales.setUid(MemoryCacheSyncStatusMange.getUid());
                bales.setInstanceId(Instance.getInstanceId());
                MemoryCacheSyncStatusMange.recordSendStatus(bales);
                int maxRepeatsTimes = Integer.getInteger("broadcast.max.repeat.times", 5);
                for (int i = 0; i < maxRepeatsTimes; ++i) {
                    try {
                        this.broadcastMessage.invoke(this.broadcastClass, EhcacheMemoryCacheClusterNotify.class.getName(), "batchExecute", new Object[]{bales});
                        break;
                    }
                    catch (Exception e) {
                        logger.error(String.format("broadcast Sender error ,will repeat %s times", maxRepeatsTimes - 1 - i), (Throwable)e);
                        LockSupport.parkNanos(500000000L);
                        continue;
                    }
                }
                if ((diff = System.currentTimeMillis() - lastSendStap) < this.intervalMS && this.queue.size() < this.batchNumbers) {
                    LockSupport.parkNanos((this.intervalMS - diff) * 1000L * 1000L);
                }
                lastSendStap = System.currentTimeMillis();
            }
            catch (Error | Exception e) {
                try {
                    logger.error("broadcast Sender error ,preSendLs:" + JSONUtils.toString(preSendLs), e);
                }
                catch (Exception e1) {
                    logger.error("broadcast Sender error ,preSendLs:" + preSendLs, e);
                }
            }
            finally {
                preSendLs.clear();
                LockSupport.parkNanos(10000L);
            }
        }
    }
}

