/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.fifo;

import java.util.ArrayList;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.FIFOCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;

public class RedisFIFOCache
implements FIFOCache {
    private Log logger = LogFactory.getLog(RedisFIFOCache.class);

    protected void release(JedisClient jedis, boolean isBroken) {
        if (jedis != null) {
            jedis.close();
        }
    }

    private String getConfigKey() {
        return "fifocache.redis.configKey";
    }

    private JedisClient getJedis() {
        return this.getJedis(this.getConfigKey());
    }

    private JedisClient getJedis(String configKey) {
        String url = null;
        url = System.getProperty(configKey);
        if (url == null) {
            this.logger.warn("FIFO cache not found, use global sessionless cache.");
            configKey = CacheConfigKeys.getSessionlessConfigKey(null);
            url = System.getProperty(configKey);
        }
        if (url != null) {
            String info = "Load FIFO cache.";
            this.logger.info(info);
        }
        return RedisFactory.getJedisClient((String)url);
    }

    private String createKey(String key) {
        return "fifo-" + key;
    }

    @Override
    public void push(String key, String value) {
        JedisClient jedis = this.getJedis();
        boolean isBroken = false;
        try {
            key = this.createKey(key);
            jedis.rpush(key, new String[]{value});
        }
        catch (Exception e) {
            isBroken = true;
            throw new KDException(BosErrorCode.redisRead, new Object[]{"push key:" + key});
        }
        finally {
            this.release(jedis, isBroken);
        }
    }

    @Override
    public void push(String key, String ... values) {
        JedisClient jedis = this.getJedis();
        boolean isBroken = false;
        try {
            key = this.createKey(key);
            jedis.rpush(key, values);
        }
        catch (Exception e) {
            isBroken = true;
            throw new KDException(BosErrorCode.redisRead, new Object[]{"push key:" + key});
        }
        finally {
            this.release(jedis, isBroken);
        }
    }

    @Override
    public String pop(String key) {
        JedisClient jedis = this.getJedis();
        boolean isBroken = false;
        try {
            key = this.createKey(key);
            String string = jedis.lpop(key);
            return string;
        }
        catch (Exception e) {
            isBroken = true;
            throw new KDException(BosErrorCode.redisRead, new Object[]{"pop key:" + key});
        }
        finally {
            this.release(jedis, isBroken);
        }
    }

    @Override
    public String[] pop(String key, int n) {
        JedisClient jedis = this.getJedis();
        boolean isBroken = false;
        ArrayList<String> list = new ArrayList<String>(n);
        try {
            String s;
            key = this.createKey(key);
            for (int i = 0; i < n && (s = jedis.lpop(key)) != null; ++i) {
                list.add(s);
            }
            String[] i = list.toArray(new String[list.size()]);
            return i;
        }
        catch (Exception e) {
            isBroken = true;
            throw new KDException(BosErrorCode.redisRead, new Object[]{"pop key:" + key});
        }
        finally {
            this.release(jedis, isBroken);
        }
    }
}

