/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import kd.bos.cache.redis.CacheLimiterConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.monitor.sdk.KDCounter;
import kd.bos.thread.ThreadTruck;
import kd.bos.util.StringUtils;

public class CacheLimiter {
    private static final Log log = LogFactory.getLog(CacheLimiter.class);
    public static final KDCounter counter = KDCounter.build((String)"redis_rate_limiter", (String)"Redis Rate Limiter");

    public static void checkCount() {
        if (CacheLimiterConfig.isLimit()) {
            Object count = ThreadTruck.get((Object)"CACHE_ACCESS_COUNT");
            if (count == null) {
                return;
            }
            int accessCount = (Integer)count;
            if (accessCount >= CacheLimiter.getMaxCount()) {
                String msg = "Operate was terminated by Cache Limiter. maxCount: " + CacheLimiter.getMaxCount();
                EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
                counter.inc();
                throw new KDException(BosErrorCode.redisCacheOverMaxCount, new Object[]{msg});
            }
            ThreadTruck.put((Object)"CACHE_ACCESS_COUNT", (Object)(++accessCount));
        }
    }

    public static void checkCountTotalSize(byte[] value) {
        if (value == null) {
            return;
        }
        Object size = ThreadTruck.get((Object)"CACHE_ACCESS_SIZE");
        if (size == null) {
            return;
        }
        CacheLimiter.checkCount();
        long totalSize = (Long)size + (long)value.length;
        if (totalSize >= CacheLimiter.getMaxTotalSize()) {
            String msg = "Operate was terminated by Cache Limiter. maxTotalSize: " + CacheLimiter.getMaxTotalSize();
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxTotalSize, new Object[]{msg});
        }
        ThreadTruck.put((Object)"CACHE_ACCESS_SIZE", (Object)totalSize);
    }

    static void checkCountTotalSize(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        CacheLimiter.checkCountTotalSize(value.getBytes(StandardCharsets.UTF_8));
    }

    static void checkCountTotalSize(String[] value) {
        if (value == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String str : value) {
            sb.append(str);
        }
        CacheLimiter.checkCountTotalSize(sb.toString().getBytes());
    }

    static void checkCountTotalSize(Map<String, String> keyValues) {
        if (keyValues == null || keyValues.size() == 0) {
            return;
        }
        Object size = ThreadTruck.get((Object)"CACHE_ACCESS_SIZE");
        if (size == null) {
            return;
        }
        CacheLimiter.checkCount();
        long totalSize = (Long)size;
        for (Map.Entry<String, String> entry : keyValues.entrySet()) {
            totalSize += (long)(CacheLimiter.getLength(entry.getKey()) + CacheLimiter.getLength(entry.getValue()));
        }
        if (totalSize >= CacheLimiter.getMaxTotalSize()) {
            String msg = "Operate was terminated by Cache Limiter. maxTotalSize: " + CacheLimiter.getMaxTotalSize();
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxTotalSize, new Object[]{msg});
        }
        ThreadTruck.put((Object)"CACHE_ACCESS_SIZE", (Object)totalSize);
    }

    static void checkCountTotalByteSize(Map<byte[], byte[]> mapValues) {
        if (mapValues == null || mapValues.size() == 0) {
            return;
        }
        Object size = ThreadTruck.get((Object)"CACHE_ACCESS_SIZE");
        if (size == null) {
            return;
        }
        CacheLimiter.checkCount();
        long totalSize = (Long)size;
        for (Map.Entry<byte[], byte[]> entry : mapValues.entrySet()) {
            totalSize += (long)(CacheLimiter.getLength(entry.getKey()) + CacheLimiter.getLength(entry.getValue()));
        }
        if (totalSize >= CacheLimiter.getMaxTotalSize()) {
            String msg = "Operate was terminated by Cache Limiter. maxTotalSize: " + CacheLimiter.getMaxTotalSize();
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxTotalSize, new Object[]{msg});
        }
        ThreadTruck.put((Object)"CACHE_ACCESS_SIZE", (Object)totalSize);
    }

    public static void init() {
        if (CacheLimiterConfig.isLimit()) {
            Object count = ThreadTruck.get((Object)"CACHE_ACCESS_COUNT");
            Object size = ThreadTruck.get((Object)"CACHE_ACCESS_SIZE");
            if (count == null) {
                ThreadTruck.put((Object)"CACHE_ACCESS_COUNT", (Object)0);
            }
            if (size == null) {
                ThreadTruck.put((Object)"CACHE_ACCESS_SIZE", (Object)0L);
            }
        }
    }

    public static void end() {
        if (CacheLimiterConfig.isLimit()) {
            long totalSize;
            Object size;
            int accessCount;
            Object count = ThreadTruck.get((Object)"CACHE_ACCESS_COUNT");
            if (count != null && (accessCount = ((Integer)count).intValue()) < CacheLimiter.getMaxCount() && accessCount >= CacheLimiter.getWarnCount()) {
                log.warn("Redis access count exceeds the warning threshold. access count: " + accessCount + ", warning threshold: " + CacheLimiter.getWarnCount());
            }
            if ((size = ThreadTruck.get((Object)"CACHE_ACCESS_SIZE")) != null && (totalSize = ((Long)size).longValue()) < CacheLimiter.getMaxTotalSize() && totalSize >= CacheLimiter.getWarnTotalSize()) {
                log.warn("Total size write into Redis exceeds the warning threshold. total size: " + totalSize + ", warning threshold: " + CacheLimiter.getWarnTotalSize() + " (Byte)");
            }
        }
    }

    private static int getLength(String str) {
        return StringUtils.isEmpty((String)str) ? 0 : str.getBytes(StandardCharsets.UTF_8).length;
    }

    private static int getLength(byte[] bytes) {
        return bytes == null ? 0 : bytes.length;
    }

    private static int getMaxCount() {
        return Integer.getInteger("redisCache.limit.maxCount", 100000);
    }

    private static long getMaxTotalSize() {
        return Long.getLong("redisCache.limit.totalSize", 0x40000000L);
    }

    private static int getWarnCount() {
        int threshold = CacheLimiter.thresholdRestrict(Integer.getInteger("redisCache.limit.warn.threshold", 80));
        try {
            return CacheLimiter.getMaxCount() * threshold / 100;
        }
        catch (Exception e) {
            log.error("get warn count error.", (Throwable)e);
            return CacheLimiter.getMaxCount();
        }
    }

    private static long getWarnTotalSize() {
        int threshold = CacheLimiter.thresholdRestrict(Integer.getInteger("redisCache.limit.warn.threshold", 80));
        try {
            return CacheLimiter.getMaxTotalSize() * (long)threshold / 100L;
        }
        catch (Exception e) {
            log.error("get warn total size error.", (Throwable)e);
            return CacheLimiter.getMaxTotalSize();
        }
    }

    private static int thresholdRestrict(int threshold) {
        if (threshold < 50 || threshold > 100) {
            threshold = 100;
        }
        return threshold;
    }
}

