/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.cache.redis.CacheLimiter;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.govern.eventdata.EventType;
import kd.bos.govern.eventdata.reporter.EventDataReporter;
import kd.bos.govern.eventdata.types.LimitEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import redis.clients.jedis.exceptions.JedisDataException;

public class CacheValueLimiter {
    private static final String CACHE_LIMIT_ENABLE = "redisCache.limit.enable";
    private static final String MAX_VALUE_KEY = "redisCache.limit.maxValueSize";
    private static final String MAX_REGION_VALUE_KEY = "redisCache.{region}.limit.maxValueSize";
    private static final String MAX_COLLECTION_VALUE_KEY = "redisCache.limit.maxCollectionValueSize";
    private static final String MAX_REGION_COLLECTION_VALUE_KEY = "redisCache.{region}.limit.maxCollectionValueSize";
    private final Log log = LogFactory.getLog(CacheValueLimiter.class);
    private static final int DEFAULT_MAX_VALUE_SIZE = 0x6400000;
    private static final int DEFAULT_MAX_COLLECTION_VALUE_SIZE = 0xC800000;
    private static final Boolean DEFAULT_CACHE_LIMIT_ENABLE = true;
    private final String region;
    private static final Map<String, CacheValueLimiter> LIMITER_MAP = new ConcurrentHashMap<String, CacheValueLimiter>(2);

    public CacheValueLimiter(String region) {
        this.region = region == null ? "" : region;
    }

    public static CacheValueLimiter getLimiter(String region) {
        if (region == null) {
            region = "";
        }
        return LIMITER_MAP.computeIfAbsent(region, CacheValueLimiter::new);
    }

    public byte[] encode(String string) {
        if (string == null) {
            throw new JedisDataException("value sent to redis cannot be null");
        }
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] checkAndEncodeStringValue(String key, String value) {
        byte[] valueBytes = this.encode(value);
        if (this.isEnableLimit() && valueBytes.length > this.getMaxValueSize()) {
            String msg = "the cache value of the key=>" + key + " is over the maximum value size(" + this.getMaxValueSize() + " bytes).";
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            CacheLimiter.counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxSize, new Object[]{msg});
        }
        return valueBytes;
    }

    public void checkByteValue(byte[] keyBytes, byte[] valueBytes) {
        if (this.isEnableLimit() && valueBytes.length > this.getMaxValueSize()) {
            String key = new String(keyBytes, StandardCharsets.UTF_8);
            String msg = "the cache value of the key=>" + key + " is over the maximum value size(" + this.getMaxValueSize() + " bytes).";
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            CacheLimiter.counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxSize, new Object[]{msg});
        }
    }

    public Map<byte[], byte[]> checkAndEncodeMapValue(String type, Map<String, String> keyValuesMap) {
        HashMap<byte[], byte[]> byteKeyValuesMap = new HashMap<byte[], byte[]>(keyValuesMap.size());
        int totalSize = 0;
        for (Map.Entry<String, String> entry : keyValuesMap.entrySet()) {
            byte[] keyBytes = this.encode(entry.getKey());
            byte[] valueBytes = this.encode(entry.getValue());
            byteKeyValuesMap.put(keyBytes, valueBytes);
            if (!this.isEnableLimit()) continue;
            this.checkByteMapItemValue(type, keyBytes, valueBytes);
            if ((totalSize = totalSize + keyBytes.length + valueBytes.length) <= this.getMaxCollectionValueSize()) continue;
            String msg = "the cache value of the key=>" + type + " is over the maximum value size(" + this.getMaxCollectionValueSize() + " bytes).";
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            CacheLimiter.counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxSize, new Object[]{msg});
        }
        return byteKeyValuesMap;
    }

    public void checkByteMapValue(byte[] keyBytes, Map<byte[], byte[]> mapValues) {
        if (!this.isEnableLimit()) {
            return;
        }
        int totalSize = 0;
        for (Map.Entry<byte[], byte[]> entry : mapValues.entrySet()) {
            this.checkByteMapItemValue(keyBytes, entry.getKey(), entry.getValue());
            if ((totalSize = totalSize + entry.getKey().length + entry.getValue().length) <= this.getMaxCollectionValueSize()) continue;
            String key = new String(keyBytes, StandardCharsets.UTF_8);
            String msg = "the cache value of the key=>" + key + " is over the maximum value size(" + this.getMaxCollectionValueSize() + " bytes).";
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            CacheLimiter.counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxSize, new Object[]{msg});
        }
    }

    public byte[][] checkAndEncodeListValue(String key, String[] strings) {
        byte[][] byteStrings = new byte[strings.length][];
        int totalSize = 0;
        for (int i = 0; i < strings.length; ++i) {
            byteStrings[i] = this.checkAndEncodeStringValue(key + "[" + i + "]", strings[i]);
            if (!this.isEnableLimit() || (totalSize += byteStrings[i].length) <= this.getMaxCollectionValueSize()) continue;
            String msg = "the cache value of the key=>" + key + " is over the maximum value size(" + this.getMaxCollectionValueSize() + " bytes).";
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            CacheLimiter.counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxSize, new Object[]{msg});
        }
        return byteStrings;
    }

    public void checkByteMapItemValue(byte[] keyBytes, byte[] fieldBytes, byte[] value) {
        if (!this.isEnableLimit()) {
            return;
        }
        int valueByteSize = fieldBytes.length + value.length;
        if (valueByteSize > this.getMaxValueSize()) {
            String keyString = new String(keyBytes, StandardCharsets.UTF_8);
            String fieldString = new String(fieldBytes, StandardCharsets.UTF_8);
            String msg = "the cache value of the key=>" + keyString + ",field=>" + fieldString + " is over the maximum value size(" + this.getMaxValueSize() + " bytes).";
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            CacheLimiter.counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxSize, new Object[]{msg});
        }
    }

    public void checkByteMapItemValue(String key, byte[] fieldBytes, byte[] value) {
        if (!this.isEnableLimit()) {
            return;
        }
        int valueByteSize = fieldBytes.length + value.length;
        if (valueByteSize > this.getMaxValueSize()) {
            String fieldString = new String(fieldBytes, StandardCharsets.UTF_8);
            String msg = "the cache value of the key=>" + key + ",field=>" + fieldString + " is over the maximum value size(" + this.getMaxValueSize() + " bytes).";
            EventDataReporter.report((EventType)LimitEvent.ComponentLimitEvent.getInstance(), (String)msg);
            CacheLimiter.counter.inc();
            throw new KDException(BosErrorCode.redisCacheOverMaxSize, new Object[]{msg});
        }
    }

    private int getMaxValueSize() {
        if (StringUtils.isEmpty((String)this.region)) {
            return this.getIntegerProperty(MAX_VALUE_KEY, 0x6400000);
        }
        String regionMaxValueSizeKey = MAX_REGION_VALUE_KEY.replace("{region}", this.region);
        return this.getIntegerProperty(regionMaxValueSizeKey, 0x6400000);
    }

    private int getMaxCollectionValueSize() {
        if (StringUtils.isEmpty((String)this.region)) {
            return this.getIntegerProperty(MAX_COLLECTION_VALUE_KEY, 0xC800000);
        }
        String regionMaxValueSizeKey = MAX_REGION_COLLECTION_VALUE_KEY.replace("{region}", this.region);
        return this.getIntegerProperty(regionMaxValueSizeKey, 0xC800000);
    }

    private int getIntegerProperty(String key, int defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException("the key of property can not be null.");
        }
        String value = System.getProperty(key);
        if (value != null) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                this.log.error("the value of the key=>" + key + " is illegal integer: " + value);
            }
        }
        return defaultValue;
    }

    private boolean isEnableLimit() {
        String value = System.getProperty(CACHE_LIMIT_ENABLE, DEFAULT_CACHE_LIMIT_ENABLE.toString());
        try {
            return Boolean.parseBoolean(value);
        }
        catch (Exception e) {
            this.log.error("the value of the key[redisCache.limit.enable] is illegal boolean: " + value);
            return DEFAULT_CACHE_LIMIT_ENABLE;
        }
    }
}

