/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.redis.RedisMode;
import kd.bos.cache.redis.pipeline.ClusterJedisPipeLine;
import kd.bos.cache.redis.pipeline.CommonJedisPipeLine;
import kd.bos.cache.redis.pipeline.MultiJedisPipeLine;
import kd.bos.cache.redis.pipeline.PipeLine;
import kd.bos.cache.redis.pipeline.ShardedJedisPipeLine;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisTracker;
import kd.bos.redis.wrapper.ClusterJedisClient;
import kd.bos.redis.wrapper.CommonJedisClient;
import kd.bos.redis.wrapper.MultiJedisClient;
import kd.bos.redis.wrapper.ShardedJedisClient;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.ListPosition;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.StreamConsumersInfo;
import redis.clients.jedis.StreamEntry;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.StreamGroupInfo;
import redis.clients.jedis.StreamInfo;
import redis.clients.jedis.StreamPendingEntry;
import redis.clients.jedis.StreamPendingSummary;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.params.GeoAddParams;
import redis.clients.jedis.params.GeoRadiusParam;
import redis.clients.jedis.params.GetExParams;
import redis.clients.jedis.params.LPosParams;
import redis.clients.jedis.params.RestoreParams;
import redis.clients.jedis.params.SetParams;
import redis.clients.jedis.params.StrAlgoLCSParams;
import redis.clients.jedis.params.XAddParams;
import redis.clients.jedis.params.XAutoClaimParams;
import redis.clients.jedis.params.XClaimParams;
import redis.clients.jedis.params.XPendingParams;
import redis.clients.jedis.params.XTrimParams;
import redis.clients.jedis.params.ZAddParams;
import redis.clients.jedis.params.ZIncrByParams;
import redis.clients.jedis.resps.KeyedListElement;
import redis.clients.jedis.resps.LCSMatchResult;
import redis.clients.jedis.util.Slowlog;

public class JedisClientWrapper
implements JedisClient {
    private JedisClient modeClient;
    private JedisClient jedis;
    private volatile boolean closed = false;
    private RedisMode mode;
    private PipeLine pipeline;

    public JedisClientWrapper(JedisClient jedis, RedisMode mode) {
        this.jedis = jedis;
        this.mode = mode;
        switch (mode) {
            case single: {
                this.modeClient = jedis;
                break;
            }
            case pipelined: {
                jedis = (JedisClient)RedisTracker.getOriginalObject((Object)jedis);
                if (jedis instanceof CommonJedisClient) {
                    this.pipeline = new CommonJedisPipeLine((CommonJedisClient)jedis);
                } else if (jedis instanceof ShardedJedisClient) {
                    this.pipeline = new ShardedJedisPipeLine((ShardedJedisClient)jedis);
                } else if (jedis instanceof ClusterJedisClient) {
                    this.pipeline = new ClusterJedisPipeLine((ClusterJedisClient)jedis);
                } else if (jedis instanceof MultiJedisClient) {
                    this.pipeline = new MultiJedisPipeLine((MultiJedisClient)jedis);
                }
                this.modeClient = this.pipeline;
                break;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (RedisMode.single == this.mode) {
            this.closed = true;
            this.jedis.close();
        }
    }

    public List<Object> syncAndReturn() {
        List<Object> ls = null;
        if (RedisMode.pipelined == this.mode) {
            ls = this.pipeline.syncAndReturn();
        }
        this.closed = true;
        this.jedis.close();
        return ls;
    }

    public RedisMode getCurrentMode() {
        return this.mode;
    }

    public Long del(String key) {
        return this.modeClient.del(key);
    }

    public Long unlink(String s) {
        return this.modeClient.unlink(s);
    }

    public Boolean exists(String key) {
        return this.modeClient.exists(key);
    }

    public Long expire(String key, int second) {
        return this.modeClient.expire(key, second);
    }

    public Long expire(String s, long l) {
        return this.modeClient.expire(s, l);
    }

    public String get(String key) {
        return this.modeClient.get(key);
    }

    public String getDel(String s) {
        return null;
    }

    public String getEx(String s, GetExParams getExParams) {
        return null;
    }

    public Long hdel(String key, String ... keys) {
        return this.modeClient.hdel(key, keys);
    }

    public Boolean hexists(String key, String key2) {
        return this.modeClient.hexists(key, key2);
    }

    public String hget(String key, String key2) {
        return this.modeClient.hget(key, key2);
    }

    public Map<String, String> hgetAll(String key) {
        return this.modeClient.hgetAll(key);
    }

    public String hrandfield(String s) {
        return null;
    }

    public List<String> hrandfield(String s, long l) {
        return null;
    }

    public Map<String, String> hrandfieldWithValues(String s, long l) {
        return null;
    }

    public Set<String> hkeys(String sessionManagerKey) {
        return this.modeClient.hkeys(sessionManagerKey);
    }

    public Long hlen(String sessionManagerKey) {
        return this.modeClient.hlen(sessionManagerKey);
    }

    public List<String> hmget(String key, String ... keys) {
        return this.modeClient.hmget(key, keys);
    }

    public String hmset(String key, Map<String, String> keyValues) {
        return this.modeClient.hmset(key, keyValues);
    }

    public Long hset(String key, String key2, String value) {
        return this.modeClient.hset(key, key2, value);
    }

    public Long hset(String s, Map<String, String> map) {
        return this.modeClient.hset(s, map);
    }

    public Long incr(String key) {
        return this.modeClient.incr(key);
    }

    public Set<String> keys(String string) {
        return this.modeClient.keys(string);
    }

    public String lindex(String key, long index) {
        return this.modeClient.lindex(key, index);
    }

    public Long linsert(String key, BinaryClient.LIST_POSITION before, String s, String string) {
        return this.modeClient.linsert(key, before, s, string);
    }

    public Long linsert(String key, ListPosition before, String s, String string) {
        return this.modeClient.linsert(key, before, s, string);
    }

    public Long llen(String key) {
        return this.modeClient.llen(key);
    }

    public List<String> lrange(String key, long index, long i) {
        return this.modeClient.lrange(key, index, i);
    }

    public Long lrem(String key, long length, String payload) {
        return this.modeClient.lrem(key, length, payload);
    }

    public String lset(String key, long index, String value) {
        return this.modeClient.lset(key, index, value);
    }

    public Long rpush(String key, String ... values) {
        return this.modeClient.rpush(key, values);
    }

    public Long sadd(String key, String ... values) {
        return this.modeClient.sadd(key, values);
    }

    public Long scard(String key) {
        return this.modeClient.scard(key);
    }

    public String set(String key, String value) {
        return this.modeClient.set(key, value);
    }

    public String set(String s, String s1, SetParams setParams) {
        return this.modeClient.set(s, s1, setParams);
    }

    public String setex(String key, int timeoutSeconds, String value) {
        return this.modeClient.setex(key, timeoutSeconds, value);
    }

    public String setex(String s, long l, String s1) {
        return this.modeClient.setex(s, l, s1);
    }

    public Set<String> smembers(String key) {
        return this.modeClient.smembers(key);
    }

    public Long srem(String key, String ... values) {
        return this.modeClient.srem(key, values);
    }

    public Long append(String arg0, String arg1) {
        return null;
    }

    public Long bitcount(String arg0) {
        return null;
    }

    public Long bitcount(String arg0, long arg1, long arg2) {
        return null;
    }

    public List<Long> bitfield(String arg0, String ... arg1) {
        return null;
    }

    public List<Long> bitfieldReadonly(String s, String ... strings) {
        return null;
    }

    public Long hstrlen(String s, String s1) {
        return null;
    }

    public StreamEntryID xadd(String s, StreamEntryID streamEntryID, Map<String, String> map) {
        return null;
    }

    public StreamEntryID xadd(String s, StreamEntryID streamEntryID, Map<String, String> map, long l, boolean b) {
        return null;
    }

    public StreamEntryID xadd(String s, Map<String, String> map, XAddParams xAddParams) {
        return null;
    }

    public Long xlen(String s) {
        return null;
    }

    public List<StreamEntry> xrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1) {
        return null;
    }

    public List<StreamEntry> xrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1, int i) {
        return null;
    }

    public List<StreamEntry> xrevrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1) {
        return null;
    }

    public List<StreamEntry> xrevrange(String s, StreamEntryID streamEntryID, StreamEntryID streamEntryID1, int i) {
        return null;
    }

    public long xack(String s, String s1, StreamEntryID ... streamEntryIDS) {
        return 0L;
    }

    public String xgroupCreate(String s, String s1, StreamEntryID streamEntryID, boolean b) {
        return null;
    }

    public String xgroupSetID(String s, String s1, StreamEntryID streamEntryID) {
        return null;
    }

    public long xgroupDestroy(String s, String s1) {
        return 0L;
    }

    public Long xgroupDelConsumer(String s, String s1, String s2) {
        return null;
    }

    public StreamPendingSummary xpending(String s, String s1) {
        return null;
    }

    public List<StreamPendingEntry> xpending(String s, String s1, StreamEntryID streamEntryID, StreamEntryID streamEntryID1, int i, String s2) {
        return null;
    }

    public List<StreamPendingEntry> xpending(String s, String s1, XPendingParams xPendingParams) {
        return null;
    }

    public long xdel(String s, StreamEntryID ... streamEntryIDS) {
        return 0L;
    }

    public long xtrim(String s, long l, boolean b) {
        return 0L;
    }

    public long xtrim(String s, XTrimParams xTrimParams) {
        return 0L;
    }

    public List<StreamEntry> xclaim(String s, String s1, String s2, long l, long l1, int i, boolean b, StreamEntryID ... streamEntryIDS) {
        return null;
    }

    public List<StreamEntry> xclaim(String s, String s1, String s2, long l, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDS) {
        return null;
    }

    public List<StreamEntryID> xclaimJustId(String s, String s1, String s2, long l, XClaimParams xClaimParams, StreamEntryID ... streamEntryIDS) {
        return null;
    }

    public Map.Entry<StreamEntryID, List<StreamEntry>> xautoclaim(String s, String s1, String s2, long l, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return null;
    }

    public Map.Entry<StreamEntryID, List<StreamEntryID>> xautoclaimJustId(String s, String s1, String s2, long l, StreamEntryID streamEntryID, XAutoClaimParams xAutoClaimParams) {
        return null;
    }

    public StreamInfo xinfoStream(String s) {
        return null;
    }

    public List<StreamGroupInfo> xinfoGroup(String s) {
        return null;
    }

    public List<StreamConsumersInfo> xinfoConsumers(String s, String s1) {
        return null;
    }

    public LCSMatchResult strAlgoLCSStrings(String s, String s1, StrAlgoLCSParams strAlgoLCSParams) {
        return null;
    }

    public Long bitpos(String arg0, boolean arg1) {
        return null;
    }

    public Long bitpos(String arg0, boolean arg1, BitPosParams arg2) {
        return null;
    }

    public List<String> blpop(String arg0) {
        return null;
    }

    public List<String> blpop(int arg0, String arg1) {
        return null;
    }

    public KeyedListElement blpop(double v, String s) {
        return null;
    }

    public List<String> brpop(String arg0) {
        return null;
    }

    public List<String> brpop(int arg0, String arg1) {
        return null;
    }

    public KeyedListElement brpop(double v, String s) {
        return null;
    }

    public Long decr(String key) {
        return this.modeClient.decr(key);
    }

    public Long decrBy(String arg0, long arg1) {
        return null;
    }

    public String echo(String arg0) {
        return null;
    }

    public Long expireAt(String arg0, long arg1) {
        return null;
    }

    public Long geoadd(String arg0, Map<String, GeoCoordinate> arg1) {
        return null;
    }

    public Long geoadd(String s, GeoAddParams geoAddParams, Map<String, GeoCoordinate> map) {
        return null;
    }

    public Long geoadd(String arg0, double arg1, double arg2, String arg3) {
        return null;
    }

    public Double geodist(String arg0, String arg1, String arg2) {
        return null;
    }

    public Double geodist(String arg0, String arg1, String arg2, GeoUnit arg3) {
        return null;
    }

    public List<String> geohash(String arg0, String ... arg1) {
        return null;
    }

    public List<GeoCoordinate> geopos(String arg0, String ... arg1) {
        return null;
    }

    public List<GeoRadiusResponse> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusReadonly(String s, double v, double v1, double v2, GeoUnit geoUnit) {
        return null;
    }

    public List<GeoRadiusResponse> georadius(String arg0, double arg1, double arg2, double arg3, GeoUnit arg4, GeoRadiusParam arg5) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusReadonly(String s, double v, double v1, double v2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String s, String s1, double v, GeoUnit geoUnit) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusByMember(String arg0, String arg1, double arg2, GeoUnit arg3, GeoRadiusParam arg4) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(String s, String s1, double v, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return null;
    }

    public String getSet(String arg0, String arg1) {
        return null;
    }

    public Boolean getbit(String arg0, long arg1) {
        return false;
    }

    public String getrange(String arg0, long arg1, long arg2) {
        return null;
    }

    public Long hincrBy(String arg0, String arg1, long arg2) {
        return this.modeClient.hincrBy(arg0, arg1, arg2);
    }

    public Double hincrByFloat(String arg0, String arg1, double arg2) {
        return this.modeClient.hincrByFloat(arg0, arg1, arg2);
    }

    public ScanResult<Map.Entry<String, String>> hscan(String arg0, int arg1) {
        return this.modeClient.hscan(arg0, arg1);
    }

    public ScanResult<Map.Entry<String, String>> hscan(String arg0, String arg1) {
        return null;
    }

    public ScanResult<Map.Entry<String, String>> hscan(String arg0, String arg1, ScanParams arg2) {
        return this.modeClient.hscan(arg0, arg1, arg2);
    }

    public Long hsetnx(String arg0, String arg1, String arg2) {
        return this.modeClient.hsetnx(arg0, arg1, arg2);
    }

    public List<String> hvals(String arg0) {
        return null;
    }

    public Long incrBy(String key, long amount) {
        return this.modeClient.incrBy(key, amount);
    }

    public Double incrByFloat(String arg0, double arg1) {
        return this.modeClient.incrByFloat(arg0, arg1);
    }

    public String lpop(String arg0) {
        return null;
    }

    public List<String> lpop(String s, int i) {
        return null;
    }

    public Long lpos(String s, String s1) {
        return null;
    }

    public Long lpos(String s, String s1, LPosParams lPosParams) {
        return null;
    }

    public List<Long> lpos(String s, String s1, LPosParams lPosParams, long l) {
        return null;
    }

    public Long lpush(String arg0, String ... arg1) {
        return null;
    }

    public Long lpushx(String arg0, String ... arg1) {
        return null;
    }

    public String ltrim(String arg0, long arg1, long arg2) {
        return null;
    }

    public Long move(String arg0, int arg1) {
        return null;
    }

    public Long persist(String arg0) {
        return null;
    }

    public Long pexpire(String arg0, long arg1) {
        return null;
    }

    public Long pexpireAt(String arg0, long arg1) {
        return null;
    }

    public Long pfadd(String arg0, String ... arg1) {
        return null;
    }

    public long pfcount(String arg0) {
        return 0L;
    }

    public String psetex(String arg0, long arg1, String arg2) {
        return null;
    }

    public Long pttl(String arg0) {
        return null;
    }

    public Long touch(String s) {
        return null;
    }

    public String rpop(String arg0) {
        return null;
    }

    public List<String> rpop(String s, int i) {
        return null;
    }

    public Long rpushx(String arg0, String ... arg1) {
        return null;
    }

    public String set(String arg0, String arg1, String arg2) {
        return null;
    }

    public String set(String arg0, String arg1, String arg2, String arg3, long arg4) {
        return null;
    }

    public Boolean setbit(String arg0, long arg1, boolean arg2) {
        return false;
    }

    public Boolean setbit(String arg0, long arg1, String arg2) {
        return false;
    }

    public Long setnx(String arg0, String arg1) {
        return this.modeClient.setnx(arg0, arg1);
    }

    public Long setrange(String arg0, long arg1, String arg2) {
        return null;
    }

    public Boolean sismember(String arg0, String arg1) {
        return false;
    }

    public List<Boolean> smismember(String s, String ... strings) {
        return null;
    }

    public List<String> sort(String arg0) {
        return null;
    }

    public List<String> sort(String arg0, SortingParams arg1) {
        return null;
    }

    public String spop(String arg0) {
        return null;
    }

    public Set<String> spop(String arg0, long arg1) {
        return null;
    }

    public String srandmember(String arg0) {
        return null;
    }

    public List<String> srandmember(String arg0, int arg1) {
        return null;
    }

    public ScanResult<String> sscan(String arg0, int arg1) {
        return null;
    }

    public ScanResult<String> sscan(String arg0, String arg1) {
        return null;
    }

    public ScanResult<String> sscan(String arg0, String arg1, ScanParams arg2) {
        return null;
    }

    public Long strlen(String arg0) {
        return null;
    }

    public String substr(String arg0, int arg1, int arg2) {
        return null;
    }

    public Long ttl(String arg0) {
        return this.modeClient.ttl(arg0);
    }

    public String type(String arg0) {
        return null;
    }

    public byte[] dump(String s) {
        return new byte[0];
    }

    public String restore(String s, int i, byte[] bytes) {
        return null;
    }

    public String restore(String s, long l, byte[] bytes) {
        return null;
    }

    public String restoreReplace(String s, int i, byte[] bytes) {
        return null;
    }

    public String restoreReplace(String s, long l, byte[] bytes) {
        return null;
    }

    public String restore(String s, long l, byte[] bytes, RestoreParams restoreParams) {
        return null;
    }

    public Long zadd(String arg0, Map<String, Double> arg1) {
        return null;
    }

    public Long zadd(String arg0, double arg1, String arg2) {
        return null;
    }

    public Long zadd(String arg0, Map<String, Double> arg1, ZAddParams arg2) {
        return null;
    }

    public Double zaddIncr(String s, double v, String s1, ZAddParams zAddParams) {
        return null;
    }

    public Long zadd(String arg0, double arg1, String arg2, ZAddParams arg3) {
        return null;
    }

    public Long zcard(String arg0) {
        return null;
    }

    public Long zcount(String arg0, double arg1, double arg2) {
        return null;
    }

    public Long zcount(String arg0, String arg1, String arg2) {
        return null;
    }

    public Double zincrby(String arg0, double arg1, String arg2) {
        return null;
    }

    public Double zincrby(String arg0, double arg1, String arg2, ZIncrByParams arg3) {
        return null;
    }

    public Long zlexcount(String arg0, String arg1, String arg2) {
        return null;
    }

    public Set<String> zrange(String arg0, long arg1, long arg2) {
        return null;
    }

    public Set<String> zrangeByLex(String arg0, String arg1, String arg2) {
        return null;
    }

    public Set<String> zrangeByLex(String arg0, String arg1, String arg2, int arg3, int arg4) {
        return null;
    }

    public Set<String> zrangeByScore(String arg0, double arg1, double arg2) {
        return null;
    }

    public Set<String> zrangeByScore(String arg0, String arg1, String arg2) {
        return null;
    }

    public Set<String> zrangeByScore(String arg0, double arg1, double arg2, int arg3, int arg4) {
        return null;
    }

    public Set<String> zrangeByScore(String arg0, String arg1, String arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(String arg0, double arg1, double arg2) {
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(String arg0, String arg1, String arg2) {
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(String arg0, double arg1, double arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(String arg0, String arg1, String arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrangeWithScores(String arg0, long arg1, long arg2) {
        return null;
    }

    public Long zrank(String arg0, String arg1) {
        return null;
    }

    public Long zrem(String arg0, String ... arg1) {
        return null;
    }

    public Long zremrangeByLex(String arg0, String arg1, String arg2) {
        return null;
    }

    public Long zremrangeByRank(String arg0, long arg1, long arg2) {
        return null;
    }

    public Long zremrangeByScore(String arg0, double arg1, double arg2) {
        return null;
    }

    public Long zremrangeByScore(String arg0, String arg1, String arg2) {
        return null;
    }

    public Set<String> zrevrange(String arg0, long arg1, long arg2) {
        return null;
    }

    public Set<String> zrevrangeByLex(String arg0, String arg1, String arg2) {
        return null;
    }

    public Set<String> zrevrangeByLex(String arg0, String arg1, String arg2, int arg3, int arg4) {
        return null;
    }

    public Set<String> zrevrangeByScore(String arg0, double arg1, double arg2) {
        return null;
    }

    public Set<String> zrevrangeByScore(String arg0, String arg1, String arg2) {
        return null;
    }

    public Set<String> zrevrangeByScore(String arg0, double arg1, double arg2, int arg3, int arg4) {
        return null;
    }

    public Set<String> zrevrangeByScore(String arg0, String arg1, String arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String arg0, double arg1, double arg2) {
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String arg0, String arg1, String arg2) {
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String arg0, double arg1, double arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String arg0, String arg1, String arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrevrangeWithScores(String arg0, long arg1, long arg2) {
        return null;
    }

    public String zrandmember(String s) {
        return null;
    }

    public Set<String> zrandmember(String s, long l) {
        return null;
    }

    public Set<Tuple> zrandmemberWithScores(String s, long l) {
        return null;
    }

    public Long zrevrank(String arg0, String arg1) {
        return null;
    }

    public ScanResult<Tuple> zscan(String arg0, int arg1) {
        return null;
    }

    public ScanResult<Tuple> zscan(String arg0, String arg1) {
        return null;
    }

    public ScanResult<Tuple> zscan(String arg0, String arg1, ScanParams arg2) {
        return null;
    }

    public Double zscore(String arg0, String arg1) {
        return null;
    }

    public List<Double> zmscore(String s, String ... strings) {
        return null;
    }

    public Tuple zpopmax(String s) {
        return null;
    }

    public Set<Tuple> zpopmax(String s, int i) {
        return null;
    }

    public Tuple zpopmin(String s) {
        return null;
    }

    public Set<Tuple> zpopmin(String s, int i) {
        return null;
    }

    public Long append(byte[] arg0, byte[] arg1) {
        return null;
    }

    public Long bitcount(byte[] arg0) {
        return null;
    }

    public Long bitcount(byte[] arg0, long arg1, long arg2) {
        return null;
    }

    public List<Long> bitfield(byte[] arg0, byte[] ... arg1) {
        return null;
    }

    public List<Long> bitfieldReadonly(byte[] bytes, byte[] ... bytes1) {
        return null;
    }

    public Long hstrlen(byte[] bytes, byte[] bytes1) {
        return null;
    }

    public byte[] xadd(byte[] bytes, byte[] bytes1, Map<byte[], byte[]> map, long l, boolean b) {
        return new byte[0];
    }

    public byte[] xadd(byte[] bytes, Map<byte[], byte[]> map, XAddParams xAddParams) {
        return new byte[0];
    }

    public Long xlen(byte[] bytes) {
        return null;
    }

    public List<byte[]> xrange(byte[] bytes, byte[] bytes1, byte[] bytes2) {
        return null;
    }

    public List<byte[]> xrange(byte[] bytes, byte[] bytes1, byte[] bytes2, long l) {
        return null;
    }

    public List<byte[]> xrange(byte[] bytes, byte[] bytes1, byte[] bytes2, int i) {
        return null;
    }

    public List<byte[]> xrevrange(byte[] bytes, byte[] bytes1, byte[] bytes2) {
        return null;
    }

    public List<byte[]> xrevrange(byte[] bytes, byte[] bytes1, byte[] bytes2, int i) {
        return null;
    }

    public Long xack(byte[] bytes, byte[] bytes1, byte[] ... bytes2) {
        return null;
    }

    public String xgroupCreate(byte[] bytes, byte[] bytes1, byte[] bytes2, boolean b) {
        return null;
    }

    public String xgroupSetID(byte[] bytes, byte[] bytes1, byte[] bytes2) {
        return null;
    }

    public Long xgroupDestroy(byte[] bytes, byte[] bytes1) {
        return null;
    }

    public Long xgroupDelConsumer(byte[] bytes, byte[] bytes1, byte[] bytes2) {
        return null;
    }

    public Long xdel(byte[] bytes, byte[] ... bytes1) {
        return null;
    }

    public Long xtrim(byte[] bytes, long l, boolean b) {
        return null;
    }

    public Long xtrim(byte[] bytes, XTrimParams xTrimParams) {
        return null;
    }

    public Object xpending(byte[] bytes, byte[] bytes1) {
        return null;
    }

    public List<Object> xpending(byte[] bytes, byte[] bytes1, byte[] bytes2, byte[] bytes3, int i, byte[] bytes4) {
        return null;
    }

    public List<Object> xpending(byte[] bytes, byte[] bytes1, XPendingParams xPendingParams) {
        return null;
    }

    public List<byte[]> xclaim(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, long l1, int i, boolean b, byte[][] bytes3) {
        return null;
    }

    public List<byte[]> xclaim(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, XClaimParams xClaimParams, byte[] ... bytes3) {
        return null;
    }

    public List<byte[]> xclaimJustId(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, XClaimParams xClaimParams, byte[] ... bytes3) {
        return null;
    }

    public List<Object> xautoclaim(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, byte[] bytes3, XAutoClaimParams xAutoClaimParams) {
        return null;
    }

    public List<Object> xautoclaimJustId(byte[] bytes, byte[] bytes1, byte[] bytes2, long l, byte[] bytes3, XAutoClaimParams xAutoClaimParams) {
        return null;
    }

    public StreamInfo xinfoStream(byte[] bytes) {
        return null;
    }

    public Object xinfoStreamBinary(byte[] bytes) {
        return null;
    }

    public List<StreamGroupInfo> xinfoGroup(byte[] bytes) {
        return null;
    }

    public List<Object> xinfoGroupBinary(byte[] bytes) {
        return null;
    }

    public List<StreamConsumersInfo> xinfoConsumers(byte[] bytes, byte[] bytes1) {
        return null;
    }

    public List<Object> xinfoConsumersBinary(byte[] bytes, byte[] bytes1) {
        return null;
    }

    public LCSMatchResult strAlgoLCSStrings(byte[] bytes, byte[] bytes1, StrAlgoLCSParams strAlgoLCSParams) {
        return null;
    }

    public List<byte[]> blpop(byte[] arg0) {
        return null;
    }

    public List<byte[]> brpop(byte[] arg0) {
        return null;
    }

    public Long decr(byte[] arg0) {
        return this.modeClient.decr(arg0);
    }

    public Long decrBy(byte[] arg0, long arg1) {
        return null;
    }

    public Long del(byte[] key) {
        return this.modeClient.del(key);
    }

    public Long unlink(byte[] bytes) {
        return null;
    }

    public byte[] echo(byte[] arg0) {
        return null;
    }

    public Boolean exists(byte[] arg0) {
        return this.modeClient.exists(arg0);
    }

    public Long expire(byte[] arg0, int arg1) {
        return this.modeClient.expire(arg0, arg1);
    }

    public Long expire(byte[] bytes, long l) {
        return this.modeClient.expire(bytes, l);
    }

    public Long expireAt(byte[] arg0, long arg1) {
        return this.modeClient.expireAt(arg0, arg1);
    }

    public Long geoadd(byte[] arg0, Map<byte[], GeoCoordinate> arg1) {
        return null;
    }

    public Long geoadd(byte[] bytes, GeoAddParams geoAddParams, Map<byte[], GeoCoordinate> map) {
        return null;
    }

    public Long geoadd(byte[] arg0, double arg1, double arg2, byte[] arg3) {
        return null;
    }

    public Double geodist(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Double geodist(byte[] arg0, byte[] arg1, byte[] arg2, GeoUnit arg3) {
        return null;
    }

    public List<byte[]> geohash(byte[] arg0, byte[] ... arg1) {
        return null;
    }

    public List<GeoCoordinate> geopos(byte[] arg0, byte[] ... arg1) {
        return null;
    }

    public List<GeoRadiusResponse> georadius(byte[] arg0, double arg1, double arg2, double arg3, GeoUnit arg4) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusReadonly(byte[] bytes, double v, double v1, double v2, GeoUnit geoUnit) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusReadonly(byte[] bytes, double v, double v1, double v2, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return null;
    }

    public List<GeoRadiusResponse> georadius(byte[] arg0, double arg1, double arg2, double arg3, GeoUnit arg4, GeoRadiusParam arg5) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] arg0, byte[] arg1, double arg2, GeoUnit arg3) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] bytes, byte[] bytes1, double v, GeoUnit geoUnit) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] arg0, byte[] arg1, double arg2, GeoUnit arg3, GeoRadiusParam arg4) {
        return null;
    }

    public List<GeoRadiusResponse> georadiusByMemberReadonly(byte[] bytes, byte[] bytes1, double v, GeoUnit geoUnit, GeoRadiusParam geoRadiusParam) {
        return null;
    }

    public byte[] get(byte[] key) {
        return this.modeClient.get(key);
    }

    public byte[] getDel(byte[] bytes) {
        return new byte[0];
    }

    public byte[] getEx(byte[] bytes, GetExParams getExParams) {
        return new byte[0];
    }

    public byte[] getSet(byte[] arg0, byte[] arg1) {
        return null;
    }

    public Boolean getbit(byte[] arg0, long arg1) {
        return false;
    }

    public byte[] getrange(byte[] arg0, long arg1, long arg2) {
        return this.modeClient.getrange(arg0, arg1, arg2);
    }

    public Long hdel(byte[] arg0, byte[] ... arg1) {
        return this.modeClient.hdel(arg0, arg1);
    }

    public Boolean hexists(byte[] arg0, byte[] arg1) {
        return this.modeClient.hexists(arg0, arg1);
    }

    public byte[] hget(byte[] arg0, byte[] arg1) {
        return this.modeClient.hget(arg0, arg1);
    }

    public Map<byte[], byte[]> hgetAll(byte[] arg0) {
        return this.modeClient.hgetAll(arg0);
    }

    public byte[] hrandfield(byte[] bytes) {
        return new byte[0];
    }

    public List<byte[]> hrandfield(byte[] bytes, long l) {
        return null;
    }

    public Map<byte[], byte[]> hrandfieldWithValues(byte[] bytes, long l) {
        return null;
    }

    public Long hincrBy(byte[] arg0, byte[] arg1, long arg2) {
        return this.modeClient.hincrBy(arg0, arg1, arg2);
    }

    public Double hincrByFloat(byte[] arg0, byte[] arg1, double arg2) {
        return this.modeClient.hincrByFloat(arg0, arg1, arg2);
    }

    public Set<byte[]> hkeys(byte[] arg0) {
        return this.modeClient.hkeys(arg0);
    }

    public Long hlen(byte[] arg0) {
        return this.modeClient.hlen(arg0);
    }

    public List<byte[]> hmget(byte[] arg0, byte[] ... arg1) {
        return this.modeClient.hmget(arg0, arg1);
    }

    public String hmset(byte[] arg0, Map<byte[], byte[]> arg1) {
        return this.modeClient.hmset(arg0, arg1);
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] arg0, byte[] arg1) {
        return this.modeClient.hscan(arg0, arg1);
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] arg0, byte[] arg1, ScanParams arg2) {
        return this.modeClient.hscan(arg0, arg1, arg2);
    }

    public Long hset(byte[] arg0, byte[] arg1, byte[] arg2) {
        return this.modeClient.hset(arg0, arg1, arg2);
    }

    public Long hset(byte[] bytes, Map<byte[], byte[]> map) {
        return this.modeClient.hset(bytes, map);
    }

    public Long hsetnx(byte[] arg0, byte[] arg1, byte[] arg2) {
        return this.modeClient.hsetnx(arg0, arg1, arg2);
    }

    public List<byte[]> hvals(byte[] arg0) {
        return null;
    }

    public Long incr(byte[] arg0) {
        return this.modeClient.incr(arg0);
    }

    public Long incrBy(byte[] arg0, long arg1) {
        return this.modeClient.incrBy(arg0, arg1);
    }

    public Double incrByFloat(byte[] arg0, double arg1) {
        return this.modeClient.incrByFloat(arg0, arg1);
    }

    public byte[] lindex(byte[] arg0, long arg1) {
        return this.modeClient.lindex(arg0, arg1);
    }

    public Long linsert(byte[] arg0, BinaryClient.LIST_POSITION arg1, byte[] arg2, byte[] arg3) {
        return this.modeClient.linsert(arg0, arg1, arg2, arg3);
    }

    public Long llen(byte[] arg0) {
        return this.modeClient.llen(arg0);
    }

    public byte[] lpop(byte[] arg0) {
        return null;
    }

    public List<byte[]> lpop(byte[] bytes, int i) {
        return null;
    }

    public Long lpos(byte[] bytes, byte[] bytes1) {
        return null;
    }

    public Long lpos(byte[] bytes, byte[] bytes1, LPosParams lPosParams) {
        return null;
    }

    public List<Long> lpos(byte[] bytes, byte[] bytes1, LPosParams lPosParams, long l) {
        return null;
    }

    public Long lpush(byte[] arg0, byte[] ... arg1) {
        return null;
    }

    public Long lpushx(byte[] arg0, byte[] ... arg1) {
        return null;
    }

    public List<byte[]> lrange(byte[] arg0, long arg1, long arg2) {
        return this.modeClient.lrange(arg0, arg1, arg2);
    }

    public Long lrem(byte[] arg0, long arg1, byte[] arg2) {
        return this.modeClient.lrem(arg0, arg1, arg2);
    }

    public String lset(byte[] arg0, long arg1, byte[] arg2) {
        return this.modeClient.lset(arg0, arg1, arg2);
    }

    public String ltrim(byte[] arg0, long arg1, long arg2) {
        return null;
    }

    public Long move(byte[] arg0, int arg1) {
        return null;
    }

    public Long persist(byte[] arg0) {
        return null;
    }

    public Long pexpire(byte[] arg0, long arg1) {
        return null;
    }

    public Long pexpireAt(byte[] arg0, long arg1) {
        return null;
    }

    public Long pfadd(byte[] arg0, byte[] ... arg1) {
        return null;
    }

    public long pfcount(byte[] arg0) {
        return 0L;
    }

    public byte[] rpop(byte[] arg0) {
        return null;
    }

    public List<byte[]> rpop(byte[] bytes, int i) {
        return null;
    }

    public Long rpush(byte[] arg0, byte[] ... arg1) {
        return this.modeClient.rpush(arg0, arg1);
    }

    public Long rpushx(byte[] arg0, byte[] ... arg1) {
        return null;
    }

    public Long sadd(byte[] arg0, byte[] ... arg1) {
        return this.modeClient.sadd(arg0, arg1);
    }

    public Long scard(byte[] arg0) {
        return this.modeClient.scard(arg0);
    }

    public String set(byte[] key, byte[] value) {
        return this.modeClient.set(key, value);
    }

    public String set(byte[] bytes, byte[] bytes1, SetParams setParams) {
        return null;
    }

    public String set(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public String set(byte[] arg0, byte[] arg1, byte[] arg2, byte[] arg3, long arg4) {
        return null;
    }

    public Boolean setbit(byte[] arg0, long arg1, boolean arg2) {
        return false;
    }

    public Boolean setbit(byte[] arg0, long arg1, byte[] arg2) {
        return false;
    }

    public String setex(byte[] key, int timeoutSeconds, byte[] value) {
        return this.modeClient.setex(key, timeoutSeconds, value);
    }

    public String setex(byte[] bytes, long l, byte[] bytes1) {
        return this.modeClient.setex(bytes, l, bytes1);
    }

    public String psetex(byte[] bytes, long l, byte[] bytes1) {
        return null;
    }

    public Long setnx(byte[] arg0, byte[] arg1) {
        return this.modeClient.setnx(arg0, arg1);
    }

    public Long setrange(byte[] arg0, long arg1, byte[] arg2) {
        return null;
    }

    public Boolean sismember(byte[] arg0, byte[] arg1) {
        return this.modeClient.sismember(arg0, arg1);
    }

    public List<Boolean> smismember(byte[] bytes, byte[] ... bytes1) {
        return this.modeClient.smismember(bytes, bytes1);
    }

    public Set<byte[]> smembers(byte[] arg0) {
        return this.modeClient.smembers(arg0);
    }

    public List<byte[]> sort(byte[] arg0) {
        return null;
    }

    public List<byte[]> sort(byte[] arg0, SortingParams arg1) {
        return null;
    }

    public byte[] spop(byte[] arg0) {
        return null;
    }

    public Set<byte[]> spop(byte[] arg0, long arg1) {
        return null;
    }

    public byte[] srandmember(byte[] arg0) {
        return null;
    }

    public List<byte[]> srandmember(byte[] arg0, int arg1) {
        return null;
    }

    public Long srem(byte[] arg0, byte[] ... arg1) {
        return null;
    }

    public ScanResult<byte[]> sscan(byte[] arg0, byte[] arg1) {
        return null;
    }

    public ScanResult<byte[]> sscan(byte[] arg0, byte[] arg1, ScanParams arg2) {
        return null;
    }

    public Long strlen(byte[] arg0) {
        return null;
    }

    public byte[] substr(byte[] arg0, int arg1, int arg2) {
        return null;
    }

    public Long ttl(byte[] arg0) {
        return null;
    }

    public Long pttl(byte[] bytes) {
        return null;
    }

    public Long touch(byte[] bytes) {
        return null;
    }

    public String type(byte[] arg0) {
        return null;
    }

    public byte[] dump(byte[] bytes) {
        return new byte[0];
    }

    public String restore(byte[] bytes, int i, byte[] bytes1) {
        return null;
    }

    public String restore(byte[] bytes, long l, byte[] bytes1) {
        return null;
    }

    public String restoreReplace(byte[] bytes, int i, byte[] bytes1) {
        return null;
    }

    public String restoreReplace(byte[] bytes, long l, byte[] bytes1) {
        return null;
    }

    public String restore(byte[] bytes, long l, byte[] bytes1, RestoreParams restoreParams) {
        return null;
    }

    public Long zadd(byte[] arg0, Map<byte[], Double> arg1) {
        return null;
    }

    public Long zadd(byte[] arg0, double arg1, byte[] arg2) {
        return null;
    }

    public Long zadd(byte[] arg0, Map<byte[], Double> arg1, ZAddParams arg2) {
        return null;
    }

    public Double zaddIncr(byte[] bytes, double v, byte[] bytes1, ZAddParams zAddParams) {
        return null;
    }

    public Long zadd(byte[] arg0, double arg1, byte[] arg2, ZAddParams arg3) {
        return null;
    }

    public Long zcard(byte[] arg0) {
        return null;
    }

    public Long zcount(byte[] arg0, double arg1, double arg2) {
        return null;
    }

    public Long zcount(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Double zincrby(byte[] arg0, double arg1, byte[] arg2) {
        return null;
    }

    public Double zincrby(byte[] arg0, double arg1, byte[] arg2, ZIncrByParams arg3) {
        return null;
    }

    public Long zlexcount(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Set<byte[]> zrange(byte[] arg0, long arg1, long arg2) {
        return null;
    }

    public Set<byte[]> zrangeByLex(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Set<byte[]> zrangeByLex(byte[] arg0, byte[] arg1, byte[] arg2, int arg3, int arg4) {
        return null;
    }

    public Set<byte[]> zrangeByScore(byte[] arg0, double arg1, double arg2) {
        return null;
    }

    public Set<byte[]> zrangeByScore(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Set<byte[]> zrangeByScore(byte[] arg0, double arg1, double arg2, int arg3, int arg4) {
        return null;
    }

    public Set<byte[]> zrangeByScore(byte[] arg0, byte[] arg1, byte[] arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] arg0, double arg1, double arg2) {
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] arg0, double arg1, double arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] arg0, byte[] arg1, byte[] arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrangeWithScores(byte[] arg0, long arg1, long arg2) {
        return null;
    }

    public Long zrank(byte[] arg0, byte[] arg1) {
        return null;
    }

    public Long zrem(byte[] arg0, byte[] ... arg1) {
        return null;
    }

    public Long zremrangeByLex(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Long linsert(byte[] bytes, ListPosition listPosition, byte[] bytes1, byte[] bytes2) {
        return this.modeClient.linsert(bytes, listPosition, bytes1, bytes2);
    }

    public Long zremrangeByRank(byte[] arg0, long arg1, long arg2) {
        return null;
    }

    public Long zremrangeByScore(byte[] arg0, double arg1, double arg2) {
        return null;
    }

    public Long zremrangeByScore(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Set<byte[]> zrevrange(byte[] arg0, long arg1, long arg2) {
        return null;
    }

    public Set<byte[]> zrevrangeByLex(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Set<byte[]> zrevrangeByLex(byte[] arg0, byte[] arg1, byte[] arg2, int arg3, int arg4) {
        return null;
    }

    public Set<byte[]> zrevrangeByScore(byte[] arg0, double arg1, double arg2) {
        return null;
    }

    public Set<byte[]> zrevrangeByScore(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Set<byte[]> zrevrangeByScore(byte[] arg0, double arg1, double arg2, int arg3, int arg4) {
        return null;
    }

    public Set<byte[]> zrevrangeByScore(byte[] arg0, byte[] arg1, byte[] arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] arg0, double arg1, double arg2) {
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] arg0, byte[] arg1, byte[] arg2) {
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] arg0, double arg1, double arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] arg0, byte[] arg1, byte[] arg2, int arg3, int arg4) {
        return null;
    }

    public Set<Tuple> zrevrangeWithScores(byte[] arg0, long arg1, long arg2) {
        return null;
    }

    public byte[] zrandmember(byte[] bytes) {
        return new byte[0];
    }

    public Set<byte[]> zrandmember(byte[] bytes, long l) {
        return null;
    }

    public Set<Tuple> zrandmemberWithScores(byte[] bytes, long l) {
        return null;
    }

    public Long zrevrank(byte[] arg0, byte[] arg1) {
        return null;
    }

    public ScanResult<Tuple> zscan(byte[] arg0, byte[] arg1) {
        return null;
    }

    public ScanResult<Tuple> zscan(byte[] arg0, byte[] arg1, ScanParams arg2) {
        return null;
    }

    public Double zscore(byte[] arg0, byte[] arg1) {
        return null;
    }

    public List<Double> zmscore(byte[] bytes, byte[] ... bytes1) {
        return null;
    }

    public Tuple zpopmax(byte[] bytes) {
        return null;
    }

    public Set<Tuple> zpopmax(byte[] bytes, int i) {
        return null;
    }

    public Tuple zpopmin(byte[] bytes) {
        return null;
    }

    public Set<Tuple> zpopmin(byte[] bytes, int i) {
        return null;
    }

    public void select(int arg0) {
    }

    public List<Map> getRedisInfo() {
        return null;
    }

    public List<Slowlog> getLogs(long arg0) {
        return null;
    }

    public Long dbSize() {
        return null;
    }

    public Object eval(String script, String key, List<String> args) {
        return this.modeClient.eval(script, key, args);
    }

    public Object eval(String arg0, int arg1, String ... arg2) {
        return null;
    }
}

