/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.audit.Audit;
import kd.bos.audit.Auditable;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.cache.DistributeSessionableCache;
import kd.bos.cache.SessionableCacheExt;
import kd.bos.cache.redis.AbstractRedisSessionCache;
import kd.bos.cache.redis.ConsistentHashingBucket;
import kd.bos.cache.redis.Pair;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.ha.component.ComponentStatusManager;
import kd.bos.ha.component.KeepAliveListener;
import kd.bos.ha.component.KeepAliveService;
import kd.bos.instance.Instance;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.util.SafeLogUtils;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class RedisSessionableCache
extends AbstractRedisSessionCache
implements DistributeSessionableCache,
SessionableCacheExt {
    private static final String AUDIT_NAMES = "redis,redis_sessionable";
    private static final String TRACE_NAME = "RedisSessionableCache";
    private static final String SESSION_MANAGER_MAP_KEY = "allsessionidswithtenant" + Instance.getClusterName();
    private static final String SESSION_ID = "sessionId";
    private static final String REMOVE_STR = "remove";
    private static final ConsistentHashingBucket hashBucket;
    private static String sessionKeyPrefix;
    private static AtomicInteger bucketGetPos;
    public static final int sessionSplits = 16;
    private static final String defalultSessionSubfixTime = "02";
    private static final AtomicBoolean hasCleanOldSessionSplitKey;
    private static final List<String> sessionSplitKeyList;

    public RedisSessionableCache() {
        if (Boolean.getBoolean("ha.component.enable") && !this.isUrlListened() && this.listenUrl()) {
            try {
                String className = "kd.bos.cache.database.SessionCacheKeepListener";
                Constructor<?> declaredConstructor = Class.forName(className).getDeclaredConstructor(new Class[0]);
                KeepAliveListener sessionCacheKeepListener = (KeepAliveListener)declaredConstructor.newInstance(new Object[0]);
                KeepAliveService.registerKeepAliveListener((KeepAliveListener)sessionCacheKeepListener);
            }
            catch (Exception ex) {
                return;
            }
        }
    }

    private String getSessionMapKey(String sessionid) {
        String time = sessionid.substring(sessionid.length() - 2);
        try {
            int i = Integer.parseInt(time.substring(1));
            if (i >= 0 && i <= 23) {
                return hashBucket.getBucket(sessionid) + time;
            }
        }
        catch (Exception e) {
            SafeLogUtils.none(RedisSessionableCache.class, (String)"", (Throwable)e);
        }
        return hashBucket.getBucket(sessionid) + defalultSessionSubfixTime;
    }

    private static String truncateValue(String value) {
        if (value == null || value.length() <= 100) {
            return value;
        }
        return value.substring(0, 100) + "......";
    }

    protected void release(JedisClient jedis, boolean isBroken) {
        if (jedis != null) {
            jedis.close();
        }
    }

    @Override
    protected JedisClient createJedisClient() {
        return RedisFactory.getJedisClient((String)this.getRedisUrl());
    }

    @Override
    public String getRedisUrl() {
        String configKey = CacheConfigKeys.getSessionableConfigKey();
        String url = System.getProperty(configKey);
        return url;
    }

    @Override
    boolean isSessionable() {
        return true;
    }

    @Override
    public int getSessionCount() {
        int hlen = 0;
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"getSessionCount");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"getSessionCount"});){
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                for (String sessionManagerKey : hashBucket.getBuckets()) {
                    hlen += jedis.hlen(sessionManagerKey).intValue();
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "getSessionCount", new Object[0]);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
        return hlen;
    }

    public Set<String> getSessionIds() {
        HashSet<String> set = new HashSet<String>();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"getSessionIds");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"getSessionIds"});){
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                for (String sessionManagerKey : hashBucket.getBuckets()) {
                    set.addAll(jedis.hkeys(sessionManagerKey));
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "getSessionIds", new Object[0]);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
        return set;
    }

    private int getNextBucketPos() {
        int max = hashBucket.getBuckets().size();
        if (bucketGetPos.incrementAndGet() >= max) {
            bucketGetPos.set(0);
        }
        return bucketGetPos.intValue();
    }

    public Map<String, String> getPartSessionIdsWithAccountId() {
        HashMap<String, String> m = new HashMap<String, String>();
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"getPartSessionIdsWithAccountId");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"getPartSessionIdsWithAccountId"});){
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                if (sessionSplitKeyList != null && sessionSplitKeyList.size() > 0) {
                    try {
                        if (hasCleanOldSessionSplitKey.compareAndSet(false, true)) {
                            for (int i = sessionSplitKeyList.size() - 1; i >= 0; --i) {
                                jedis.del(sessionSplitKeyList.get(i));
                            }
                        }
                    }
                    catch (Exception e) {
                        SafeLogUtils.error(this.getClass(), (String)"remove old sessionsplitkey error ", (Throwable)e);
                    }
                }
                HashMap<String, String> _m = new HashMap<String, String>();
                String bucketKey = hashBucket.getBuckets().get(this.getNextBucketPos());
                ScanParams scanParams = new ScanParams();
                scanParams.count(Integer.valueOf(1000));
                boolean[] needcheck = this.getNeedCheckTimeArea();
                for (int i = 0; i < needcheck.length; ++i) {
                    if (!needcheck[i]) continue;
                    String key = bucketKey + (i <= 9 ? "0" + i : "" + i);
                    this.scanBucket(jedis, scanParams, key, _m);
                }
                if (_m != null) {
                    m.putAll(_m);
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "getPartSessionIdsWithAccountId", new Object[0]);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
        return m;
    }

    private void scanBucket(JedisClient jedis, ScanParams scanParams, String bucketKey, Map<String, String> _m) {
        Long len = jedis.hlen(bucketKey);
        if (len > (long)Integer.getInteger("session.bucket.max", 50000).intValue()) {
            jedis.del(bucketKey);
            SafeLogUtils.info(this.getClass(), (String)("sessionbucket " + bucketKey + " over maxsize and to del,size is " + len));
            return;
        }
        if (len == 0L) {
            return;
        }
        try {
            ScanResult scanResult;
            String cursor = "0";
            do {
                scanResult = jedis.hscan(bucketKey, cursor, scanParams);
                cursor = scanResult.getCursor();
                scanResult.getResult().forEach(v -> _m.put((String)v.getKey(), (String)v.getValue()));
            } while (!scanResult.isCompleteIteration());
        }
        catch (Exception e) {
            SafeLogUtils.error(this.getClass(), (String)"hscan error ", (Throwable)e);
        }
    }

    private boolean[] getNeedCheckTimeArea() {
        int sessionTimeoutHour = Integer.getInteger("session.timeout", 28800) / 3600;
        boolean[] bs = new boolean[24];
        Arrays.fill(bs, true);
        if (sessionTimeoutHour >= 24) {
            return bs;
        }
        int curHourOfDay = RedisSessionableCache.getHourOfDay();
        for (int i = 0; i < sessionTimeoutHour; ++i) {
            int index = curHourOfDay - i;
            if (index < 0) {
                index += 24;
            }
            bs[index] = false;
        }
        return bs;
    }

    private static int getHourOfDay() {
        long curTime = System.currentTimeMillis();
        long timeOfDay = curTime % 86400000L;
        int hour = (int)timeOfDay / 3600000;
        return hour;
    }

    private String getKey(String sessionId) {
        return sessionKeyPrefix + sessionId;
    }

    @Override
    public void put(String sessionId, String key, String value) {
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"put");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"put", sessionId, key});){
            span.addTag(SESSION_ID, sessionId);
            span.addTag("key", key);
            span.addTag("value", value);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.hset(this.getKey(sessionId), key, value);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hset", this.getKey(sessionId), key, value);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    @Override
    public void put(String sessionId, Map<String, String> keyValues) {
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"put");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"put", sessionId});){
            span.addTag(SESSION_ID, sessionId);
            span.addTag("keyValues", RedisSessionableCache.truncateValue(keyValues.toString()));
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.hmset(this.getKey(sessionId), keyValues);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hmset", this.getKey(sessionId), keyValues);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public String get(String sessionId, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void remove(String sessionId, String key) {
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)REMOVE_STR);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{REMOVE_STR, sessionId, key});){
            span.addTag(SESSION_ID, sessionId);
            span.addTag("key", key);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.hdel(this.getKey(sessionId), new String[]{key});
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hdel", this.getKey(sessionId), key);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean contains(String sessionId, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void remove(String sessionId) {
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)REMOVE_STR);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{REMOVE_STR, sessionId});){
            span.addTag(SESSION_ID, sessionId);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.del(this.getKey(sessionId));
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "del", this.getKey(sessionId));
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Map<String, String> getAll(String sessionId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> get(String sessionId, String[] keys) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expireAfter(String sessionId, int second) {
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"expireAfter");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"expireAfter", sessionId, second});){
            span.addTag(SESSION_ID, sessionId);
            span.addTag("second", String.valueOf(second));
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.expire(this.getKey(sessionId), second);
            }
            catch (Exception e) {
                isBroken = true;
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    @Override
    public void remove(String sessionId, String[] keys) {
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)REMOVE_STR);
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{REMOVE_STR, sessionId, keys});){
            span.addTag(SESSION_ID, sessionId);
            span.addTag("keys", RedisSessionableCache.truncateValue(Arrays.toString(keys)));
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                jedis.hdel(this.getKey(sessionId), keys);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "hdel", this.getKey(sessionId), keys);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    @Override
    public List<String> getKeys(String sessionId) {
        return this.getKeysWithPrefix(sessionId, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getKeysWithPrefix(String sessionId, String prefix) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void addSessionId(String sessionId, String accountid) {
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"addSessionId");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"addSessionId", sessionId, accountid});){
            span.addTag(SESSION_ID, sessionId);
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                String key = this.getSessionMapKey(sessionId);
                jedis.hset(key, sessionId, accountid);
                jedis.expire(key, 172800);
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "addSessionId", sessionId, accountid);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    @Override
    public void removeSessionId(String ... sessionId) {
        try (TraceSpan span = Tracer.create((String)TRACE_NAME, (String)"removeSessionId");
             Auditable audit = Audit.audit((String)AUDIT_NAMES, (Object[])new Object[]{"removeSessionId", sessionId});){
            JedisClient jedis = this.getJedis();
            boolean isBroken = false;
            try {
                for (String s : sessionId) {
                    jedis.hdel(this.getSessionMapKey(s), new String[]{s});
                }
            }
            catch (Exception e) {
                isBroken = true;
                Pair<ErrorCode, String> exceptionInfo = this.buildJedisExceptionInfo(e, "removeSessionId", sessionId);
                throw new KDException((Throwable)e, exceptionInfo.getKey(), new Object[]{exceptionInfo.getValue()});
            }
            finally {
                this.release(jedis, isBroken);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean existsSession(String sessionId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isAvailable() {
        return !ComponentStatusManager.isException((String)this.getRedisUrl());
    }

    static {
        sessionKeyPrefix = "Session-";
        bucketGetPos = new AtomicInteger(0);
        hasCleanOldSessionSplitKey = new AtomicBoolean(false);
        sessionSplitKeyList = new ArrayList<String>(16);
        for (int i = 0; i < 16; ++i) {
            sessionSplitKeyList.add(SESSION_MANAGER_MAP_KEY + i);
        }
        hashBucket = new ConsistentHashingBucket(sessionSplitKeyList);
        try {
            int sleepSeconds = Integer.getInteger("sessionmanager.sleepsecond", 5);
            long s = System.currentTimeMillis() / 1000L % (long)(16 * sleepSeconds);
            int pos = (int)s / sleepSeconds;
            bucketGetPos = new AtomicInteger(pos < 0 ? 0 : pos);
        }
        catch (Throwable e) {
            SafeLogUtils.error(RedisSessionableCache.class, (String)"set bucket Pos error", (Throwable)e);
        }
    }
}

