/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.cache.redis.AbstractRedisSessionCache;
import kd.bos.redis.JedisClient;
import kd.bos.util.DisCardUtil;

public class RedisSessionlessTimerExpire {
    protected Map<String, Integer> cacheKeyExpried = new LinkedHashMap<String, Integer>(128, 0.75f, true){
        private static final long serialVersionUID = -3966777179407842317L;
        private final Lock lock;
        {
            this.lock = new ReentrantLock();
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
            return this.size() > 100000;
        }

        @Override
        public Integer get(Object key) {
            try {
                this.lock.lock();
                Integer n = (Integer)super.get(key);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Integer put(String key, Integer value) {
            try {
                this.lock.lock();
                Integer n = super.put(key, value);
                return n;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public boolean containsKey(Object key) {
            try {
                this.lock.lock();
                boolean bl = super.containsKey(key);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    };
    protected ConcurrentHashMap<String, Long> touchTimestampMap = new ConcurrentHashMap();
    private AbstractRedisSessionCache abstractRedisSessionCache;

    public RedisSessionlessTimerExpire(String region, AbstractRedisSessionCache abstractRedisSessionCache) {
        this.abstractRedisSessionCache = abstractRedisSessionCache;
        this.initTimerExpire(region);
    }

    private void initTimerExpire(String region) {
        try {
            int index = region.indexOf(47);
            if (index > 0) {
                region = region.substring(0, index);
            }
            Timer timer = new Timer("Cache-Timeout-Daemon_" + region, true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        ArrayList keys = new ArrayList();
                        RedisSessionlessTimerExpire.this.touchTimestampMap.forEach((k, v) -> {
                            if ((System.currentTimeMillis() - v) / 1000L > 5L) {
                                keys.add(k);
                            }
                        });
                        for (String key : keys) {
                            try {
                                int ttl = (int)((long)RedisSessionlessTimerExpire.this.cacheKeyExpried.get(key).intValue() - (System.currentTimeMillis() - RedisSessionlessTimerExpire.this.touchTimestampMap.get(key)) / 1000L);
                                try (JedisClient jedis = RedisSessionlessTimerExpire.this.abstractRedisSessionCache.getJedis();){
                                    jedis.expire(key, ttl);
                                }
                                RedisSessionlessTimerExpire.this.touchTimestampMap.remove(key);
                            }
                            catch (Exception t) {
                                DisCardUtil.discard();
                            }
                        }
                    }
                    catch (Exception e) {
                        DisCardUtil.discard();
                    }
                }
            }, 10000L, 30000L);
        }
        catch (Exception e) {
            DisCardUtil.discard();
        }
    }
}

