/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public class TruncateUtils {
    private static final char[] MAP_TAGS = new char[]{'{', '}'};
    private static final char[] ARRAY_TAGS = new char[]{'[', ']'};
    private static final String COLLECTION_SPILLER = ", ";
    public static final int MAX_VALUE_LEN = 128;
    public static final int MAX_KEY_LEN = 256;
    public static final int MAX_ELEMENTS_SIZE = 32;
    private static final String MORE_CHARACTERS_FORMAT = "%s... (%s more characters)";
    private static final String MORE_ELEMENTS_FORMAT = "... (%s more elements)";

    private TruncateUtils() {
    }

    public static String truncateValue(String value) {
        return TruncateUtils.truncate(value, 128);
    }

    public static String truncateKey(String key) {
        return TruncateUtils.truncate(key, 256);
    }

    public static String truncateKeys(String[] keys) {
        return TruncateUtils.truncateArray(keys, k -> TruncateUtils.truncateKey(k));
    }

    public static String truncateValues(String[] values) {
        return TruncateUtils.truncateArray(values, v -> TruncateUtils.truncateValue(v));
    }

    public static String truncateValues(Map<String, String> values) {
        if (values == null) {
            return null;
        }
        return TruncateUtils.truncate(values.entrySet(), MAP_TAGS, each -> String.format("%s=%s", TruncateUtils.truncateKey((String)each.getKey()), TruncateUtils.truncateValue((String)each.getValue())));
    }

    private static <T> String truncateArray(T[] values, Function<T, String> mapper) {
        if (values == null) {
            return null;
        }
        int size = Math.min(values.length, 32);
        ArrayList<T> results = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            results.add(values[i]);
        }
        return TruncateUtils.truncate(results, ARRAY_TAGS, values.length - size, mapper);
    }

    private static <T> String truncate(Collection<T> values, char[] wrapperTags, Function<T, String> mapper) {
        return TruncateUtils.truncate(values, wrapperTags, 0, mapper);
    }

    private static <T> String truncate(Collection<T> values, char[] wrapperTags, int moreSize, Function<T, String> mapper) {
        StringBuilder sb = new StringBuilder();
        sb.append(wrapperTags[0]);
        boolean isFirst = true;
        int size = Math.min(values.size(), 32);
        int more = values.size() - size + moreSize;
        for (T each : values) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(COLLECTION_SPILLER);
            }
            sb.append(mapper.apply(each));
            if (--size > 0) continue;
            break;
        }
        if (more > 0) {
            sb.append(COLLECTION_SPILLER);
            sb.append(String.format(MORE_ELEMENTS_FORMAT, more));
        }
        sb.append(wrapperTags[1]);
        return sb.toString();
    }

    private static String truncate(String value, int maxLen) {
        if (value == null || value.length() <= maxLen) {
            return value;
        }
        return String.format(MORE_CHARACTERS_FORMAT, value.substring(0, maxLen), value.length() - maxLen);
    }
}

