/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.redis;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.XCacheConfigManager;
import kd.bos.cache.redis.RedisSessionlessCache;
import kd.bos.cache.redis.XCacheSessionlessCache;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import redis.clients.jedis.util.SafeEncoder;

public class XCacheWhiteListCacheWrapper
extends RedisSessionlessCache
implements DistributeSessionlessCache {
    private final String region;
    private final DistributeSessionlessCache xcache;

    public XCacheWhiteListCacheWrapper(String region) {
        super(region);
        this.region = region;
        this.xcache = new XCacheSessionlessCache(region);
        XCacheConfigManager.register(region);
    }

    private boolean isXCache(String key) {
        if (!XCacheConfigManager.isXCacheEnabled(this.region)) {
            return false;
        }
        if (XCacheConfigManager.getMatcher().isMatchAll()) {
            return true;
        }
        return XCacheConfigManager.getMatcher().isMatch(key);
    }

    @Override
    public void pipelinedMode() {
        if (XCacheConfigManager.isXCacheEnabled(this.region) && XCacheConfigManager.getMatcher().isMatchAll()) {
            this.xcache.pipelinedMode();
        } else {
            super.pipelinedMode();
        }
    }

    @Override
    public void singleMode() {
        if (XCacheConfigManager.isXCacheEnabled(this.region) && XCacheConfigManager.getMatcher().isMatchAll()) {
            this.xcache.singleMode();
        } else {
            super.singleMode();
        }
    }

    @Override
    public List<Object> syncAndReturn() {
        return XCacheConfigManager.isXCacheEnabled(this.region) && XCacheConfigManager.getMatcher().isMatchAll() ? this.xcache.syncAndReturn() : super.syncAndReturn();
    }

    @Override
    public int addList(String key, String[] values) {
        return this.isXCache(key) ? this.xcache.addList(key, values) : super.addList(key, values);
    }

    @Override
    public int addList(String key, String[] values, int timeoutSeconds) {
        return this.isXCache(key) ? this.xcache.addList(key, values, timeoutSeconds) : super.addList(key, values, timeoutSeconds);
    }

    @Override
    public int addList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        return this.isXCache(key) ? this.xcache.addList(key, values, timeout, timeUnit) : super.addList(key, values, timeout, timeUnit);
    }

    @Override
    public int resetList(String key, String[] values, int timeoutSeconds) {
        return this.isXCache(key) ? this.xcache.resetList(key, values, timeoutSeconds) : super.resetList(key, values, timeoutSeconds);
    }

    @Override
    public int resetList(String key, String[] values, int timeout, TimeUnit timeUnit) {
        return this.isXCache(key) ? this.xcache.resetList(key, values, timeout, timeUnit) : super.resetList(key, values, timeout, timeUnit);
    }

    @Override
    public int insertList(String key, int index, String[] values) {
        return this.isXCache(key) ? this.xcache.insertList(key, index, values) : super.insertList(key, index, values);
    }

    @Override
    public void setListObject(String key, int index, String value) {
        if (this.isXCache(key)) {
            this.xcache.setListObject(key, index, value);
        } else {
            super.setListObject(key, index, value);
        }
    }

    @Override
    public String[] getList(String key) {
        return this.isXCache(key) ? this.xcache.getList(key) : super.getList(key);
    }

    @Override
    public String[] getList(String key, int index, int length) {
        return this.isXCache(key) ? this.xcache.getList(key, index, length) : super.getList(key, index, length);
    }

    @Override
    public String getListObject(String key, int index) {
        return this.isXCache(key) ? this.xcache.getListObject(key, index) : super.getListObject(key, index);
    }

    @Override
    public void removeListObject(String key, int index) {
        if (this.isXCache(key)) {
            this.xcache.removeListObject(key, index);
        } else {
            super.removeListObject(key, index);
        }
    }

    @Override
    public void removeListObjects(String key, int index, int length) {
        if (this.isXCache(key)) {
            this.xcache.removeListObjects(key, index, length);
        } else {
            super.removeListObjects(key, index, length);
        }
    }

    @Override
    public int getListLength(String key) {
        return this.isXCache(key) ? this.xcache.getListLength(key) : super.getListLength(key);
    }

    @Override
    public int addToSet(String key, String[] values) {
        return this.isXCache(key) ? this.xcache.addToSet(key, values) : super.addToSet(key, values);
    }

    @Override
    public int addToSet(String key, String[] values, int timeoutSeconds) {
        return this.isXCache(key) ? this.xcache.addToSet(key, values, timeoutSeconds) : super.addToSet(key, values, timeoutSeconds);
    }

    @Override
    public int addToSet(String key, String[] values, int timeout, TimeUnit timeUnit) {
        return this.isXCache(key) ? this.xcache.addToSet(key, values, timeout, timeUnit) : super.addToSet(key, values, timeout, timeUnit);
    }

    @Override
    public void removeSetValues(String key, String[] values) {
        if (this.isXCache(key)) {
            this.xcache.removeSetValues(key, values);
        } else {
            super.removeSetValues(key, values);
        }
    }

    @Override
    public String[] getSetValues(String key) {
        return this.isXCache(key) ? this.xcache.getSetValues(key) : super.getSetValues(key);
    }

    @Override
    public int getSetLength(String key) {
        return this.isXCache(key) ? this.xcache.getSetLength(key) : super.getSetLength(key);
    }

    @Override
    public void put(String key, byte[] value) {
        if (this.isXCache(key)) {
            this.xcache.put(key, value);
        } else {
            super.put(key, value);
        }
    }

    @Override
    public void put(String key, byte[] value, int timeoutSeconds) {
        if (this.isXCache(key)) {
            this.xcache.put(key, value, timeoutSeconds);
        } else {
            super.put(key, value, timeoutSeconds);
        }
    }

    @Override
    public byte[] getByteValue(String key) {
        return this.isXCache(key) ? this.xcache.getByteValue(key) : super.getByteValue(key);
    }

    @Override
    public void hset(String key, byte[] field, byte[] value) {
        if (this.isXCache(key)) {
            this.xcache.hset(key, field, value);
        } else {
            super.hset(key, field, value);
        }
    }

    @Override
    public void hset(String key, byte[] field, byte[] value, int timeoutSeconds) {
        if (this.isXCache(key)) {
            this.xcache.hset(key, field, value, timeoutSeconds);
        } else {
            super.hset(key, field, value, timeoutSeconds);
        }
    }

    @Override
    public void hmset(String key, Map<byte[], byte[]> hash) {
        if (this.isXCache(key)) {
            this.xcache.hmset(key, hash);
        } else {
            super.hmset(key, hash);
        }
    }

    @Override
    public void hmset(String key, Map<byte[], byte[]> hash, int timeoutSeconds) {
        if (this.isXCache(key)) {
            this.xcache.hmset(key, hash, timeoutSeconds);
        } else {
            super.hmset(key, hash, timeoutSeconds);
        }
    }

    @Override
    public byte[] hget(String key, byte[] field) {
        return this.isXCache(key) ? this.xcache.hget(key, field) : super.hget(key, field);
    }

    @Override
    public Map<byte[], byte[]> hgetAll(String key) {
        return this.isXCache(key) ? this.xcache.hgetAll(key) : super.hgetAll(key);
    }

    @Override
    public List<byte[]> hmget(String key, byte[] ... fields) {
        return this.isXCache(key) ? this.xcache.hmget(key, fields) : super.hmget(key, fields);
    }

    @Override
    @Deprecated
    public Object eval(String lua, String key, List<String> params) {
        return this.isXCache(key) ? this.xcache.eval(lua, key, params) : super.eval(lua, key, params);
    }

    @Override
    public boolean isAvailable() {
        if (!XCacheConfigManager.isXCacheEnabled(this.region)) {
            return super.isAvailable();
        }
        return XCacheConfigManager.getMatcher().isMatchAll() ? this.xcache.isAvailable() : super.isAvailable() && this.xcache.isAvailable();
    }

    @Override
    public void put(String key, String s) {
        if (this.isXCache(key)) {
            this.xcache.put(key, s);
        } else {
            super.put(key, s);
        }
    }

    @Override
    public void put(String key, String s, int timeoutSeconds) {
        if (this.isXCache(key)) {
            this.xcache.put(key, s, timeoutSeconds);
        } else {
            super.put(key, s, timeoutSeconds);
        }
    }

    @Override
    public void put(String key, String s, int timeout, TimeUnit timeUnit) {
        if (this.isXCache(key)) {
            this.xcache.put(key, s, timeout, timeUnit);
        } else {
            super.put(key, s, timeout, timeUnit);
        }
    }

    @Override
    public long inc(String key, int timeoutSeconds) {
        return this.isXCache(key) ? this.xcache.inc(key, timeoutSeconds) : super.inc(key, timeoutSeconds);
    }

    @Override
    public long decr(String key, int timeout, TimeUnit timeUnit) {
        return this.isXCache(key) ? this.xcache.decr(key, timeout, timeUnit) : super.decr(key, timeout, timeUnit);
    }

    @Override
    public long decr(String key, int timeoutSeconds) {
        return this.isXCache(key) ? this.xcache.decr(key, timeoutSeconds) : super.decr(key, timeoutSeconds);
    }

    @Override
    public long inc(String key, int timeout, TimeUnit timeUnit) {
        return this.isXCache(key) ? this.xcache.inc(key, timeout, timeUnit) : super.inc(key, timeout, timeUnit);
    }

    @Override
    public long inc(String key) {
        return this.isXCache(key) ? this.xcache.inc(key) : super.inc(key);
    }

    @Override
    public long incrBy(String key, int amount) {
        return this.isXCache(key) ? this.xcache.incrBy(key, amount) : super.incrBy(key, amount);
    }

    @Override
    public long decr(String key) {
        return this.isXCache(key) ? this.xcache.decr(key) : super.decr(key);
    }

    @Override
    public void put(String type, Map<String, String> keyValues) {
        if (this.isXCache(type)) {
            this.xcache.put(type, keyValues);
        } else {
            super.put(type, keyValues);
        }
    }

    @Override
    public void put(String type, Map<String, String> keyValues, int timeoutSeconds) {
        if (this.isXCache(type)) {
            this.xcache.put(type, keyValues, timeoutSeconds);
        } else {
            super.put(type, keyValues, timeoutSeconds);
        }
    }

    @Override
    public void put(String type, Map<String, String> keyValues, int timeout, TimeUnit timeUnit) {
        if (this.isXCache(type)) {
            this.xcache.put(type, keyValues, timeout, timeUnit);
        } else {
            super.put(type, keyValues, timeout, timeUnit);
        }
    }

    @Override
    public void put(String type, String key, String s) {
        if (this.isXCache(type)) {
            this.xcache.put(type, key, s);
        } else {
            super.put(type, key, s);
        }
    }

    @Override
    public void put(String type, String key, String value, int timeoutSeconds) {
        if (this.isXCache(type)) {
            this.xcache.put(type, key, value, timeoutSeconds);
        } else {
            super.put(type, key, value, timeoutSeconds);
        }
    }

    @Override
    public void put(String type, String key, String value, int timeout, TimeUnit timeUnit) {
        if (this.isXCache(type)) {
            this.xcache.put(type, key, value, timeout, timeUnit);
        } else {
            super.put(type, key, value, timeout, timeUnit);
        }
    }

    @Override
    public String get(String key) {
        return this.isXCache(key) ? (String)this.xcache.get(key) : super.get(key);
    }

    @Override
    public String get(String type, String key) {
        return this.isXCache(type) ? (String)this.xcache.get(type, key) : super.get(type, key);
    }

    @Override
    public List<String> get(String type, String[] keys) {
        return this.isXCache(type) ? this.xcache.get(type, keys) : super.get(type, keys);
    }

    @Override
    public Map<String, String> getAll(String type) {
        return this.isXCache(type) ? this.xcache.getAll(type) : super.getAll(type);
    }

    @Override
    public void remove(String key) {
        if (this.isXCache(key)) {
            this.xcache.remove(key);
        } else {
            super.remove(key);
        }
    }

    @Override
    public void remove(String[] keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        if (!XCacheConfigManager.isXCacheEnabled(this.region)) {
            super.remove(keys);
            return;
        }
        ArrayList<String> redisKeys = new ArrayList<String>();
        ArrayList<String> xcacheKeys = new ArrayList<String>();
        for (String key : keys) {
            if (XCacheConfigManager.getMatcher().isMatch(key)) {
                xcacheKeys.add(key);
                continue;
            }
            redisKeys.add(key);
        }
        if (redisKeys.isEmpty() || xcacheKeys.isEmpty()) {
            if (xcacheKeys.isEmpty()) {
                super.remove(redisKeys.toArray(new String[redisKeys.size()]));
            } else {
                this.xcache.remove(xcacheKeys.toArray(new String[xcacheKeys.size()]));
            }
        } else {
            Exception redisException = null;
            Exception xcacheException = null;
            try {
                super.remove(redisKeys.toArray(new String[redisKeys.size()]));
            }
            catch (Exception e) {
                redisException = e;
            }
            try {
                this.xcache.remove(xcacheKeys.toArray(new String[xcacheKeys.size()]));
            }
            catch (Exception e) {
                xcacheException = e;
            }
            if (redisException != null || xcacheException != null) {
                String optErrorMessage = String.format("Error occurred when remove keys(total: %s; redisFailed: %s; xcacheFailed: %s)", keys.length, redisException != null ? redisKeys.size() : 0, xcacheException != null ? xcacheKeys.size() : 0);
                throw XCacheWhiteListCacheWrapper.combineException(redisException, xcacheException, optErrorMessage);
            }
        }
    }

    private static KDException combineException(Exception redisException, Exception xcacheException, String optErrorMessage) {
        ErrorCode errorCode = BosErrorCode.jedisDataException;
        if (redisException instanceof KDException) {
            errorCode = ((KDException)((Object)redisException)).getErrorCode();
        } else if (xcacheException instanceof KDException) {
            errorCode = ((KDException)((Object)xcacheException)).getErrorCode();
        }
        if (redisException != null && xcacheException != null) {
            Exception casue = redisException;
            Exception suppressed = xcacheException;
            if (!(redisException instanceof KDException) && xcacheException instanceof KDException) {
                casue = xcacheException;
                suppressed = redisException;
            }
            KDException exception = new KDException((Throwable)casue, errorCode, new Object[]{optErrorMessage});
            exception.addSuppressed((Throwable)suppressed);
            return exception;
        }
        return new KDException((Throwable)(redisException != null ? redisException : xcacheException), errorCode, new Object[]{optErrorMessage});
    }

    @Override
    public void remove(String type, String key) {
        if (this.isXCache(type)) {
            this.xcache.remove(type, key);
        } else {
            super.remove(type, key);
        }
    }

    @Override
    public void remove(String type, String[] keys) {
        if (this.isXCache(type)) {
            this.xcache.remove(type, keys);
        } else {
            super.remove(type, keys);
        }
    }

    @Override
    public void removeType(String type) {
        if (this.isXCache(type)) {
            this.xcache.removeType(type);
        } else {
            super.removeType(type);
        }
    }

    @Override
    public boolean contains(String key) {
        return this.isXCache(key) ? this.xcache.contains(key) : super.contains(key);
    }

    @Override
    public boolean contains(String type, String key) {
        return this.isXCache(type) ? this.xcache.contains(type, key) : super.contains(type, key);
    }

    @Override
    public List<String> getKeys(String type) {
        return this.isXCache(type) ? this.xcache.getKeys(type) : super.getKeys(type);
    }

    @Override
    public List<String> getKeysWithPrefix(String type, String prefix) {
        return this.isXCache(type) ? this.xcache.getKeysWithPrefix(type, prefix) : super.getKeysWithPrefix(type, prefix);
    }

    @Override
    public List<String> getKeysWithPrefix(String prefix) {
        if (!XCacheConfigManager.isXCacheEnabled(this.region)) {
            return super.getKeysWithPrefix(prefix);
        }
        if (XCacheConfigManager.getMatcher().isMatchAll()) {
            return this.xcache.getKeysWithPrefix(prefix);
        }
        if (XCacheConfigManager.getMatcher().isMatchNone()) {
            return super.getKeysWithPrefix(prefix);
        }
        LinkedList<String> result = new LinkedList<String>();
        Exception redisException = null;
        Exception xcacheException = null;
        try {
            result.addAll(super.getKeysWithPrefix(prefix));
        }
        catch (Exception e) {
            redisException = e;
        }
        try {
            result.addAll(this.xcache.getKeysWithPrefix(prefix));
        }
        catch (Exception e) {
            xcacheException = e;
        }
        if (redisException != null || xcacheException != null) {
            String optErrorMessage = String.format("Error occurred when get key with prefix: %s", prefix);
            throw XCacheWhiteListCacheWrapper.combineException(redisException, xcacheException, optErrorMessage);
        }
        return result;
    }

    @Override
    public void expireAfter(String keyOrType, int second) {
        if (this.isXCache(keyOrType)) {
            this.xcache.expireAfter(keyOrType, second);
        } else {
            super.expireAfter(keyOrType, second);
        }
    }

    @Override
    public void expireAfter(String keyOrType, int timeout, TimeUnit timeUnit) {
        if (this.isXCache(keyOrType)) {
            this.xcache.expireAfter(keyOrType, timeout, timeUnit);
        } else {
            super.expireAfter(keyOrType, timeout, timeUnit);
        }
    }

    @Override
    public void expireAfterImmediateEffect(String keyOrType, int timeout, TimeUnit timeUnit) {
        if (this.isXCache(keyOrType)) {
            this.xcache.expireAfterImmediateEffect(keyOrType, timeout, timeUnit);
        } else {
            super.expireAfterImmediateEffect(keyOrType, timeout, timeUnit);
        }
    }

    @Override
    public void put(byte[] key, byte[] value, int timeout) {
        if (this.isXCache(SafeEncoder.encode((byte[])key))) {
            this.xcache.put(key, value, timeout);
        } else {
            super.put(key, value, timeout);
        }
    }

    @Override
    public byte[] get(byte[] key) {
        return this.isXCache(SafeEncoder.encode((byte[])key)) ? this.xcache.get(key) : super.get(key);
    }

    @Override
    public void remove(byte[] key) {
        if (this.isXCache(SafeEncoder.encode((byte[])key))) {
            this.xcache.remove(key);
        } else {
            super.remove(key);
        }
    }
}

