/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.cache.tempfile;

import kd.bos.cache.tempfile.DefaultTempFileExtensionImpl;
import kd.bos.cache.tempfile.TempFileExtension;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;

public class TempFileExtensionFactory {
    private static Log logger = LogFactory.getLog(TempFileExtensionFactory.class);
    private static final String CLASSNAME_KEY = "TempFileExtension.impl.classname";

    public static TempFileExtension get() {
        String className = System.getProperty(CLASSNAME_KEY, "");
        if (!className.isEmpty()) {
            try {
                return (TempFileExtension)Class.forName(className).newInstance();
            }
            catch (Exception t) {
                logger.error("init class " + className + " error:", (Throwable)t);
            }
        }
        return new DefaultTempFileExtensionImpl();
    }

    public static boolean hasTempFileExtension() {
        String className = System.getProperty(CLASSNAME_KEY, "");
        return StringUtils.isNotEmpty((String)className);
    }
}

