/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core;

import kd.bos.armor.core.ErrorEntryFreeException;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.node.Node;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.armor.core.slots.block.BlockException;
import kd.bos.armor.core.util.TimeUtil;
import kd.bos.armor.core.util.function.BiConsumer;

public abstract class Entry
implements AutoCloseable {
    private static final Object[] OBJECTS0 = new Object[0];
    protected final ResourceWrapper resourceWrapper;
    private final long createTimestamp;
    private long completeTimestamp;
    private Node curNode;
    private Node originNode;
    private Throwable error;
    private BlockException blockError;

    public Entry(ResourceWrapper resourceWrapper) {
        this.resourceWrapper = resourceWrapper;
        this.createTimestamp = TimeUtil.currentTimeMillis();
    }

    public ResourceWrapper getResourceWrapper() {
        return this.resourceWrapper;
    }

    public void exit() throws ErrorEntryFreeException {
        this.exit(1, OBJECTS0);
    }

    public void exit(int count) throws ErrorEntryFreeException {
        this.exit(count, OBJECTS0);
    }

    @Override
    public void close() {
        this.exit();
    }

    public abstract void exit(int var1, Object ... var2) throws ErrorEntryFreeException;

    protected abstract Entry trueExit(int var1, Object ... var2) throws ErrorEntryFreeException;

    public abstract Node getLastNode();

    public long getCreateTimestamp() {
        return this.createTimestamp;
    }

    public long getCompleteTimestamp() {
        return this.completeTimestamp;
    }

    public Entry setCompleteTimestamp(long completeTimestamp) {
        this.completeTimestamp = completeTimestamp;
        return this;
    }

    public Node getCurNode() {
        return this.curNode;
    }

    public void setCurNode(Node node) {
        this.curNode = node;
    }

    public BlockException getBlockError() {
        return this.blockError;
    }

    public Entry setBlockError(BlockException blockError) {
        this.blockError = blockError;
        return this;
    }

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public Node getOriginNode() {
        return this.originNode;
    }

    public void setOriginNode(Node originNode) {
        this.originNode = originNode;
    }

    public abstract void whenTerminate(BiConsumer<Context, Entry> var1);
}

