/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.config;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.armor.core.config.ArmorConfigLoader;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.util.AssertUtil;
import kd.bos.armor.core.util.StringUtil;

public final class ArmorConfig {
    public static final int APP_TYPE_COMMON = 0;
    public static final String FLOW_RULE_TYPE = "flow";
    public static final String DEGRADE_RULE_TYPE = "degrade";
    public static final String PROJECT_NAME_PROP_KEY = "project.name";
    public static final String APP_NAME_PROP_KEY = "armor.app.name";
    public static final String APP_TYPE_PROP_KEY = "armor.app.type";
    public static final String CHARSET = "armor.charset";
    public static final String SINGLE_METRIC_FILE_SIZE = "armor.metric.file.single.size";
    public static final String TOTAL_METRIC_FILE_COUNT = "armor.metric.file.total.count";
    public static final String COLD_FACTOR = "armor.flow.cold.factor";
    public static final String STATISTIC_MAX_RT = "armor.statistic.max.rt";
    public static final String SPI_CLASSLOADER = "armor.spi.classloader";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final long DEFAULT_SINGLE_METRIC_FILE_SIZE = 0x3200000L;
    public static final int DEFAULT_TOTAL_METRIC_FILE_COUNT = 6;
    public static final int DEFAULT_COLD_FACTOR = 3;
    public static final int DEFAULT_STATISTIC_MAX_RT = 5000;
    private static final Map<String, String> props = new ConcurrentHashMap<String, String>();
    private static int appType = 0;
    private static final String appName = "";

    private ArmorConfig() {
    }

    private static void resolveAppType() {
        try {
            String type = ArmorConfig.getConfig(APP_TYPE_PROP_KEY);
            if (type == null) {
                appType = 0;
                return;
            }
            appType = Integer.parseInt(type);
            if (appType < 0) {
                appType = 0;
            }
        }
        catch (Exception ex) {
            appType = 0;
        }
    }

    private static void initialize() {
        ArmorConfig.setConfig(CHARSET, DEFAULT_CHARSET);
        ArmorConfig.setConfig(SINGLE_METRIC_FILE_SIZE, String.valueOf(0x3200000L));
        ArmorConfig.setConfig(TOTAL_METRIC_FILE_COUNT, String.valueOf(6));
        ArmorConfig.setConfig(COLD_FACTOR, String.valueOf(3));
        ArmorConfig.setConfig(STATISTIC_MAX_RT, String.valueOf(5000));
    }

    private static void loadProps() {
        Properties properties = ArmorConfigLoader.getProperties();
        for (Map.Entry<Object, Object> next : properties.entrySet()) {
            ArmorConfig.setConfig((String)next.getKey(), (String)next.getValue());
        }
    }

    public static String getConfig(String key) {
        AssertUtil.notNull(key, "key cannot be null");
        return props.get(key);
    }

    public static void setConfig(String key, String value) {
        AssertUtil.notNull(key, "key cannot be null");
        AssertUtil.notNull(value, "value cannot be null");
        props.put(key, value);
    }

    public static String removeConfig(String key) {
        AssertUtil.notNull(key, "key cannot be null");
        return props.remove(key);
    }

    public static void setConfigIfAbsent(String key, String value) {
        AssertUtil.notNull(key, "key cannot be null");
        AssertUtil.notNull(value, "value cannot be null");
        String v = props.get(key);
        if (v == null) {
            props.put(key, value);
        }
    }

    public static long metricLogFlushIntervalSec() {
        String flushIntervalStr = ArmorConfig.getConfig("armor.metric.flush.interval");
        if (flushIntervalStr == null) {
            return 10L;
        }
        try {
            return Long.parseLong(flushIntervalStr);
        }
        catch (Exception t) {
            RecordLog.warn("[ArmorConfig] Parse the metricLogFlushInterval fail, use default value: 1", t);
            return 10L;
        }
    }

    public static int getAppType() {
        return appType;
    }

    public static String charset() {
        return props.get(CHARSET);
    }

    public static long singleMetricFileSize() {
        try {
            return Long.parseLong(props.get(SINGLE_METRIC_FILE_SIZE));
        }
        catch (Throwable throwable) {
            RecordLog.warn(" [ArmorConfig] Parse singleMetricFileSize fail, use default value: 52428800", throwable);
            return 0x3200000L;
        }
    }

    public static int totalMetricFileCount() {
        try {
            return Integer.parseInt(props.get(TOTAL_METRIC_FILE_COUNT));
        }
        catch (Throwable throwable) {
            RecordLog.warn(" [ArmorConfig] Parse totalMetricFileCount fail, use default value: 6", throwable);
            return 6;
        }
    }

    public static int coldFactor() {
        try {
            int coldFactor = Integer.parseInt(props.get(COLD_FACTOR));
            if (coldFactor <= 1) {
                coldFactor = 3;
                RecordLog.warn("cold factor=" + coldFactor + ", should be larger than 1, use default value: " + 3, new Object[0]);
            }
            return coldFactor;
        }
        catch (Throwable throwable) {
            RecordLog.warn(" [ArmorConfig] Parse coldFactor fail, use default value: 3", throwable);
            return 3;
        }
    }

    public static int statisticMaxRt() {
        String v = props.get(STATISTIC_MAX_RT);
        try {
            if (StringUtil.isEmpty(v)) {
                return 5000;
            }
            return Integer.parseInt(v);
        }
        catch (Throwable throwable) {
            RecordLog.warn(" [ArmorConfig] Invalid statisticMaxRt value: {}, using the default value instead: 5000", v, throwable);
            ArmorConfig.setConfig(STATISTIC_MAX_RT, String.valueOf(5000));
            return 5000;
        }
    }

    private static String toEnvKey(String propKey) {
        return propKey.toUpperCase().replace('.', '_');
    }

    static {
        try {
            ArmorConfig.initialize();
            ArmorConfig.loadProps();
            ArmorConfig.resolveAppType();
        }
        catch (Throwable ex) {
            RecordLog.warn("[ArmorConfig] Failed to initialize", ex);
        }
    }
}

