/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.config;

import java.util.Map;
import java.util.Properties;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.util.ConfigUtil;
import kd.bos.armor.core.util.StringUtil;

public final class ArmorConfigLoader {
    public static final String SENTINEL_CONFIG_ENV_KEY = "ARMOR_CONFIG_FILE";
    public static final String SENTINEL_CONFIG_PROPERTY_KEY = "armor.config.file";
    private static final String DEFAULT_SENTINEL_CONFIG_FILE = "classpath:armor.properties";
    private static Properties properties = new Properties();

    private static void load() {
        Properties p;
        String fileName = System.getProperty(SENTINEL_CONFIG_PROPERTY_KEY);
        if (StringUtil.isBlank(fileName) && StringUtil.isBlank(fileName = System.getenv(SENTINEL_CONFIG_ENV_KEY))) {
            fileName = DEFAULT_SENTINEL_CONFIG_FILE;
        }
        if ((p = ConfigUtil.loadProperties(fileName)) != null && !p.isEmpty()) {
            properties.putAll((Map<?, ?>)p);
        }
    }

    public static Properties getProperties() {
        return properties;
    }

    static {
        try {
            ArmorConfigLoader.load();
        }
        catch (Throwable t) {
            RecordLog.warn("[ArmorConfigLoader] Failed to initialize configuration items", t);
        }
    }
}

