/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.context;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.armor.core.Constants;
import kd.bos.armor.core.EntryType;
import kd.bos.armor.core.context.Context;
import kd.bos.armor.core.context.ContextNameDefineException;
import kd.bos.armor.core.context.NullContext;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.node.DefaultNode;
import kd.bos.armor.core.node.EntranceNode;
import kd.bos.armor.core.slotchain.StringResourceWrapper;

public class ContextUtil {
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Context NULL_CONTEXT = new NullContext();
    private static ThreadLocal<Context> contextHolder = new ThreadLocal();
    private static volatile Map<String, DefaultNode> contextNameNodeMap = new HashMap<String, DefaultNode>();
    private static boolean shouldWarn = true;

    private static void initDefaultContext() {
        String defaultContextName = "sentinel_default_context";
        EntranceNode node = new EntranceNode(new StringResourceWrapper(defaultContextName, EntryType.IN), null);
        Constants.ROOT.addChild(node);
        contextNameNodeMap.put(defaultContextName, node);
    }

    static void resetContextMap() {
        if (contextNameNodeMap != null) {
            RecordLog.warn("Context map cleared and reset to initial state", new Object[0]);
            contextNameNodeMap.clear();
            ContextUtil.initDefaultContext();
        }
    }

    public static Context enter(String name, String tenantId, String origin) {
        if ("sentinel_default_context".equals(name)) {
            throw new ContextNameDefineException("The sentinel_default_context can't be permit to defined!");
        }
        return ContextUtil.trueEnter(name, tenantId, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Context trueEnter(String name, String tenantId, String origin) {
        Context context = contextHolder.get();
        if (context == null) {
            Map<String, DefaultNode> localCacheNameMap = contextNameNodeMap;
            DefaultNode node = localCacheNameMap.get(name);
            if (node == null) {
                if (localCacheNameMap.size() > 2000) {
                    ContextUtil.setNullContext();
                    return NULL_CONTEXT;
                }
                LOCK.lock();
                try {
                    node = contextNameNodeMap.get(name);
                    if (node == null) {
                        if (contextNameNodeMap.size() > 2000) {
                            ContextUtil.setNullContext();
                            Context context2 = NULL_CONTEXT;
                            return context2;
                        }
                        node = new EntranceNode(new StringResourceWrapper(name, EntryType.IN), null);
                        Constants.ROOT.addChild(node);
                        HashMap<String, DefaultNode> newMap = new HashMap<String, DefaultNode>(contextNameNodeMap.size() + 1);
                        newMap.putAll(contextNameNodeMap);
                        newMap.put(name, node);
                        contextNameNodeMap = newMap;
                    }
                }
                finally {
                    LOCK.unlock();
                }
            }
            context = new Context(node, name);
            context.setOrigin(origin);
            context.setTenantId(tenantId);
            contextHolder.set(context);
        }
        return context;
    }

    private static void setNullContext() {
        contextHolder.set(NULL_CONTEXT);
        if (shouldWarn) {
            RecordLog.warn("[ArmorStatusChecker] WARN: Amount of context exceeds the threshold 2000. Entries in new contexts will NOT take effect!", new Object[0]);
            shouldWarn = false;
        }
    }

    public static Context enter(String name) {
        return ContextUtil.enter(name, "", "");
    }

    public static void exit() {
        Context context = contextHolder.get();
        if (context != null && context.getCurEntry() == null) {
            contextHolder.set(null);
        }
    }

    public static int contextSize() {
        return contextNameNodeMap.size();
    }

    public static boolean isDefaultContext(Context context) {
        if (context == null) {
            return false;
        }
        return "sentinel_default_context".equals(context.getName());
    }

    public static Context getContext() {
        return contextHolder.get();
    }

    static Context replaceContext(Context newContext) {
        Context backupContext = contextHolder.get();
        if (newContext == null) {
            contextHolder.remove();
        } else {
            contextHolder.set(newContext);
        }
        return backupContext;
    }

    public static void runOnContext(Context context, Runnable f) {
        Context curContext = ContextUtil.replaceContext(context);
        try {
            f.run();
        }
        finally {
            ContextUtil.replaceContext(curContext);
        }
    }
}

