/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.init;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.armor.core.init.InitFunc;
import kd.bos.armor.core.init.InitOrder;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.spi.ServiceLoaderUtil;

public final class InitExecutor {
    private static AtomicBoolean initialized = new AtomicBoolean(false);

    private InitExecutor() {
    }

    public static void doInit() {
        if (!initialized.compareAndSet(false, true)) {
            return;
        }
        try {
            ServiceLoader<InitFunc> loader = ServiceLoaderUtil.getServiceLoader(InitFunc.class);
            ArrayList<OrderWrapper> initList = new ArrayList<OrderWrapper>();
            for (InitFunc initFunc : loader) {
                RecordLog.info("[InitExecutor] Found init func: {}", initFunc.getClass().getCanonicalName());
                InitExecutor.insertSorted(initList, initFunc);
            }
            for (OrderWrapper w : initList) {
                w.func.init();
                RecordLog.info("[InitExecutor] Executing {} with order {}", w.func.getClass().getCanonicalName(), w.order);
            }
        }
        catch (Exception ex) {
            RecordLog.warn("[InitExecutor] WARN: Initialization failed", ex);
        }
        catch (Error error) {
            RecordLog.warn("[InitExecutor] ERROR: Initialization failed with fatal error", error);
        }
    }

    private static void insertSorted(List<OrderWrapper> list, InitFunc func) {
        int idx;
        int order = InitExecutor.resolveOrder(func);
        for (idx = 0; idx < list.size() && list.get(idx).getOrder() <= order; ++idx) {
        }
        list.add(idx, new OrderWrapper(order, func));
    }

    private static int resolveOrder(InitFunc func) {
        if (!func.getClass().isAnnotationPresent(InitOrder.class)) {
            return Integer.MAX_VALUE;
        }
        return func.getClass().getAnnotation(InitOrder.class).value();
    }

    private static class OrderWrapper {
        private final int order;
        private final InitFunc func;

        OrderWrapper(int order, InitFunc func) {
            this.order = order;
            this.func = func;
        }

        int getOrder() {
            return this.order;
        }

        InitFunc getFunc() {
            return this.func;
        }
    }
}

