/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.node;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.armor.core.node.IntervalProperty;
import kd.bos.armor.core.node.Node;
import kd.bos.armor.core.node.OccupyTimeoutProperty;
import kd.bos.armor.core.node.SampleCountProperty;
import kd.bos.armor.core.node.metric.MetricNode;
import kd.bos.armor.core.slots.statistic.base.LongAdder;
import kd.bos.armor.core.slots.statistic.metric.ArrayMetric;
import kd.bos.armor.core.slots.statistic.metric.Metric;
import kd.bos.armor.core.util.TimeUtil;
import kd.bos.armor.core.util.function.Predicate;

public class StatisticNode
implements Node {
    private int interval;
    private volatile transient Metric rollingCounterInSecond;
    private transient Metric rollingCounterInMinute = new ArrayMetric(60, 60000, false);
    private LongAdder curThreadNum = new LongAdder();
    private long lastFetchTime = -1L;

    @Override
    public Map<Long, MetricNode> metrics() {
        long currentTime = TimeUtil.currentTimeMillis();
        currentTime -= currentTime % 1000L;
        ConcurrentHashMap<Long, MetricNode> metrics = new ConcurrentHashMap<Long, MetricNode>();
        List<MetricNode> nodesOfEverySecond = this.rollingCounterInMinute.details();
        long newLastFetchTime = this.lastFetchTime;
        for (MetricNode node : nodesOfEverySecond) {
            if (!this.isNodeInTime(node, currentTime) || !this.isValidMetricNode(node)) continue;
            metrics.put(node.getTimestamp(), node);
            newLastFetchTime = Math.max(newLastFetchTime, node.getTimestamp());
        }
        this.lastFetchTime = newLastFetchTime;
        return metrics;
    }

    @Override
    public List<MetricNode> rawMetricsInMin(Predicate<Long> timePredicate) {
        return this.rollingCounterInMinute.detailsOnCondition(timePredicate);
    }

    private boolean isNodeInTime(MetricNode node, long currentTime) {
        return node.getTimestamp() > this.lastFetchTime && node.getTimestamp() < currentTime;
    }

    private boolean isValidMetricNode(MetricNode node) {
        return node.getPassQps() > 0L || node.getBlockQps() > 0L || node.getSuccessQps() > 0L || node.getExceptionQps() > 0L || node.getRt() > 0L || node.getOccupiedPassQps() > 0L;
    }

    @Override
    public void reset(int sampleCount, int interval) {
        this.interval = interval;
        this.rollingCounterInSecond = new ArrayMetric(sampleCount, interval);
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public long totalRequest() {
        return this.rollingCounterInMinute.pass() + this.rollingCounterInMinute.block();
    }

    @Override
    public long blockRequest() {
        return this.rollingCounterInMinute.block();
    }

    @Override
    public double blockQps() {
        if (this.rollingCounterInSecond == null) {
            return 0.0;
        }
        return (double)this.rollingCounterInSecond.block() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public double previousBlockQps() {
        return this.rollingCounterInMinute.previousWindowBlock();
    }

    @Override
    public double previousPassQps() {
        return this.rollingCounterInMinute.previousWindowPass();
    }

    @Override
    public double totalQps() {
        return this.passQps() + this.blockQps();
    }

    @Override
    public long totalSuccess() {
        return this.rollingCounterInMinute.success();
    }

    @Override
    public double exceptionQps() {
        if (this.rollingCounterInSecond == null) {
            return 0.0;
        }
        return (double)this.rollingCounterInSecond.exception() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public long totalException() {
        return this.rollingCounterInMinute.exception();
    }

    @Override
    public double passQps() {
        if (this.rollingCounterInSecond == null) {
            return 0.0;
        }
        return this.rollingCounterInSecond.pass();
    }

    @Override
    public long totalPass() {
        return this.rollingCounterInMinute.pass();
    }

    @Override
    public double successQps() {
        if (this.rollingCounterInSecond == null) {
            return 0.0;
        }
        return (double)this.rollingCounterInSecond.success() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public double maxSuccessQps() {
        if (this.rollingCounterInSecond == null) {
            return 0.0;
        }
        return (double)this.rollingCounterInSecond.maxSuccess() * (double)this.rollingCounterInSecond.getSampleCount() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public double occupiedPassQps() {
        if (this.rollingCounterInSecond == null) {
            return 0.0;
        }
        return (double)this.rollingCounterInSecond.occupiedPass() / this.rollingCounterInSecond.getWindowIntervalInSec();
    }

    @Override
    public double avgRt() {
        if (this.rollingCounterInSecond == null) {
            return 0.0;
        }
        long successCount = this.rollingCounterInSecond.success();
        if (successCount == 0L) {
            return 0.0;
        }
        return (double)this.rollingCounterInSecond.rt() * 1.0 / (double)successCount;
    }

    @Override
    public double minRt() {
        if (this.rollingCounterInSecond == null) {
            return 0.0;
        }
        return this.rollingCounterInSecond.minRt();
    }

    @Override
    public int curThreadNum() {
        return (int)this.curThreadNum.sum();
    }

    @Override
    public void addPassRequest(int count) {
        if (this.rollingCounterInSecond != null) {
            this.rollingCounterInSecond.addPass(count);
        }
        this.rollingCounterInMinute.addPass(count);
    }

    @Override
    public void addRtAndSuccess(long rt, int successCount) {
        if (this.rollingCounterInSecond != null) {
            this.rollingCounterInSecond.addSuccess(successCount);
            this.rollingCounterInSecond.addRT(rt);
        }
        this.rollingCounterInMinute.addSuccess(successCount);
        this.rollingCounterInMinute.addRT(rt);
    }

    @Override
    public void increaseBlockQps(int count) {
        if (this.rollingCounterInSecond != null) {
            this.rollingCounterInSecond.addBlock(count);
        }
        this.rollingCounterInMinute.addBlock(count);
    }

    @Override
    public void increaseExceptionQps(int count) {
        if (this.rollingCounterInSecond != null) {
            this.rollingCounterInSecond.addException(count);
        }
        this.rollingCounterInMinute.addException(count);
    }

    @Override
    public void increaseThreadNum() {
        this.curThreadNum.increment();
    }

    @Override
    public void decreaseThreadNum() {
        this.curThreadNum.decrement();
    }

    @Override
    public void debug() {
        if (this.rollingCounterInSecond != null) {
            this.rollingCounterInSecond.debug();
        }
    }

    @Override
    public long tryOccupyNext(long currentTime, int acquireCount, double threshold) {
        long waitInMs;
        double maxCount = threshold * (double)IntervalProperty.INTERVAL / 1000.0;
        long currentBorrow = 0L;
        if (this.rollingCounterInSecond != null) {
            currentBorrow = this.rollingCounterInSecond.waiting();
        }
        if ((double)currentBorrow >= maxCount) {
            return OccupyTimeoutProperty.getOccupyTimeout();
        }
        int windowLength = IntervalProperty.INTERVAL / SampleCountProperty.SAMPLE_COUNT;
        long earliestTime = currentTime - currentTime % (long)windowLength + (long)windowLength - (long)IntervalProperty.INTERVAL;
        int idx = 0;
        long currentPass = 0L;
        if (this.rollingCounterInSecond != null) {
            currentPass = this.rollingCounterInSecond.pass();
        }
        while (earliestTime < currentTime && (waitInMs = (long)(idx * windowLength + windowLength) - currentTime % (long)windowLength) < (long)OccupyTimeoutProperty.getOccupyTimeout()) {
            long windowPass = 0L;
            if (this.rollingCounterInSecond != null) {
                windowPass = this.rollingCounterInSecond.getWindowPass(earliestTime);
            }
            if ((double)(currentPass + currentBorrow + (long)acquireCount - windowPass) <= maxCount) {
                return waitInMs;
            }
            earliestTime += (long)windowLength;
            currentPass -= windowPass;
            ++idx;
        }
        return OccupyTimeoutProperty.getOccupyTimeout();
    }

    @Override
    public long waiting() {
        if (this.rollingCounterInSecond != null) {
            return 0L;
        }
        return this.rollingCounterInSecond.waiting();
    }

    @Override
    public void addWaitingRequest(long futureTime, int acquireCount) {
        if (this.rollingCounterInSecond != null) {
            this.rollingCounterInSecond.addWaiting(futureTime, acquireCount);
        }
    }

    @Override
    public void addOccupiedPass(int acquireCount) {
        this.rollingCounterInMinute.addOccupiedPass(acquireCount);
        this.rollingCounterInMinute.addPass(acquireCount);
    }
}

