/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.node.metric;

import java.text.SimpleDateFormat;
import java.util.Date;

public class MetricNode {
    private String tenantId;
    private String resource;
    private int classification;
    private long timestamp;
    private long passQps;
    private long blockQps;
    private long successQps;
    private long exceptionQps;
    private long rt;
    private long totalRt;
    private long occupiedPassQps;
    private int concurrency;

    public static MetricNode fromThinString(String line) {
        MetricNode node = new MetricNode();
        String[] strs = line.split("\\|");
        node.setTimestamp(Long.parseLong(strs[0]));
        node.setResource(strs[1]);
        node.setPassQps(Long.parseLong(strs[2]));
        node.setBlockQps(Long.parseLong(strs[3]));
        node.setSuccessQps(Long.parseLong(strs[4]));
        node.setExceptionQps(Long.parseLong(strs[5]));
        node.setRt(Long.parseLong(strs[6]));
        if (strs.length >= 8) {
            node.setOccupiedPassQps(Long.parseLong(strs[7]));
        }
        if (strs.length >= 9) {
            node.setConcurrency(Integer.parseInt(strs[8]));
        }
        if (strs.length == 10) {
            node.setClassification(Integer.parseInt(strs[9]));
        }
        return node;
    }

    public static MetricNode fromFatString(String line) {
        String[] strs = line.split("\\|");
        Long time = Long.parseLong(strs[0]);
        MetricNode node = new MetricNode();
        node.setTimestamp(time);
        node.setResource(strs[2]);
        node.setPassQps(Long.parseLong(strs[3]));
        node.setBlockQps(Long.parseLong(strs[4]));
        node.setSuccessQps(Long.parseLong(strs[5]));
        node.setExceptionQps(Long.parseLong(strs[6]));
        node.setRt(Long.parseLong(strs[7]));
        if (strs.length >= 9) {
            node.setOccupiedPassQps(Long.parseLong(strs[8]));
        }
        if (strs.length >= 10) {
            node.setConcurrency(Integer.parseInt(strs[9]));
        }
        if (strs.length == 11) {
            node.setClassification(Integer.parseInt(strs[10]));
        }
        return node;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getOccupiedPassQps() {
        return this.occupiedPassQps;
    }

    public void setOccupiedPassQps(long occupiedPassQps) {
        this.occupiedPassQps = occupiedPassQps;
    }

    public long getSuccessQps() {
        return this.successQps;
    }

    public void setSuccessQps(long successQps) {
        this.successQps = successQps;
    }

    public long getPassQps() {
        return this.passQps;
    }

    public void setPassQps(long passQps) {
        this.passQps = passQps;
    }

    public long getExceptionQps() {
        return this.exceptionQps;
    }

    public void setExceptionQps(long exceptionQps) {
        this.exceptionQps = exceptionQps;
    }

    public long getBlockQps() {
        return this.blockQps;
    }

    public void setBlockQps(long blockQps) {
        this.blockQps = blockQps;
    }

    public long getRt() {
        return this.rt;
    }

    public void setRt(long rt) {
        this.rt = rt;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public int getClassification() {
        return this.classification;
    }

    public MetricNode setClassification(int classification) {
        this.classification = classification;
        return this;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public MetricNode setConcurrency(int concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public long getTotalRt() {
        return this.totalRt;
    }

    public void setTotalRt(long totalRt) {
        this.totalRt = totalRt;
    }

    public String toString() {
        return "MetricNode{resource='" + this.resource + '\'' + ", tenantId=" + this.tenantId + ", classification=" + this.classification + ", timestamp=" + this.timestamp + ", passQps=" + this.passQps + ", blockQps=" + this.blockQps + ", successQps=" + this.successQps + ", exceptionQps=" + this.exceptionQps + ", rt=" + this.rt + ", concurrency=" + this.concurrency + ", occupiedPassQps=" + this.occupiedPassQps + '}';
    }

    public String toThinString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timestamp).append("|");
        String legalName = this.resource.replaceAll("\\|", "_");
        sb.append(legalName).append("|");
        sb.append(this.passQps).append("|");
        sb.append(this.blockQps).append("|");
        sb.append(this.successQps).append("|");
        sb.append(this.exceptionQps).append("|");
        sb.append(this.rt).append("|");
        sb.append(this.occupiedPassQps).append("|");
        sb.append(this.concurrency).append("|");
        sb.append(this.classification);
        return sb.toString();
    }

    public String toFatString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        StringBuilder sb = new StringBuilder(32);
        sb.delete(0, sb.length());
        sb.append(this.getTimestamp()).append("|");
        sb.append(df.format(new Date(this.getTimestamp()))).append("|");
        String legalName = this.getResource().replaceAll("\\|", "_");
        sb.append(legalName).append("|");
        sb.append(this.getPassQps()).append("|");
        sb.append(this.getBlockQps()).append("|");
        sb.append(this.getSuccessQps()).append("|");
        sb.append(this.getExceptionQps()).append("|");
        sb.append(this.getRt()).append("|");
        sb.append(this.getOccupiedPassQps()).append("|");
        sb.append(this.concurrency).append("|");
        sb.append(this.classification);
        sb.append('\n');
        return sb.toString();
    }
}

