/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.node.metric;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.node.ClusterNode;
import kd.bos.armor.core.node.metric.MetricNode;
import kd.bos.armor.core.slotchain.ResourceWrapper;
import kd.bos.armor.core.slots.clusterbuilder.ClusterBuilderSlot;
import kd.bos.armor.transport.command.vo.NodeVo;
import kd.bos.govern.GovernDataType;
import kd.bos.govern.StorageReporterFactory;

public class MetricTimerListener
implements Runnable {
    @Override
    public void run() {
        TreeMap<Long, List<MetricNode>> maps = new TreeMap<Long, List<MetricNode>>();
        for (Map.Entry<ResourceWrapper, ClusterNode> entry : ClusterBuilderSlot.getClusterNodeMap().entrySet()) {
            ClusterNode node = entry.getValue();
            Map<Long, MetricNode> metrics = node.metrics();
            this.aggregate(maps, metrics, node);
        }
        if (!maps.isEmpty()) {
            for (Map.Entry<ResourceWrapper, ClusterNode> entry : maps.entrySet()) {
                try {
                    this.report((List)((Object)entry.getValue()));
                }
                catch (Exception e) {
                    RecordLog.warn("[MetricTimerListener] Write metric error", e);
                }
            }
        }
    }

    private void report(List<MetricNode> metricNodes) {
        try {
            ArrayList<NodeVo> list = new ArrayList<NodeVo>(metricNodes.size());
            for (MetricNode metricNode : metricNodes) {
                NodeVo nodeVo = NodeVo.fromMetricNode(metricNode);
                list.add(nodeVo);
            }
            if (list.size() > 0) {
                StorageReporterFactory.getStorageReporter((GovernDataType)GovernDataType.ARMOR).reporter(list);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void aggregate(Map<Long, List<MetricNode>> maps, Map<Long, MetricNode> metrics, ClusterNode node) {
        for (Map.Entry<Long, MetricNode> entry : metrics.entrySet()) {
            long time = entry.getKey();
            MetricNode metricNode = entry.getValue();
            metricNode.setTenantId(node.getTenantId());
            metricNode.setResource(node.getName());
            metricNode.setClassification(node.getResourceType());
            metricNode.setConcurrency(node.curThreadNum());
            if (maps.get(time) == null) {
                maps.put(time, new ArrayList());
            }
            List<MetricNode> nodes = maps.get(time);
            nodes.add(entry.getValue());
        }
    }
}

