/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ArmorSlotUtil {
    public static <T> List<T> getWildcardRules(String resource, List<String> sortedKeys, Map<String, List<T>> armorRuleMap) {
        if (armorRuleMap == null || armorRuleMap.size() == 0) {
            return null;
        }
        List<T> armorRules = armorRuleMap.get(resource);
        if (armorRules != null && armorRules.size() > 0) {
            return armorRules;
        }
        for (String wildcardResource : sortedKeys) {
            if (!ArmorSlotUtil.matchWithWildcard(wildcardResource, resource)) continue;
            return armorRuleMap.get(wildcardResource);
        }
        return null;
    }

    private static boolean matchWithWildcard(String rule, String resource) {
        if (!rule.contains("*")) {
            return false;
        }
        String[] ruleParts = rule.split("\\*");
        int startIndex = 0;
        for (String part : ruleParts) {
            int index = resource.indexOf(part, startIndex);
            if (index == -1) {
                return false;
            }
            startIndex = index + part.length();
        }
        return true;
    }

    public static <T> List<String> sortRuleMapKeys(Map<String, List<T>> ruleMap) {
        if (ruleMap == null || ruleMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> sortedKeys = new ArrayList<String>(ruleMap.keySet());
        sortedKeys.sort((a, b) -> {
            int compareLength = b.length() - a.length();
            if (compareLength != 0) {
                return compareLength;
            }
            return ArmorSlotUtil.countWildcards(a) - ArmorSlotUtil.countWildcards(b);
        });
        return sortedKeys;
    }

    private static int countWildcards(String rule) {
        return (int)rule.chars().filter(ch -> ch == 42).count();
    }
}

