/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block.flow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.armor.core.concurrent.NamedThreadFactory;
import kd.bos.armor.core.config.ArmorConfig;
import kd.bos.armor.core.log.RecordLog;
import kd.bos.armor.core.node.metric.MetricTimerListener;
import kd.bos.armor.core.property.ArmorProperty;
import kd.bos.armor.core.property.DynamicArmorProperty;
import kd.bos.armor.core.property.PropertyListener;
import kd.bos.armor.core.slots.block.flow.FlowRule;
import kd.bos.armor.core.slots.block.flow.FlowRuleUtil;
import kd.bos.armor.core.util.AssertUtil;
import kd.bos.armor.core.util.StringUtil;
import kd.bos.armor.transport.datasource.ReadableDataSource;

public class FlowRuleManager {
    private static final AtomicReference<Map<String, List<FlowRule>>> flowRules = new AtomicReference();
    private static final AtomicReference<List<String>> flowRuleKeys = new AtomicReference();
    private static final FlowPropertyListener LISTENER = new FlowPropertyListener();
    private static ArmorProperty<List<FlowRule>> currentProperty = new DynamicArmorProperty<List<FlowRule>>();
    private static ReadableDataSource<String, List<FlowRule>> dataSource;
    private static final ScheduledExecutorService SCHEDULER;

    private static void startMetricTimerListener() {
        long flushInterval = ArmorConfig.metricLogFlushIntervalSec();
        if (flushInterval <= 0L) {
            RecordLog.info("[FlowRuleManager] The MetricTimerListener is'n started. If you want to start it, please change the value(current: {}) of config({}) more than 0 to start it.", flushInterval, "armor.metric.flush.interval");
        } else {
            SCHEDULER.scheduleAtFixedRate(new MetricTimerListener(), 0L, flushInterval, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDataSource(ReadableDataSource<String, List<FlowRule>> flowRuleDataSource) {
        AssertUtil.notNull(flowRuleDataSource, "property cannot be null");
        FlowPropertyListener flowPropertyListener = LISTENER;
        synchronized (flowPropertyListener) {
            dataSource = flowRuleDataSource;
            RecordLog.info("[FlowRuleManager] Registering new property to flow rule manager", new Object[0]);
            currentProperty.removeListener(LISTENER);
            flowRuleDataSource.getProperty().addListener(LISTENER);
            currentProperty = flowRuleDataSource.getProperty();
        }
    }

    public static ReadableDataSource<String, List<FlowRule>> getDataSource() {
        return dataSource;
    }

    public static List<FlowRule> getRules() {
        ArrayList<FlowRule> rules = new ArrayList<FlowRule>();
        for (Map.Entry<String, List<FlowRule>> entry : flowRules.get().entrySet()) {
            rules.addAll((Collection<FlowRule>)entry.getValue());
        }
        return rules;
    }

    public static void loadRules(List<FlowRule> rules) {
        currentProperty.updateValue(rules);
    }

    static Map<String, List<FlowRule>> getFlowRuleMap() {
        return flowRules.get();
    }

    static List<String> getFlowRuleKeys() {
        return flowRuleKeys.get();
    }

    public static boolean hasConfig(String resource) {
        return flowRules.get().containsKey(resource);
    }

    public static boolean isOtherOrigin(String origin, String resourceName) {
        if (StringUtil.isEmpty(origin)) {
            return false;
        }
        List<FlowRule> rules = flowRules.get().get(resourceName);
        if (rules != null) {
            for (FlowRule rule : rules) {
                if (!origin.equals(rule.getLimitApp())) continue;
                return false;
            }
        }
        return true;
    }

    static {
        SCHEDULER = Executors.newScheduledThreadPool(1, new NamedThreadFactory("Armor-metrics-record-task", true));
        flowRules.set(Collections.emptyMap());
        flowRuleKeys.set(Collections.emptyList());
        currentProperty.addListener(LISTENER);
        FlowRuleManager.startMetricTimerListener();
    }

    private static final class FlowPropertyListener
    implements PropertyListener<List<FlowRule>> {
        private FlowPropertyListener() {
        }

        @Override
        public void configUpdate(List<FlowRule> value) {
            Map<String, List<FlowRule>> rules = FlowRuleUtil.buildFlowRuleMap(value);
            List<String> ruleKeys = FlowRuleUtil.buildFlowRuleKeys(rules);
            flowRules.set(rules);
            flowRuleKeys.set(ruleKeys);
        }

        @Override
        public void configLoad(List<FlowRule> conf) {
            Map<String, List<FlowRule>> rules = FlowRuleUtil.buildFlowRuleMap(conf);
            List<String> ruleKeys = FlowRuleUtil.buildFlowRuleKeys(rules);
            flowRules.set(rules);
            flowRuleKeys.set(ruleKeys);
        }
    }
}

