/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.slots.block.flow.controller;

import java.util.concurrent.atomic.AtomicLong;
import kd.bos.armor.core.node.Node;
import kd.bos.armor.core.slots.block.flow.TrafficShapingController;
import kd.bos.armor.core.util.TimeUtil;

public class WarmUpController
implements TrafficShapingController {
    protected double count;
    protected int warningToken = 0;
    protected double slope;
    protected AtomicLong storedTokens = new AtomicLong(0L);
    protected AtomicLong lastFilledTime = new AtomicLong(0L);
    private int coldFactor;
    private int maxToken;

    public WarmUpController(double count, int warmUpPeriodInSec, int coldFactor) {
        this.construct(count, warmUpPeriodInSec, coldFactor);
    }

    public WarmUpController(double count, int warmUpPeriodInSec) {
        this.construct(count, warmUpPeriodInSec, 3);
    }

    private void construct(double count, int warmUpPeriodInSec, int coldFactor) {
        if (coldFactor <= 1) {
            throw new IllegalArgumentException("Cold factor should be larger than 1");
        }
        this.count = count;
        this.coldFactor = coldFactor;
        this.warningToken = (int)((double)warmUpPeriodInSec * count) / (coldFactor - 1);
        this.maxToken = this.warningToken + (int)((double)(2 * warmUpPeriodInSec) * count / (1.0 + (double)coldFactor));
        this.slope = ((double)coldFactor - 1.0) / count / (double)(this.maxToken - this.warningToken);
    }

    @Override
    public boolean canPass(Node node, int acquireCount) {
        return this.canPass(node, acquireCount, false);
    }

    @Override
    public boolean canPass(Node node, int acquireCount, boolean prioritized) {
        long passQps = (long)node.passQps();
        long previousQps = (long)node.previousPassQps();
        this.syncToken(previousQps);
        long restToken = this.storedTokens.get();
        if (restToken >= (long)this.warningToken) {
            long aboveToken = restToken - (long)this.warningToken;
            double warningQps = Math.nextUp(1.0 / ((double)aboveToken * this.slope + 1.0 / this.count));
            return (double)(passQps + (long)acquireCount) <= warningQps;
        }
        return (double)(passQps + (long)acquireCount) <= this.count;
    }

    protected void syncToken(long passQps) {
        long newValue;
        long currentTime = TimeUtil.currentTimeMillis();
        long oldLastFillTime = this.lastFilledTime.get();
        if ((currentTime -= currentTime % 1000L) <= oldLastFillTime) {
            return;
        }
        long oldValue = this.storedTokens.get();
        if (this.storedTokens.compareAndSet(oldValue, newValue = this.coolDownTokens(currentTime, passQps))) {
            long currentValue = this.storedTokens.addAndGet(0L - passQps);
            if (currentValue < 0L) {
                this.storedTokens.set(0L);
            }
            this.lastFilledTime.set(currentTime);
        }
    }

    private long coolDownTokens(long currentTime, long passQps) {
        long oldValue;
        long newValue = oldValue = this.storedTokens.get();
        if (oldValue < (long)this.warningToken) {
            newValue = (long)((double)oldValue + (double)(currentTime - this.lastFilledTime.get()) * this.count / 1000.0);
        } else if (oldValue > (long)this.warningToken && passQps < (long)((int)this.count / this.coldFactor)) {
            newValue = (long)((double)oldValue + (double)(currentTime - this.lastFilledTime.get()) * this.count / 1000.0);
        }
        return Math.min(newValue, (long)this.maxToken);
    }
}

