/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.core.util;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class MethodUtil {
    private static final Map<Method, String> methodNameMap = new ConcurrentHashMap<Method, String>();
    private static final Object LOCK = new Object();

    public static String resolveMethodName(Method method) {
        if (method == null) {
            throw new IllegalArgumentException("Null method");
        }
        String methodName = methodNameMap.computeIfAbsent(method, key -> {
            StringBuilder sb = new StringBuilder();
            String className = method.getDeclaringClass().getName();
            String name = method.getName();
            Class<?>[] params = method.getParameterTypes();
            sb.append(className).append(":").append(name);
            sb.append("(");
            int paramPos = 0;
            for (Class<?> clazz : params) {
                sb.append(clazz.getCanonicalName());
                if (++paramPos >= params.length) continue;
                sb.append(",");
            }
            sb.append(")");
            return sb.toString();
        });
        return methodName;
    }

    static void clearMethodMap() {
        methodNameMap.clear();
    }
}

