/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.armor.transport.datasource;

import kd.bos.armor.core.property.ArmorProperty;
import kd.bos.armor.core.property.DynamicArmorProperty;
import kd.bos.armor.transport.datasource.Converter;
import kd.bos.armor.transport.datasource.ReadableDataSource;

public abstract class AbstractDataSource<S, T>
implements ReadableDataSource<S, T> {
    protected final Converter<S, T> parser;
    protected final ArmorProperty<T> property;

    public AbstractDataSource(Converter<S, T> parser) {
        if (parser == null) {
            throw new IllegalArgumentException("parser can't be null");
        }
        this.parser = parser;
        this.property = new DynamicArmorProperty();
    }

    @Override
    public T loadConfig() throws Exception {
        return this.loadConfig(this.readSource());
    }

    public T loadConfig(S conf) throws Exception {
        T value = this.parser.convert(conf);
        return value;
    }

    @Override
    public ArmorProperty<T> getProperty() {
        return this.property;
    }
}

