/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.fake.mq.rabbitmqfake;

import kd.bos.exception.KDException;
import kd.bos.fake.FakeErrorCode;
import kd.bos.fake.mq.rabbitmqfake.Consume;
import kd.bos.fake.mq.rabbitmqfake.exchange.Exchange;
import kd.bos.fake.mq.rabbitmqfake.exchange.ExchangeEngine;
import kd.bos.fake.mq.rabbitmqfake.queue.QueueFake;

public class Channel {
    public static void queueDeclare(String exchangeName, String queueName) {
        ExchangeEngine.exchangeDeclare(exchangeName);
        Exchange exchange = ExchangeEngine.getExchange(exchangeName);
        if (queueName != null) {
            exchange.setBroadCast(false);
            exchange.initQueue(queueName, new QueueFake());
        } else {
            exchange.setBroadCast(true);
        }
    }

    public static void basicConsume(String exchangeName, String queueName, Consume consumer) {
        Exchange exchange = ExchangeEngine.getExchange(exchangeName);
        if (exchange == null) {
            throw new KDException(FakeErrorCode.mqFakeInitException, new Object[]{" exchange has`t declare"});
        }
        if (exchange.isBroadCast()) {
            String broadcastQueueName = "broadcast-" + consumer.hashCode();
            QueueFake q = new QueueFake();
            exchange.initQueue(broadcastQueueName, q);
            q.setConsumer(consumer);
        } else {
            QueueFake q = exchange.getQueue(queueName);
            if (q == null) {
                throw new KDException(FakeErrorCode.mqFakeInitException, new Object[]{" queue has`t declare:" + queueName});
            }
            q.setConsumer(consumer);
        }
    }

    public static void publish(String exchangeName, String queueName, Object arg0) {
        ExchangeEngine.publish(exchangeName, queueName, arg0);
    }
}

