/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo;

import kd.bos.algo.AlgoEnv;
import kd.bos.algo.AlgoException;

public class AlgoConfig {
    private String key;

    public AlgoConfig(String key) {
        this.key = key;
    }

    public AlgoEnv getEnv() {
        return this.getEnv(null);
    }

    public AlgoEnv getEnv(AlgoEnv defaultEnv) {
        String configKey = this.getConfigKeyForEnv();
        String v = System.getProperty(configKey);
        if (v == null) {
            v = System.getenv(configKey);
        }
        if (v != null) {
            AlgoEnv env = AlgoEnv.of(v);
            if (env == null) {
                throw new AlgoException("error algo env config for " + configKey + ":" + v);
            }
            return env;
        }
        return defaultEnv;
    }

    private String getConfigKeyForEnv() {
        return "algo." + this.key + ".env";
    }

    public String getKey() {
        return this.key;
    }
}

