/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.algo;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.config.AlgoConfiguration;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class CacheHint
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String KEY_DEFAULT_TIMEOUT = "algo.cacheDataSet.defaultTimeout";
    public static final int DefaultTimeout = 3600000;
    private long timeout = -1L;
    private int pageSize = -1;
    private String cacheId;
    private String storageType;
    private int allowMaxRows = -1;
    private boolean throwExceptionWhenExceedAllowMaxRows = true;
    private int dataSetCahceMaxRows = AlgoConfiguration.DATASETCACHE_MAXROWS.getInt();

    public static CacheHint getDefault() {
        return new CacheHint();
    }

    public long getTimeout() {
        if (this.timeout <= 0L) {
            return AlgoConfiguration.DATASETCACHE_TIMEOUT.getLong();
        }
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.setTimeout(timeout, TimeUnit.MILLISECONDS);
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
    }

    public int getPageSize() {
        if (this.pageSize <= 0) {
            return AlgoConfiguration.DATASETCACHE_PAGESIZE.getInt();
        }
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getCacheId() {
        return this.cacheId;
    }

    public void setCacheId(String cacheId) {
        this.cacheId = cacheId;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public int getAllowMaxRows() {
        if (this.allowMaxRows <= 0) {
            return this.dataSetCahceMaxRows;
        }
        return this.allowMaxRows;
    }

    public void setAllowMaxRows(int allowMaxRows) {
        this.allowMaxRows = allowMaxRows;
    }

    public boolean isThrowExceptionWhenExceedAllowMaxRows() {
        return this.throwExceptionWhenExceedAllowMaxRows;
    }

    public void setThrowExceptionWhenExceedAllowMaxRows(boolean throwExceptionWhenExceedAllowMaxRows) {
        this.throwExceptionWhenExceedAllowMaxRows = throwExceptionWhenExceedAllowMaxRows;
    }
}

